/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.service;

import com.axelor.apps.base.db.Blocking;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.SupplierCatalog;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.purchase.service.PurchaseOrderLineService;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.suppliermanagement.service.PurchaseOrderSupplierLineService;
import com.axelor.apps.supplychain.service.PurchaseOrderServiceSupplychainImpl;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseOrderSupplierService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private PurchaseOrderSupplierLineService purchaseOrderSupplierLineService;
    @Inject
    private PurchaseOrderServiceSupplychainImpl purchaseOrderServiceSupplychainImpl;
    @Inject
    private PurchaseOrderLineService purchaseOrderLineService;
    @Inject
    protected PurchaseOrderRepository poRepo;

    @Transactional
    public void generateAllSuppliersRequests(PurchaseOrder purchaseOrder) {
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrder.getPurchaseOrderLineList()) {
            this.generateSuppliersRequests(purchaseOrderLine);
        }
        this.poRepo.save((Model)((Object)purchaseOrder));
    }

    @Transactional
    public void generateSuppliersRequests(PurchaseOrderLine purchaseOrderLine) {
        this.generateSuppliersRequests(purchaseOrderLine, purchaseOrderLine.getPurchaseOrder());
    }

    @Transactional
    public void generateSuppliersRequests(PurchaseOrderLine purchaseOrderLine, PurchaseOrder purchaseOrder) {
        if (purchaseOrder == null) {
            return;
        }
        Product product = purchaseOrderLine.getProduct();
        Company company = purchaseOrder.getCompany();
        if (((AppPurchaseService)Beans.get(AppPurchaseService.class)).getAppPurchase().getManageSupplierCatalog().booleanValue() && product != null && product.getSupplierCatalogList() != null) {
            for (SupplierCatalog supplierCatalog : product.getSupplierCatalogList()) {
                Partner supplierPartner = supplierCatalog.getSupplierPartner();
                Blocking blocking = ((BlockingService)Beans.get(BlockingService.class)).getBlocking(supplierPartner, company, 6);
                if (blocking != null) continue;
                purchaseOrderLine.addPurchaseOrderSupplierLineListItem(this.purchaseOrderSupplierLineService.create(supplierPartner, supplierCatalog.getPrice()));
            }
        }
        ((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).save((Model)((Object)purchaseOrderLine));
    }

    @Transactional(rollbackOn={Exception.class})
    public void generateSuppliersPurchaseOrder(PurchaseOrder purchaseOrder) throws AxelorException {
        if (purchaseOrder.getPurchaseOrderLineList() == null) {
            return;
        }
        Map<Partner, List<PurchaseOrderLine>> purchaseOrderLinesBySupplierPartner = this.splitBySupplierPartner(purchaseOrder.getPurchaseOrderLineList());
        for (Partner supplierPartner : purchaseOrderLinesBySupplierPartner.keySet()) {
            this.createPurchaseOrder(supplierPartner, purchaseOrderLinesBySupplierPartner.get((Object)supplierPartner), purchaseOrder);
        }
        this.poRepo.save((Model)((Object)purchaseOrder));
    }

    public Map<Partner, List<PurchaseOrderLine>> splitBySupplierPartner(List<PurchaseOrderLine> purchaseOrderLineList) throws AxelorException {
        HashMap<Partner, List<PurchaseOrderLine>> purchaseOrderLinesBySupplierPartner = new HashMap<Partner, List<PurchaseOrderLine>>();
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            Partner supplierPartner = purchaseOrderLine.getSupplierPartner();
            if (supplierPartner == null) {
                throw new AxelorException((Model)((Object)purchaseOrderLine), 4, I18n.get((String)"Please, select a supplier for the line %s"), new Object[]{purchaseOrderLine.getProductName()});
            }
            if (!purchaseOrderLinesBySupplierPartner.containsKey((Object)supplierPartner)) {
                purchaseOrderLinesBySupplierPartner.put(supplierPartner, new ArrayList());
            }
            ((List)purchaseOrderLinesBySupplierPartner.get((Object)supplierPartner)).add(purchaseOrderLine);
        }
        return purchaseOrderLinesBySupplierPartner;
    }

    @Transactional(rollbackOn={Exception.class})
    public void createPurchaseOrder(Partner supplierPartner, List<PurchaseOrderLine> purchaseOrderLineList, PurchaseOrder parentPurchaseOrder) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une commande fournisseur depuis le devis fournisseur : {} et le fournisseur : {}", (Object)parentPurchaseOrder.getPurchaseOrderSeq(), (Object)supplierPartner.getFullName());
        PurchaseOrder purchaseOrder = this.purchaseOrderServiceSupplychainImpl.createPurchaseOrder(AuthUtils.getUser(), parentPurchaseOrder.getCompany(), null, supplierPartner.getCurrency(), null, parentPurchaseOrder.getPurchaseOrderSeq(), parentPurchaseOrder.getExternalReference(), ((StockLocationService)Beans.get(StockLocationService.class)).getDefaultReceiptStockLocation(parentPurchaseOrder.getCompany()), ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(), ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(supplierPartner, 2), supplierPartner, parentPurchaseOrder.getTradingName());
        purchaseOrder.setParentPurchaseOrder(parentPurchaseOrder);
        for (PurchaseOrderLine purchaseOrderLine : purchaseOrderLineList) {
            purchaseOrder.addPurchaseOrderLineListItem(this.createPurchaseOrderLine(purchaseOrder, purchaseOrderLine));
        }
        this.purchaseOrderServiceSupplychainImpl.computePurchaseOrder(purchaseOrder);
        purchaseOrder.setStatusSelect(2);
        purchaseOrder.setReceiptState(1);
        this.poRepo.save((Model)((Object)purchaseOrder));
    }

    public PurchaseOrderLine createPurchaseOrderLine(PurchaseOrder purchaseOrder, PurchaseOrderLine purchaseOrderLine) throws AxelorException {
        LOG.debug("Cr\u00e9ation d'une ligne de commande fournisseur pour le produit : {}", new Object[]{purchaseOrderLine.getProductName()});
        return this.purchaseOrderLineService.createPurchaseOrderLine(purchaseOrder, purchaseOrderLine.getProduct(), purchaseOrderLine.getProductName(), purchaseOrderLine.getDescription(), purchaseOrderLine.getQty(), purchaseOrderLine.getUnit());
    }
}

