/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.web;

import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.repo.PurchaseOrderRepository;
import com.axelor.apps.suppliermanagement.service.PurchaseOrderSupplierService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class PurchaseOrderController {
    public void generateSuppliersPurchaseOrder(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        try {
            ((PurchaseOrderSupplierService)Beans.get(PurchaseOrderSupplierService.class)).generateSuppliersPurchaseOrder((PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId())));
            response.setFlash(I18n.get((String)"Supplier's consulting's request created"));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateSuppliersRequests(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)((Object)request.getContext().asType(PurchaseOrder.class));
        try {
            ((PurchaseOrderSupplierService)Beans.get(PurchaseOrderSupplierService.class)).generateAllSuppliersRequests((PurchaseOrder)((Object)((PurchaseOrderRepository)((Object)Beans.get(PurchaseOrderRepository.class))).find(purchaseOrder.getId())));
            response.setFlash(I18n.get((String)"Suppliers orders' generation over"));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

