/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.suppliermanagement.web;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.purchase.db.PurchaseOrder;
import com.axelor.apps.purchase.db.PurchaseOrderLine;
import com.axelor.apps.purchase.db.repo.PurchaseOrderLineRepository;
import com.axelor.apps.purchase.service.app.AppPurchaseService;
import com.axelor.apps.suppliermanagement.db.PurchaseOrderSupplierLine;
import com.axelor.apps.suppliermanagement.db.repo.PurchaseOrderSupplierLineRepository;
import com.axelor.apps.suppliermanagement.service.PurchaseOrderSupplierLineService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.util.stream.Collectors;

@Singleton
public class PurchaseOrderSupplierLineController {
    public void accept(ActionRequest request, ActionResponse response) {
        PurchaseOrderSupplierLine purchaseOrderSupplierLine = (PurchaseOrderSupplierLine)((Object)((PurchaseOrderSupplierLineRepository)((Object)Beans.get(PurchaseOrderSupplierLineRepository.class))).find(((PurchaseOrderSupplierLine)((Object)request.getContext().asType(PurchaseOrderSupplierLine.class))).getId()));
        if (purchaseOrderSupplierLine.getPurchaseOrderLine() == null && request.getContext().getParent() != null) {
            purchaseOrderSupplierLine.setPurchaseOrderLine((PurchaseOrderLine)((Object)((PurchaseOrderLineRepository)((Object)Beans.get(PurchaseOrderLineRepository.class))).find(((PurchaseOrderLine)((Object)request.getContext().getParent().asType(PurchaseOrderLine.class))).getId())));
        }
        try {
            ((PurchaseOrderSupplierLineService)Beans.get(PurchaseOrderSupplierLineService.class)).accept(purchaseOrderSupplierLine);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void supplierPartnerDomain(ActionRequest request, ActionResponse response) {
        PurchaseOrder purchaseOrder;
        PurchaseOrderSupplierLine purchaseOrderSupplierLine = (PurchaseOrderSupplierLine)((Object)request.getContext().asType(PurchaseOrderSupplierLine.class));
        PurchaseOrderLine purchaseOrderLine = purchaseOrderSupplierLine.getPurchaseOrderLine();
        if (purchaseOrderLine == null) {
            purchaseOrderLine = (PurchaseOrderLine)((Object)request.getContext().getParent().asType(PurchaseOrderLine.class));
        }
        if ((purchaseOrder = purchaseOrderLine.getPurchaseOrder()) == null) {
            purchaseOrder = (PurchaseOrder)((Object)request.getContext().getParent().getParent().asType(PurchaseOrder.class));
        }
        Company company = purchaseOrder.getCompany();
        String domain = "";
        if (((AppPurchaseService)Beans.get(AppPurchaseService.class)).getAppPurchase().getManageSupplierCatalog().booleanValue() && purchaseOrderLine.getProduct() != null && !purchaseOrderLine.getProduct().getSupplierCatalogList().isEmpty()) {
            domain = domain + "self.id != " + company.getPartner().getId() + " AND self.id IN " + purchaseOrderLine.getProduct().getSupplierCatalogList().stream().map(s -> s.getSupplierPartner().getId()).collect(Collectors.toList()).toString().replace('[', '(').replace(']', ')');
            String blockedPartnerQuery = ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(company, 6);
            if (!Strings.isNullOrEmpty((String)blockedPartnerQuery)) {
                domain = domain + String.format(" AND self.id NOT in (%s)", blockedPartnerQuery);
            }
        } else {
            domain = domain + "self.id = 0";
        }
        domain = domain + " AND " + company.getId() + " in (SELECT id FROM self.companySet)";
        response.setAttr("supplierPartner", "domain", (Object)domain);
    }
}

