/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.batch;

import com.axelor.apps.base.service.batch.BatchStrategy;
import com.axelor.apps.contract.batch.BatchContractFactory;
import com.axelor.apps.contract.batch.BatchContractFactoryCurrentActivation;
import com.axelor.apps.contract.batch.BatchContractFactoryInvoicing;
import com.axelor.apps.contract.batch.BatchContractFactoryNextActivation;
import com.axelor.apps.contract.batch.BatchContractFactoryTerminate;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.repo.ContractRepository;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.List;

public class BatchContract
extends BatchStrategy {
    protected ContractRepository repository;

    @Inject
    public BatchContract(ContractRepository repository) {
        this.repository = repository;
    }

    public static BatchContractFactory getFactory(int action) {
        switch (action) {
            case 1: {
                return (BatchContractFactory)Beans.get(BatchContractFactoryInvoicing.class);
            }
            case 2: {
                return (BatchContractFactory)Beans.get(BatchContractFactoryTerminate.class);
            }
            case 4: {
                return (BatchContractFactory)Beans.get(BatchContractFactoryNextActivation.class);
            }
            case 3: {
                return (BatchContractFactory)Beans.get(BatchContractFactoryCurrentActivation.class);
            }
        }
        return null;
    }

    protected void process() {
        try {
            List contracts;
            BatchContractFactory factory = BatchContract.getFactory(this.batch.getContractBatch().getActionSelect());
            Preconditions.checkNotNull((Object)factory, (Object)String.format(I18n.get((String)"Action %s has no Batch implementation."), this.batch.getContractBatch().getActionSelect()));
            Query<Contract> query = factory.prepare(this.batch);
            while (!(contracts = query.fetch(10)).isEmpty()) {
                this.findBatch();
                for (Contract contract : contracts) {
                    try {
                        factory.process(contract);
                        this.incrementDone(contract);
                    }
                    catch (Exception e) {
                        TraceBackService.trace((Throwable)e);
                        this.incrementAnomaly(contract);
                    }
                }
                JPA.clear();
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            LOG.error(e.getMessage());
        }
    }

    protected void incrementDone(Contract contract) {
        contract.addBatchSetItem(this.batch);
        super.incrementDone();
    }

    protected void incrementAnomaly(Contract contract) {
        this.findBatch();
        contract = (Contract)((Object)this.repository.find(contract.getId()));
        contract.addBatchSetItem(this.batch);
        super.incrementAnomaly();
    }

    protected void stop() {
        super.stop();
        this.addComment(String.format("%d contract(s) treated and %d anomaly(ies) reported !", this.batch.getDone(), this.batch.getAnomaly()));
    }
}

