/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.batch;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.contract.batch.BatchContractFactory;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.repo.ContractRepository;
import com.axelor.apps.contract.service.ContractService;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.time.format.DateTimeFormatter;

public class BatchContractFactoryInvoicing
extends BatchContractFactory {
    @Inject
    public BatchContractFactoryInvoicing(ContractRepository repository, ContractService service, AppBaseService baseService) {
        super(repository, service, baseService);
    }

    @Override
    public Query<Contract> prepare(Batch batch) {
        return this.repository.all().filter("self.isInvoicingManagement = TRUE AND self.currentContractVersion.automaticInvoicing = TRUE AND self.invoicingDate <= :date AND :batch NOT MEMBER of self.batchSet").bind("date", (Object)this.baseService.getTodayDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).bind("batch", (Object)batch);
    }

    @Override
    public void process(Contract contract) throws AxelorException {
        this.service.invoicingContract(contract);
    }
}

