/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db;

import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="CONTRACT_CONTRACT_LINE", indexes={@Index(columnList="fullName"), @Index(columnList="product"), @Index(columnList="tax_line"), @Index(columnList="fiscal_position"), @Index(columnList="unit"), @Index(columnList="contract_version"), @Index(columnList="analytic_distribution_template")})
public class ContractLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTRACT_CONTRACT_LINE_SEQ")
    @SequenceGenerator(name="CONTRACT_CONTRACT_LINE_SEQ", sequenceName="CONTRACT_CONTRACT_LINE_SEQ", allocationSize=1)
    private Long id;
    private Integer sequence = 0;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Product")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Qty")
    private BigDecimal qty = new BigDecimal("1");
    @Widget(title="Displayed Product name")
    @NotNull
    private String productName;
    @Widget(title="Unit price")
    private BigDecimal price = BigDecimal.ZERO;
    @Widget(title="Tax")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TaxLine taxLine;
    @Widget(title="Total W.T.")
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.")
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @Widget(title="Fiscal position")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private FiscalPosition fiscalPosition;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Invoice from consumption")
    private Boolean isConsumptionLine = Boolean.FALSE;
    @Widget(title="Is invoiced")
    private Boolean isInvoiced = Boolean.FALSE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ContractVersion contractVersion;
    @Widget(title="Analytic move lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="contractLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticMoveLine> analyticMoveLineList;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        fullName = this.productName != null && this.productName.length() > 255 ? fullName + this.productName.substring(1, 255) : fullName + this.productName;
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getPrice() {
        return this.price == null ? BigDecimal.ZERO : this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public TaxLine getTaxLine() {
        return this.taxLine;
    }

    public void setTaxLine(TaxLine taxLine) {
        this.taxLine = taxLine;
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public FiscalPosition getFiscalPosition() {
        return this.fiscalPosition;
    }

    public void setFiscalPosition(FiscalPosition fiscalPosition) {
        this.fiscalPosition = fiscalPosition;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public Boolean getIsConsumptionLine() {
        return this.isConsumptionLine == null ? Boolean.FALSE : this.isConsumptionLine;
    }

    public void setIsConsumptionLine(Boolean isConsumptionLine) {
        this.isConsumptionLine = isConsumptionLine;
    }

    public Boolean getIsInvoiced() {
        return this.isInvoiced == null ? Boolean.FALSE : this.isInvoiced;
    }

    public void setIsInvoiced(Boolean isInvoiced) {
        this.isInvoiced = isInvoiced;
    }

    public ContractVersion getContractVersion() {
        return this.contractVersion;
    }

    public void setContractVersion(ContractVersion contractVersion) {
        this.contractVersion = contractVersion;
    }

    public List<AnalyticMoveLine> getAnalyticMoveLineList() {
        return this.analyticMoveLineList;
    }

    public void setAnalyticMoveLineList(List<AnalyticMoveLine> analyticMoveLineList) {
        this.analyticMoveLineList = analyticMoveLineList;
    }

    public void addAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            this.setAnalyticMoveLineList(new ArrayList<AnalyticMoveLine>());
        }
        this.getAnalyticMoveLineList().add(item);
        item.setContractLine(this);
    }

    public void removeAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            return;
        }
        this.getAnalyticMoveLineList().remove((Object)item);
    }

    public void clearAnalyticMoveLineList() {
        if (this.getAnalyticMoveLineList() != null) {
            this.getAnalyticMoveLineList().clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContractLine)) {
            return false;
        }
        ContractLine other = (ContractLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sequence", (Object)this.getSequence()).add("qty", (Object)this.getQty()).add("productName", (Object)this.getProductName()).add("price", (Object)this.getPrice()).add("exTaxTotal", (Object)this.getExTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("isConsumptionLine", (Object)this.getIsConsumptionLine()).add("isInvoiced", (Object)this.getIsInvoiced()).omitNullValues().toString();
    }
}

