/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db;

import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Duration;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="CONTRACT_CONTRACT_TEMPLATE", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="payment_mode"), @Index(columnList="payment_condition"), @Index(columnList="invoicing_duration"), @Index(columnList="renewal_duration"), @Index(columnList="engagement_duration"), @Index(columnList="prior_notice_duration"), @Index(columnList="currency")})
public class ContractTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTRACT_CONTRACT_TEMPLATE_SEQ")
    @SequenceGenerator(name="CONTRACT_CONTRACT_TEMPLATE_SEQ", sequenceName="CONTRACT_CONTRACT_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Number of finished periods")
    private Integer periodNumber = 0;
    @Widget(title="Type", selection="contract.target.type.select")
    @NotNull
    private Integer targetTypeSelect = 1;
    @Widget(title="Invoicing moment", selection="contract.version.invoicing.moment.select")
    private Integer invoicingMomentSelect = 1;
    @Widget(title="Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Notes", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String note;
    @Widget(title="Name")
    @NameColumn
    @NotNull
    private String name;
    @Widget(title="Manage invoices")
    private Boolean isInvoicingManagement = Boolean.FALSE;
    @Widget(title="Consumption management")
    private Boolean isConsumptionManagement = Boolean.FALSE;
    @Widget(title="Additional benefit management")
    private Boolean isAdditionaBenefitManagement = Boolean.FALSE;
    @Widget(title="Automatic invoicing")
    private Boolean automaticInvoicing = Boolean.FALSE;
    @Widget(title="Periodic Invoicing")
    private Boolean isPeriodicInvoicing = Boolean.FALSE;
    @Widget(title="Prorated Invoice")
    private Boolean isProratedInvoice = Boolean.FALSE;
    @Widget(title="Prorated Starting periods")
    private Boolean isProratedFirstInvoice = Boolean.FALSE;
    @Widget(title="Prorated finished periods")
    private Boolean isProratedLastInvoice = Boolean.FALSE;
    @Widget(title="Protrate temporally")
    private Boolean isTimeProratedInvoice = Boolean.FALSE;
    @Widget(title="Prorate from versions")
    private Boolean isVersionProratedInvoice = Boolean.FALSE;
    @Widget(title="Tacit renewal")
    private Boolean isTacitRenewal = Boolean.FALSE;
    @Widget(title="With engagement")
    private Boolean isWithEngagement = Boolean.FALSE;
    @Widget(title="Engagement start from version")
    private Boolean engagementStartFromVersion = Boolean.FALSE;
    @Widget(title="With prior notice")
    private Boolean isWithPriorNotice = Boolean.FALSE;
    @Widget(title="Only invoice consumption before Invoice period end Date")
    private Boolean isConsumptionBeforeEndDate = Boolean.FALSE;
    @Widget(title="Auto enable version on renew")
    private Boolean isAutoEnableVersionOnRenew = Boolean.FALSE;
    @Widget(title="First period end date")
    private LocalDate firstPeriodEndDate;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Invoicing Frequency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration invoicingDuration;
    @Widget(title="Renewal duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration renewalDuration;
    @Widget(title="Engagement duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration engagementDuration;
    @Widget(title="Prior notice duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration priorNoticeDuration;
    @Widget(title="Next Invoice Additional Benefit")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ContractLine> additionalBenefitContractLineList;
    @Widget(title="Invoicing content")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ContractLine> contractLineList;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ContractTemplate() {
    }

    public ContractTemplate(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPeriodNumber() {
        return this.periodNumber == null ? 0 : this.periodNumber;
    }

    public void setPeriodNumber(Integer periodNumber) {
        this.periodNumber = periodNumber;
    }

    public Integer getTargetTypeSelect() {
        return this.targetTypeSelect == null ? 0 : this.targetTypeSelect;
    }

    public void setTargetTypeSelect(Integer targetTypeSelect) {
        this.targetTypeSelect = targetTypeSelect;
    }

    public Integer getInvoicingMomentSelect() {
        return this.invoicingMomentSelect == null ? 0 : this.invoicingMomentSelect;
    }

    public void setInvoicingMomentSelect(Integer invoicingMomentSelect) {
        this.invoicingMomentSelect = invoicingMomentSelect;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getIsInvoicingManagement() {
        return this.isInvoicingManagement == null ? Boolean.FALSE : this.isInvoicingManagement;
    }

    public void setIsInvoicingManagement(Boolean isInvoicingManagement) {
        this.isInvoicingManagement = isInvoicingManagement;
    }

    public Boolean getIsConsumptionManagement() {
        return this.isConsumptionManagement == null ? Boolean.FALSE : this.isConsumptionManagement;
    }

    public void setIsConsumptionManagement(Boolean isConsumptionManagement) {
        this.isConsumptionManagement = isConsumptionManagement;
    }

    public Boolean getIsAdditionaBenefitManagement() {
        return this.isAdditionaBenefitManagement == null ? Boolean.FALSE : this.isAdditionaBenefitManagement;
    }

    public void setIsAdditionaBenefitManagement(Boolean isAdditionaBenefitManagement) {
        this.isAdditionaBenefitManagement = isAdditionaBenefitManagement;
    }

    public Boolean getAutomaticInvoicing() {
        return this.automaticInvoicing == null ? Boolean.FALSE : this.automaticInvoicing;
    }

    public void setAutomaticInvoicing(Boolean automaticInvoicing) {
        this.automaticInvoicing = automaticInvoicing;
    }

    public Boolean getIsPeriodicInvoicing() {
        return this.isPeriodicInvoicing == null ? Boolean.FALSE : this.isPeriodicInvoicing;
    }

    public void setIsPeriodicInvoicing(Boolean isPeriodicInvoicing) {
        this.isPeriodicInvoicing = isPeriodicInvoicing;
    }

    public Boolean getIsProratedInvoice() {
        return this.isProratedInvoice == null ? Boolean.FALSE : this.isProratedInvoice;
    }

    public void setIsProratedInvoice(Boolean isProratedInvoice) {
        this.isProratedInvoice = isProratedInvoice;
    }

    public Boolean getIsProratedFirstInvoice() {
        return this.isProratedFirstInvoice == null ? Boolean.FALSE : this.isProratedFirstInvoice;
    }

    public void setIsProratedFirstInvoice(Boolean isProratedFirstInvoice) {
        this.isProratedFirstInvoice = isProratedFirstInvoice;
    }

    public Boolean getIsProratedLastInvoice() {
        return this.isProratedLastInvoice == null ? Boolean.FALSE : this.isProratedLastInvoice;
    }

    public void setIsProratedLastInvoice(Boolean isProratedLastInvoice) {
        this.isProratedLastInvoice = isProratedLastInvoice;
    }

    public Boolean getIsTimeProratedInvoice() {
        return this.isTimeProratedInvoice == null ? Boolean.FALSE : this.isTimeProratedInvoice;
    }

    public void setIsTimeProratedInvoice(Boolean isTimeProratedInvoice) {
        this.isTimeProratedInvoice = isTimeProratedInvoice;
    }

    public Boolean getIsVersionProratedInvoice() {
        return this.isVersionProratedInvoice == null ? Boolean.FALSE : this.isVersionProratedInvoice;
    }

    public void setIsVersionProratedInvoice(Boolean isVersionProratedInvoice) {
        this.isVersionProratedInvoice = isVersionProratedInvoice;
    }

    public Boolean getIsTacitRenewal() {
        return this.isTacitRenewal == null ? Boolean.FALSE : this.isTacitRenewal;
    }

    public void setIsTacitRenewal(Boolean isTacitRenewal) {
        this.isTacitRenewal = isTacitRenewal;
    }

    public Boolean getIsWithEngagement() {
        return this.isWithEngagement == null ? Boolean.FALSE : this.isWithEngagement;
    }

    public void setIsWithEngagement(Boolean isWithEngagement) {
        this.isWithEngagement = isWithEngagement;
    }

    public Boolean getEngagementStartFromVersion() {
        return this.engagementStartFromVersion == null ? Boolean.FALSE : this.engagementStartFromVersion;
    }

    public void setEngagementStartFromVersion(Boolean engagementStartFromVersion) {
        this.engagementStartFromVersion = engagementStartFromVersion;
    }

    public Boolean getIsWithPriorNotice() {
        return this.isWithPriorNotice == null ? Boolean.FALSE : this.isWithPriorNotice;
    }

    public void setIsWithPriorNotice(Boolean isWithPriorNotice) {
        this.isWithPriorNotice = isWithPriorNotice;
    }

    public Boolean getIsConsumptionBeforeEndDate() {
        return this.isConsumptionBeforeEndDate == null ? Boolean.FALSE : this.isConsumptionBeforeEndDate;
    }

    public void setIsConsumptionBeforeEndDate(Boolean isConsumptionBeforeEndDate) {
        this.isConsumptionBeforeEndDate = isConsumptionBeforeEndDate;
    }

    public Boolean getIsAutoEnableVersionOnRenew() {
        return this.isAutoEnableVersionOnRenew == null ? Boolean.FALSE : this.isAutoEnableVersionOnRenew;
    }

    public void setIsAutoEnableVersionOnRenew(Boolean isAutoEnableVersionOnRenew) {
        this.isAutoEnableVersionOnRenew = isAutoEnableVersionOnRenew;
    }

    public LocalDate getFirstPeriodEndDate() {
        return this.firstPeriodEndDate;
    }

    public void setFirstPeriodEndDate(LocalDate firstPeriodEndDate) {
        this.firstPeriodEndDate = firstPeriodEndDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public Duration getInvoicingDuration() {
        return this.invoicingDuration;
    }

    public void setInvoicingDuration(Duration invoicingDuration) {
        this.invoicingDuration = invoicingDuration;
    }

    public Duration getRenewalDuration() {
        return this.renewalDuration;
    }

    public void setRenewalDuration(Duration renewalDuration) {
        this.renewalDuration = renewalDuration;
    }

    public Duration getEngagementDuration() {
        return this.engagementDuration;
    }

    public void setEngagementDuration(Duration engagementDuration) {
        this.engagementDuration = engagementDuration;
    }

    public Duration getPriorNoticeDuration() {
        return this.priorNoticeDuration;
    }

    public void setPriorNoticeDuration(Duration priorNoticeDuration) {
        this.priorNoticeDuration = priorNoticeDuration;
    }

    public List<ContractLine> getAdditionalBenefitContractLineList() {
        return this.additionalBenefitContractLineList;
    }

    public void setAdditionalBenefitContractLineList(List<ContractLine> additionalBenefitContractLineList) {
        this.additionalBenefitContractLineList = additionalBenefitContractLineList;
    }

    public void addAdditionalBenefitContractLineListItem(ContractLine item) {
        if (this.getAdditionalBenefitContractLineList() == null) {
            this.setAdditionalBenefitContractLineList(new ArrayList<ContractLine>());
        }
        this.getAdditionalBenefitContractLineList().add(item);
    }

    public void removeAdditionalBenefitContractLineListItem(ContractLine item) {
        if (this.getAdditionalBenefitContractLineList() == null) {
            return;
        }
        this.getAdditionalBenefitContractLineList().remove((Object)item);
    }

    public void clearAdditionalBenefitContractLineList() {
        if (this.getAdditionalBenefitContractLineList() != null) {
            this.getAdditionalBenefitContractLineList().clear();
        }
    }

    public List<ContractLine> getContractLineList() {
        return this.contractLineList;
    }

    public void setContractLineList(List<ContractLine> contractLineList) {
        this.contractLineList = contractLineList;
    }

    public void addContractLineListItem(ContractLine item) {
        if (this.getContractLineList() == null) {
            this.setContractLineList(new ArrayList<ContractLine>());
        }
        this.getContractLineList().add(item);
    }

    public void removeContractLineListItem(ContractLine item) {
        if (this.getContractLineList() == null) {
            return;
        }
        this.getContractLineList().remove((Object)item);
    }

    public void clearContractLineList() {
        if (this.getContractLineList() != null) {
            this.getContractLineList().clear();
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContractTemplate)) {
            return false;
        }
        ContractTemplate other = (ContractTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("periodNumber", (Object)this.getPeriodNumber()).add("targetTypeSelect", (Object)this.getTargetTypeSelect()).add("invoicingMomentSelect", (Object)this.getInvoicingMomentSelect()).add("name", (Object)this.getName()).add("isInvoicingManagement", (Object)this.getIsInvoicingManagement()).add("isConsumptionManagement", (Object)this.getIsConsumptionManagement()).add("isAdditionaBenefitManagement", (Object)this.getIsAdditionaBenefitManagement()).add("automaticInvoicing", (Object)this.getAutomaticInvoicing()).add("isPeriodicInvoicing", (Object)this.getIsPeriodicInvoicing()).add("isProratedInvoice", (Object)this.getIsProratedInvoice()).add("isProratedFirstInvoice", (Object)this.getIsProratedFirstInvoice()).omitNullValues().toString();
    }
}

