/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db;

import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.base.db.Duration;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="CONTRACT_CONTRACT_VERSION", indexes={@Index(columnList="activated_by_user"), @Index(columnList="payment_mode"), @Index(columnList="payment_condition"), @Index(columnList="invoicing_duration"), @Index(columnList="contract_history"), @Index(columnList="renewal_duration"), @Index(columnList="engagement_duration"), @Index(columnList="prior_notice_duration"), @Index(columnList="meta_file"), @Index(columnList="fullName")})
public class ContractVersion
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="CONTRACT_CONTRACT_VERSION_SEQ")
    @SequenceGenerator(name="CONTRACT_CONTRACT_VERSION_SEQ", sequenceName="CONTRACT_CONTRACT_VERSION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Status", selection="contract.version.status.select", copyable=false)
    @NotNull
    private Integer statusSelect = 1;
    @Widget(title="Invoicing moment", selection="contract.version.invoicing.moment.select")
    private Integer invoicingMomentSelect = 1;
    @Widget(title="Number of days")
    private Integer numberOfDays = 0;
    @Widget(title="Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Do not renew")
    private Boolean doNotRenew = Boolean.FALSE;
    @Widget(title="Automatic invoicing")
    private Boolean automaticInvoicing = Boolean.FALSE;
    @Widget(title="Periodic Invoicing")
    private Boolean isPeriodicInvoicing = Boolean.FALSE;
    @Widget(title="Prorated Invoice")
    private Boolean isProratedInvoice = Boolean.FALSE;
    @Widget(title="Prorated Starting periods")
    private Boolean isProratedFirstInvoice = Boolean.FALSE;
    @Widget(title="Prorated finished periods")
    private Boolean isProratedLastInvoice = Boolean.FALSE;
    @Widget(title="Prorated temporally")
    private Boolean isTimeProratedInvoice = Boolean.FALSE;
    @Widget(title="Prorate from versions")
    private Boolean isVersionProratedInvoice = Boolean.FALSE;
    @Widget(title="Tacit renewal")
    private Boolean isTacitRenewal = Boolean.FALSE;
    @Widget(title="Auto enable version on renew")
    private Boolean isAutoEnableVersionOnRenew = Boolean.FALSE;
    @Widget(title="With engagement")
    private Boolean isWithEngagement = Boolean.FALSE;
    @Widget(title="Engagement start from version")
    private Boolean engagementStartFromVersion = Boolean.FALSE;
    @Widget(title="With prior notice")
    private Boolean isWithPriorNotice = Boolean.FALSE;
    @Widget(title="Only invoice consumption before Invoice period end Date")
    private Boolean isConsumptionBeforeEndDate = Boolean.FALSE;
    @Widget(title="Consumption management")
    private Boolean isConsumptionManagement = Boolean.FALSE;
    @Widget(title="Supposed activation date", copyable=false)
    private LocalDate supposedActivationDate;
    @Widget(title="Activation date", copyable=false)
    private LocalDate activationDate;
    @Widget(title="Supposed end date", copyable=false)
    private LocalDate supposedEndDate;
    @Widget(title="End date", copyable=false)
    private LocalDate endDate;
    @Widget(title="Activated By", copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User activatedByUser;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Payment condition")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentCondition paymentCondition;
    @Widget(title="Invoicing Frequency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration invoicingDuration;
    @Widget(title="Contract", copyable=false)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Contract contractHistory;
    @Widget(title="Renewal duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration renewalDuration;
    @Widget(title="Engagement duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration engagementDuration;
    @Widget(title="Prior notice duration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration priorNoticeDuration;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Widget(title="Contract", copyable=false)
    @OneToOne(fetch=FetchType.LAZY, mappedBy="currentContractVersion", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Contract contract;
    @Widget(title="Contract", copyable=false)
    @OneToOne(fetch=FetchType.LAZY, mappedBy="nextVersion", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Contract nextContract;
    @Widget(title="Invoicing content")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="contractVersion", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ContractLine> contractLineList;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getInvoicingMomentSelect() {
        return this.invoicingMomentSelect == null ? 0 : this.invoicingMomentSelect;
    }

    public void setInvoicingMomentSelect(Integer invoicingMomentSelect) {
        this.invoicingMomentSelect = invoicingMomentSelect;
    }

    public Integer getNumberOfDays() {
        return this.numberOfDays == null ? 0 : this.numberOfDays;
    }

    public void setNumberOfDays(Integer numberOfDays) {
        this.numberOfDays = numberOfDays;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getDoNotRenew() {
        return this.doNotRenew == null ? Boolean.FALSE : this.doNotRenew;
    }

    public void setDoNotRenew(Boolean doNotRenew) {
        this.doNotRenew = doNotRenew;
    }

    public Boolean getAutomaticInvoicing() {
        return this.automaticInvoicing == null ? Boolean.FALSE : this.automaticInvoicing;
    }

    public void setAutomaticInvoicing(Boolean automaticInvoicing) {
        this.automaticInvoicing = automaticInvoicing;
    }

    public Boolean getIsPeriodicInvoicing() {
        return this.isPeriodicInvoicing == null ? Boolean.FALSE : this.isPeriodicInvoicing;
    }

    public void setIsPeriodicInvoicing(Boolean isPeriodicInvoicing) {
        this.isPeriodicInvoicing = isPeriodicInvoicing;
    }

    public Boolean getIsProratedInvoice() {
        return this.isProratedInvoice == null ? Boolean.FALSE : this.isProratedInvoice;
    }

    public void setIsProratedInvoice(Boolean isProratedInvoice) {
        this.isProratedInvoice = isProratedInvoice;
    }

    public Boolean getIsProratedFirstInvoice() {
        return this.isProratedFirstInvoice == null ? Boolean.FALSE : this.isProratedFirstInvoice;
    }

    public void setIsProratedFirstInvoice(Boolean isProratedFirstInvoice) {
        this.isProratedFirstInvoice = isProratedFirstInvoice;
    }

    public Boolean getIsProratedLastInvoice() {
        return this.isProratedLastInvoice == null ? Boolean.FALSE : this.isProratedLastInvoice;
    }

    public void setIsProratedLastInvoice(Boolean isProratedLastInvoice) {
        this.isProratedLastInvoice = isProratedLastInvoice;
    }

    public Boolean getIsTimeProratedInvoice() {
        return this.isTimeProratedInvoice == null ? Boolean.FALSE : this.isTimeProratedInvoice;
    }

    public void setIsTimeProratedInvoice(Boolean isTimeProratedInvoice) {
        this.isTimeProratedInvoice = isTimeProratedInvoice;
    }

    public Boolean getIsVersionProratedInvoice() {
        return this.isVersionProratedInvoice == null ? Boolean.FALSE : this.isVersionProratedInvoice;
    }

    public void setIsVersionProratedInvoice(Boolean isVersionProratedInvoice) {
        this.isVersionProratedInvoice = isVersionProratedInvoice;
    }

    public Boolean getIsTacitRenewal() {
        return this.isTacitRenewal == null ? Boolean.FALSE : this.isTacitRenewal;
    }

    public void setIsTacitRenewal(Boolean isTacitRenewal) {
        this.isTacitRenewal = isTacitRenewal;
    }

    public Boolean getIsAutoEnableVersionOnRenew() {
        return this.isAutoEnableVersionOnRenew == null ? Boolean.FALSE : this.isAutoEnableVersionOnRenew;
    }

    public void setIsAutoEnableVersionOnRenew(Boolean isAutoEnableVersionOnRenew) {
        this.isAutoEnableVersionOnRenew = isAutoEnableVersionOnRenew;
    }

    public Boolean getIsWithEngagement() {
        return this.isWithEngagement == null ? Boolean.FALSE : this.isWithEngagement;
    }

    public void setIsWithEngagement(Boolean isWithEngagement) {
        this.isWithEngagement = isWithEngagement;
    }

    public Boolean getEngagementStartFromVersion() {
        return this.engagementStartFromVersion == null ? Boolean.FALSE : this.engagementStartFromVersion;
    }

    public void setEngagementStartFromVersion(Boolean engagementStartFromVersion) {
        this.engagementStartFromVersion = engagementStartFromVersion;
    }

    public Boolean getIsWithPriorNotice() {
        return this.isWithPriorNotice == null ? Boolean.FALSE : this.isWithPriorNotice;
    }

    public void setIsWithPriorNotice(Boolean isWithPriorNotice) {
        this.isWithPriorNotice = isWithPriorNotice;
    }

    public Boolean getIsConsumptionBeforeEndDate() {
        return this.isConsumptionBeforeEndDate == null ? Boolean.FALSE : this.isConsumptionBeforeEndDate;
    }

    public void setIsConsumptionBeforeEndDate(Boolean isConsumptionBeforeEndDate) {
        this.isConsumptionBeforeEndDate = isConsumptionBeforeEndDate;
    }

    public Boolean getIsConsumptionManagement() {
        return this.isConsumptionManagement == null ? Boolean.FALSE : this.isConsumptionManagement;
    }

    public void setIsConsumptionManagement(Boolean isConsumptionManagement) {
        this.isConsumptionManagement = isConsumptionManagement;
    }

    public LocalDate getSupposedActivationDate() {
        return this.supposedActivationDate;
    }

    public void setSupposedActivationDate(LocalDate supposedActivationDate) {
        this.supposedActivationDate = supposedActivationDate;
    }

    public LocalDate getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(LocalDate activationDate) {
        this.activationDate = activationDate;
    }

    public LocalDate getSupposedEndDate() {
        return this.supposedEndDate;
    }

    public void setSupposedEndDate(LocalDate supposedEndDate) {
        this.supposedEndDate = supposedEndDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public User getActivatedByUser() {
        return this.activatedByUser;
    }

    public void setActivatedByUser(User activatedByUser) {
        this.activatedByUser = activatedByUser;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public PaymentCondition getPaymentCondition() {
        return this.paymentCondition;
    }

    public void setPaymentCondition(PaymentCondition paymentCondition) {
        this.paymentCondition = paymentCondition;
    }

    public Duration getInvoicingDuration() {
        return this.invoicingDuration;
    }

    public void setInvoicingDuration(Duration invoicingDuration) {
        this.invoicingDuration = invoicingDuration;
    }

    public Contract getContractHistory() {
        return this.contractHistory;
    }

    public void setContractHistory(Contract contractHistory) {
        this.contractHistory = contractHistory;
    }

    public Duration getRenewalDuration() {
        return this.renewalDuration;
    }

    public void setRenewalDuration(Duration renewalDuration) {
        this.renewalDuration = renewalDuration;
    }

    public Duration getEngagementDuration() {
        return this.engagementDuration;
    }

    public void setEngagementDuration(Duration engagementDuration) {
        this.engagementDuration = engagementDuration;
    }

    public Duration getPriorNoticeDuration() {
        return this.priorNoticeDuration;
    }

    public void setPriorNoticeDuration(Duration priorNoticeDuration) {
        this.priorNoticeDuration = priorNoticeDuration;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public Contract getNextContract() {
        return this.nextContract;
    }

    public void setNextContract(Contract nextContract) {
        this.nextContract = nextContract;
    }

    public List<ContractLine> getContractLineList() {
        return this.contractLineList;
    }

    public void setContractLineList(List<ContractLine> contractLineList) {
        this.contractLineList = contractLineList;
    }

    public void addContractLineListItem(ContractLine item) {
        if (this.getContractLineList() == null) {
            this.setContractLineList(new ArrayList<ContractLine>());
        }
        this.getContractLineList().add(item);
        item.setContractVersion(this);
    }

    public void removeContractLineListItem(ContractLine item) {
        if (this.getContractLineList() == null) {
            return;
        }
        this.getContractLineList().remove((Object)item);
    }

    public void clearContractLineList() {
        if (this.getContractLineList() != null) {
            this.getContractLineList().clear();
        }
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.contract != null && this.contract.getName() != null) {
            fullName = fullName + this.contract.getName();
            if (this.contract.getVersionNumber() != null && this.contract.getVersionNumber() != 0) {
                fullName = fullName + " " + this.contract.getVersionNumber();
            }
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContractVersion)) {
            return false;
        }
        ContractVersion other = (ContractVersion)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("invoicingMomentSelect", (Object)this.getInvoicingMomentSelect()).add("numberOfDays", (Object)this.getNumberOfDays()).add("doNotRenew", (Object)this.getDoNotRenew()).add("automaticInvoicing", (Object)this.getAutomaticInvoicing()).add("isPeriodicInvoicing", (Object)this.getIsPeriodicInvoicing()).add("isProratedInvoice", (Object)this.getIsProratedInvoice()).add("isProratedFirstInvoice", (Object)this.getIsProratedFirstInvoice()).add("isProratedLastInvoice", (Object)this.getIsProratedLastInvoice()).add("isTimeProratedInvoice", (Object)this.getIsTimeProratedInvoice()).add("isVersionProratedInvoice", (Object)this.getIsVersionProratedInvoice()).omitNullValues().toString();
    }
}

