/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.db.repo;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.contract.db.repo.AbstractContractRepository;
import com.axelor.apps.contract.db.repo.ContractVersionRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import javax.persistence.PersistenceException;

public class ContractRepository
extends AbstractContractRepository {
    public Contract save(Contract contract) {
        try {
            if (contract.getContractId() == null) {
                contract.setContractId(this.computeSeq(contract.getCompany(), contract.getTargetTypeSelect()));
            }
            ContractVersion currentContractVersion = contract.getCurrentContractVersion();
            currentContractVersion.setIsConsumptionManagement(contract.getIsConsumptionManagement());
            return (Contract)((Object)super.save((Model)((Object)contract)));
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public String computeSeq(Company company, int type) {
        try {
            String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber(type == 1 ? "customerContract" : "supplierContract", company);
            if (seq == null) {
                throw new AxelorException(String.format(I18n.get((String)"The company %s doesn't have any configured sequence for contracts"), company.getName()), 4, new Object[0]);
            }
            return seq;
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public Contract copy(Contract entity, boolean deep) {
        Contract contract = (Contract)((Object)super.copy((Model)((Object)entity), deep));
        ContractVersion version = ((ContractVersionRepository)((Object)Beans.get(ContractVersionRepository.class))).copy(entity);
        contract.setCurrentContractVersion(version);
        return contract;
    }
}

