/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.service;

import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class ContractLineServiceImpl
implements ContractLineService {
    protected AppBaseService appBaseService;
    protected AccountManagementService accountManagementService;
    protected CurrencyService currencyService;

    @Inject
    public ContractLineServiceImpl(AppBaseService appBaseService, AccountManagementService accountManagementService, CurrencyService currencyService) {
        this.appBaseService = appBaseService;
        this.accountManagementService = accountManagementService;
        this.currencyService = currencyService;
    }

    @Override
    public ContractLine reset(ContractLine contractLine) {
        if (contractLine == null) {
            return new ContractLine();
        }
        contractLine.setTaxLine(null);
        contractLine.setProductName(null);
        contractLine.setUnit(null);
        contractLine.setPrice(null);
        contractLine.setExTaxTotal(null);
        contractLine.setInTaxTotal(null);
        contractLine.setDescription(null);
        return contractLine;
    }

    @Override
    public ContractLine fill(ContractLine contractLine, Product product) {
        Preconditions.checkNotNull((Object)((Object)product), (Object)I18n.get((String)"The product can't be empty."));
        contractLine.setProductName(product.getName());
        if (product.getSalesUnit() != null) {
            contractLine.setUnit(product.getSalesUnit());
        } else {
            contractLine.setUnit(product.getUnit());
        }
        contractLine.setPrice(product.getSalePrice());
        contractLine.setDescription(product.getDescription());
        return contractLine;
    }

    @Override
    public ContractLine compute(ContractLine contractLine, Contract contract, Product product) throws AxelorException {
        BigDecimal price;
        Preconditions.checkNotNull((Object)((Object)contract), (Object)I18n.get((String)"Contract can't be empty for compute contract line price."));
        Preconditions.checkNotNull((Object)((Object)product), (Object)"Product can't be empty for compute contract line price.");
        contractLine.setFiscalPosition(contract.getPartner().getFiscalPosition());
        TaxLine taxLine = this.accountManagementService.getTaxLine(this.appBaseService.getTodayDate(), product, contract.getCompany(), contractLine.getFiscalPosition(), false);
        contractLine.setTaxLine(taxLine);
        if (taxLine != null && product.getInAti().booleanValue()) {
            price = contractLine.getPrice();
            price = price.divide(taxLine.getValue().add(BigDecimal.ONE), 2, 4);
            contractLine.setPrice(price);
        }
        price = contractLine.getPrice();
        BigDecimal convert = this.currencyService.getCurrencyConversionRate(product.getSaleCurrency(), contract.getCurrency(), this.appBaseService.getTodayDate());
        contractLine.setPrice(price.multiply(convert));
        return contractLine;
    }

    @Override
    public ContractLine fillAndCompute(ContractLine contractLine, Contract contract, Product product) throws AxelorException {
        contractLine = this.fill(contractLine, product);
        contractLine = this.compute(contractLine, contract, product);
        return contractLine;
    }

    @Override
    public ContractLine computeTotal(ContractLine contractLine) {
        BigDecimal taxRate = BigDecimal.ZERO;
        if (contractLine.getTaxLine() != null) {
            taxRate = contractLine.getTaxLine().getValue();
        }
        BigDecimal exTaxTotal = contractLine.getQty().multiply(contractLine.getPrice()).setScale(2, RoundingMode.HALF_EVEN);
        contractLine.setExTaxTotal(exTaxTotal);
        BigDecimal inTaxTotal = exTaxTotal.add(exTaxTotal.multiply(taxRate));
        contractLine.setInTaxTotal(inTaxTotal);
        return contractLine;
    }

    @Override
    public ContractLine createAnalyticDistributionWithTemplate(ContractLine contractLine, Contract contract) {
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        List analyticMoveLineList = ((AnalyticMoveLineService)Beans.get(AnalyticMoveLineService.class)).generateLines(contractLine.getAnalyticDistributionTemplate(), contractLine.getExTaxTotal(), 4, appAccountService.getTodayDate());
        contractLine.setAnalyticMoveLineList(analyticMoveLineList);
        return contractLine;
    }
}

