/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.contract.db.ConsumptionLine;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.db.ContractTemplate;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.exception.AxelorException;
import com.google.common.collect.Multimap;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public interface ContractService {
    @Transactional
    public void activeContract(Contract var1, LocalDate var2);

    @Transactional(rollbackOn={Exception.class})
    public void waitingCurrentVersion(Contract var1, LocalDate var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Invoice ongoingCurrentVersion(Contract var1, LocalDate var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void waitingNextVersion(Contract var1, LocalDate var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void activeNextVersion(Contract var1, LocalDate var2) throws AxelorException;

    @Transactional
    public void archiveVersion(Contract var1, LocalDate var2);

    @Transactional(rollbackOn={Exception.class})
    public void checkCanTerminateContract(Contract var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void terminateContract(Contract var1, Boolean var2, LocalDate var3) throws AxelorException;

    public void close(Contract var1, LocalDate var2);

    @Transactional(rollbackOn={Exception.class})
    public Invoice invoicingContract(Contract var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void renewContract(Contract var1, LocalDate var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public Contract copyFromTemplate(Contract var1, ContractTemplate var2) throws AxelorException;

    public Contract increaseInvoiceDates(Contract var1);

    @Transactional(rollbackOn={Exception.class})
    public void isValid(Contract var1) throws AxelorException;

    public Multimap<ContractLine, ConsumptionLine> mergeConsumptionLines(Contract var1);

    default public List<ContractVersion> getVersions(Contract contract) {
        List<ContractVersion> versions = contract.getVersionHistory();
        if (versions == null) {
            versions = new ArrayList<ContractVersion>();
        }
        if (contract.getCurrentContractVersion() != null) {
            versions.add(contract.getCurrentContractVersion());
        }
        return versions;
    }

    default public boolean isFullProrated(Contract contract) {
        return contract.getCurrentContractVersion() != null && contract.getCurrentContractVersion().getIsTimeProratedInvoice() != false && contract.getCurrentContractVersion().getIsVersionProratedInvoice() != false;
    }
}

