/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.service;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.db.repo.InvoiceLineRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.FiscalPositionAccountService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceServiceImpl;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.base.service.DurationService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.contract.db.ConsumptionLine;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.db.ContractTemplate;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.contract.db.repo.ConsumptionLineRepository;
import com.axelor.apps.contract.db.repo.ContractLineRepository;
import com.axelor.apps.contract.db.repo.ContractRepository;
import com.axelor.apps.contract.db.repo.ContractVersionRepository;
import com.axelor.apps.contract.generator.InvoiceGeneratorContract;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.apps.contract.service.ContractService;
import com.axelor.apps.contract.service.ContractVersionService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractServiceImpl
extends ContractRepository
implements ContractService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int QTY_SCALE = 2;
    protected AppBaseService appBaseService;
    protected ContractVersionService versionService;
    protected ContractLineService contractLineService;
    protected DurationService durationService;
    protected ContractLineRepository contractLineRepo;
    protected ConsumptionLineRepository consumptionLineRepo;
    protected ContractRepository contractRepository;
    InvoiceLineService invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);

    @Inject
    public ContractServiceImpl(AppBaseService appBaseService, ContractVersionService versionService, ContractLineService contractLineService, DurationService durationService, ContractLineRepository contractLineRepo, ConsumptionLineRepository consumptionLineRepo, ContractRepository contractRepository) {
        this.appBaseService = appBaseService;
        this.versionService = versionService;
        this.contractLineService = contractLineService;
        this.durationService = durationService;
        this.contractLineRepo = contractLineRepo;
        this.consumptionLineRepo = consumptionLineRepo;
        this.contractRepository = contractRepository;
    }

    @Override
    @Transactional
    public void activeContract(Contract contract, LocalDate date) {
        contract.setStartDate(date);
        contract.setStatusSelect(2);
        this.save(contract);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void waitingCurrentVersion(Contract contract, LocalDate date) throws AxelorException {
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        this.versionService.waiting(currentVersion, date);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice ongoingCurrentVersion(Contract contract, LocalDate date) throws AxelorException {
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        if (currentVersion.getSupposedActivationDate() != null) {
            date = currentVersion.getSupposedActivationDate();
        }
        Invoice invoice = null;
        if (currentVersion.getIsWithEngagement().booleanValue() && contract.getStatusSelect() != 2 || currentVersion.getEngagementStartFromVersion().booleanValue()) {
            contract.setEngagementStartDate(date);
        }
        if (contract.getStatusSelect() != 2) {
            this.activeContract(contract, date);
        }
        this.versionService.ongoing(currentVersion, date);
        contract.setVersionNumber(contract.getVersionNumber() + 1);
        if (currentVersion.getIsPeriodicInvoicing().booleanValue() && contract.getVersionNumber() == 0) {
            contract.setInvoicePeriodStartDate(currentVersion.getActivationDate());
            contract.setInvoicePeriodEndDate(contract.getFirstPeriodEndDate());
        }
        if (contract.getCurrentContractVersion().getAutomaticInvoicing().booleanValue()) {
            if (contract.getCurrentContractVersion().getInvoicingMomentSelect() == 2) {
                invoice = this.invoicingContract(contract);
            } else {
                this.fillInvoicingDateByInvoicingMoment(contract);
            }
        }
        return invoice;
    }

    @Override
    @Transactional
    public Contract increaseInvoiceDates(Contract contract) {
        ContractVersion version = contract.getCurrentContractVersion();
        if (version.getIsPeriodicInvoicing().booleanValue()) {
            contract.setInvoicePeriodStartDate(contract.getInvoicePeriodEndDate().plusDays(1L));
            contract.setInvoicePeriodEndDate(this.durationService.computeDuration(version.getInvoicingDuration(), contract.getInvoicePeriodStartDate()).minusDays(1L));
        }
        this.fillInvoicingDateByInvoicingMoment(contract);
        return contract;
    }

    @Transactional
    private void fillInvoicingDateByInvoicingMoment(Contract contract) {
        ContractVersion version = contract.getCurrentContractVersion();
        if (version.getAutomaticInvoicing().booleanValue()) {
            switch (version.getInvoicingMomentSelect()) {
                case 1: {
                    contract.setInvoicingDate(contract.getInvoicePeriodEndDate());
                    break;
                }
                case 2: {
                    contract.setInvoicingDate(contract.getInvoicePeriodStartDate());
                    break;
                }
                case 3: {
                    if (contract.getInvoicePeriodEndDate() == null) break;
                    contract.setInvoicingDate(contract.getInvoicePeriodEndDate().plusDays(version.getNumberOfDays().intValue()));
                    break;
                }
                case 4: {
                    if (contract.getInvoicePeriodStartDate() == null) break;
                    contract.setInvoicingDate(contract.getInvoicePeriodStartDate().plusDays(version.getNumberOfDays().intValue()));
                    break;
                }
                default: {
                    contract.setInvoicingDate(this.appBaseService.getTodayDate());
                }
            }
        }
    }

    @Override
    public void isValid(Contract contract) throws AxelorException {
        if (contract.getId() == null) {
            return;
        }
        this.checkInvoicedConsumptionLines(contract);
        this.checkInvoicedAdditionalContractLine(contract);
    }

    protected void checkInvoicedConsumptionLines(Contract contract) throws AxelorException {
        Contract origin = (Contract)((Object)this.find(contract.getId()));
        List lineInvoiced = origin.getConsumptionLineList().stream().filter(ConsumptionLine::getIsInvoiced).collect(Collectors.toList());
        for (ConsumptionLine line : contract.getConsumptionLineList()) {
            if (!lineInvoiced.contains((Object)line)) continue;
            lineInvoiced.remove((Object)line);
        }
        if (!lineInvoiced.isEmpty()) {
            throw new AxelorException(1, I18n.get((String)"You cannot remove a line which has been already invoiced."));
        }
    }

    protected void checkInvoicedAdditionalContractLine(Contract contract) throws AxelorException {
        Contract origin = (Contract)((Object)this.find(contract.getId()));
        List lineInvoiced = origin.getAdditionalBenefitContractLineList().stream().filter(ContractLine::getIsInvoiced).collect(Collectors.toList());
        for (ContractLine line : contract.getAdditionalBenefitContractLineList()) {
            if (!lineInvoiced.contains((Object)line)) continue;
            lineInvoiced.remove((Object)line);
        }
        if (!lineInvoiced.isEmpty()) {
            throw new AxelorException(1, I18n.get((String)"You cannot remove a line which has been already invoiced."));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void waitingNextVersion(Contract contract, LocalDate date) throws AxelorException {
        ContractVersion version = contract.getNextVersion();
        this.versionService.waiting(version, date);
        this.save(contract);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void activeNextVersion(Contract contract, LocalDate date) throws AxelorException {
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        this.versionService.terminate(currentVersion, date.minusDays(1L));
        this.archiveVersion(contract, date);
        if (contract.getCurrentContractVersion().getDoNotRenew().booleanValue()) {
            contract.getCurrentContractVersion().setIsTacitRenewal(false);
        }
        this.ongoingCurrentVersion(contract, date);
        this.save(contract);
    }

    @Override
    @Transactional
    public void archiveVersion(Contract contract, LocalDate date) {
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        ContractVersion nextVersion = contract.getNextVersion();
        contract.addVersionHistory(currentVersion);
        currentVersion.setContract(null);
        contract.setCurrentContractVersion(nextVersion);
        nextVersion.setNextContract(null);
        nextVersion.setContract(contract);
        contract.setNextVersion(null);
        this.save(contract);
    }

    @Override
    public void checkCanTerminateContract(Contract contract) throws AxelorException {
        if (contract.getTerminatedDate() == null) {
            throw new AxelorException(1, I18n.get((String)"Please enter a terminated date for this version."));
        }
        ContractVersion version = contract.getCurrentContractVersion();
        if (contract.getTerminatedDate().isBefore(version.getActivationDate())) {
            throw new AxelorException(1, I18n.get((String)"You cannot terminate a contract before version activation date."));
        }
        if (version.getIsWithEngagement().booleanValue()) {
            if (contract.getEngagementStartDate() == null) {
                throw new AxelorException(1, I18n.get((String)"Please enter a engagement date."));
            }
            if (contract.getTerminatedDate().isBefore(this.durationService.computeDuration(version.getEngagementDuration(), contract.getEngagementStartDate()))) {
                throw new AxelorException(1, I18n.get((String)"Engagement duration is not fulfilled."));
            }
        }
        if (version.getIsWithPriorNotice().booleanValue() && contract.getTerminatedDate().isBefore(this.durationService.computeDuration(version.getPriorNoticeDuration(), ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate()))) {
            throw new AxelorException(1, I18n.get((String)"Prior notice duration is not respected."));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void terminateContract(Contract contract, Boolean isManual, LocalDate date) throws AxelorException {
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        if (currentVersion.getIsTacitRenewal().booleanValue() && !currentVersion.getDoNotRenew().booleanValue()) {
            this.renewContract(contract, date);
            return;
        }
        contract.setTerminatedManually(isManual);
        contract.setTerminatedDate(date);
        if (isManual.booleanValue()) {
            contract.setTerminationDemandDate(this.appBaseService.getTodayDate());
            contract.setTerminatedByUser(AuthUtils.getUser());
        }
        contract.setEndDate(date);
        this.close(contract, date);
        this.save(contract);
    }

    @Override
    @Transactional
    public void close(Contract contract, LocalDate terminationDate) {
        LocalDate today = this.appBaseService.getTodayDate();
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        if (terminationDate.isBefore(today) || terminationDate.equals(today)) {
            this.versionService.terminate(currentVersion, terminationDate);
            contract.setStatusSelect(3);
        }
        this.save(contract);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice invoicingContract(Contract contract) throws AxelorException {
        Invoice invoice = this.generateInvoice(contract);
        InvoiceRepository invoiceRepository = (InvoiceRepository)((Object)Beans.get(InvoiceRepository.class));
        invoiceRepository.save((Model)((Object)invoice));
        List additionalLines = contract.getAdditionalBenefitContractLineList().stream().filter(contractLine -> contractLine.getIsInvoiced() == false).peek(contractLine -> contractLine.setIsInvoiced(true)).collect(Collectors.toList());
        for (ContractLine line : additionalLines) {
            this.generate(invoice, line);
            this.contractLineRepo.save((Model)((Object)line));
        }
        for (ContractVersion version : this.getVersions(contract)) {
            BigDecimal ratio = BigDecimal.ONE;
            if (contract.getCurrentContractVersion().getIsTimeProratedInvoice().booleanValue()) {
                if (this.isFullProrated(contract) && !DateTool.isProrata((LocalDate)contract.getInvoicePeriodStartDate(), (LocalDate)contract.getInvoicePeriodEndDate(), (LocalDate)version.getActivationDate(), (LocalDate)version.getEndDate())) continue;
                LocalDate start = version.getActivationDate().isBefore(contract.getInvoicePeriodStartDate()) ? contract.getInvoicePeriodStartDate() : version.getActivationDate();
                LocalDate end = version.getEndDate() == null || version.getEndDate() != null && contract.getInvoicePeriodEndDate().isBefore(version.getEndDate()) ? contract.getInvoicePeriodEndDate() : version.getEndDate();
                ratio = this.durationService.computeRatio(start, end, contract.getCurrentContractVersion().getInvoicingDuration());
            }
            List lines = version.getContractLineList().stream().filter(contractLine -> contractLine.getIsConsumptionLine() == false).collect(Collectors.toList());
            for (ContractLine line : lines) {
                ContractLine tmp = (ContractLine)((Object)this.contractLineRepo.copy((Model)((Object)line), false));
                tmp.setAnalyticMoveLineList(line.getAnalyticMoveLineList());
                tmp.setQty(tmp.getQty().multiply(ratio).setScale(2, RoundingMode.HALF_UP));
                tmp = this.contractLineService.computeTotal(tmp);
                this.generate(invoice, tmp);
            }
        }
        Multimap<ContractLine, ConsumptionLine> consLines = this.mergeConsumptionLines(contract);
        for (Map.Entry entries : consLines.asMap().entrySet()) {
            ContractLine line = (ContractLine)((Object)entries.getKey());
            InvoiceLine invoiceLine = this.generate(invoice, line);
            ((Collection)entries.getValue()).stream().peek(cons -> cons.setInvoiceLine(invoiceLine)).forEach(cons -> cons.setIsInvoiced(true));
            line.setQty(BigDecimal.ZERO);
            this.contractLineService.computeTotal(line);
        }
        if (invoice.getInvoiceLineList() != null && !invoice.getInvoiceLineList().isEmpty()) {
            ((InvoiceServiceImpl)Beans.get(InvoiceServiceImpl.class)).compute(invoice);
        }
        this.increaseInvoiceDates(contract);
        return (Invoice)((Object)invoiceRepository.save((Model)((Object)invoice)));
    }

    public Invoice generateInvoice(Contract contract) throws AxelorException {
        InvoiceGeneratorContract invoiceGenerator = new InvoiceGeneratorContract(contract);
        Invoice invoice = invoiceGenerator.generate();
        return invoice;
    }

    @Override
    public Multimap<ContractLine, ConsumptionLine> mergeConsumptionLines(Contract contract) {
        HashMultimap mergedLines = HashMultimap.create();
        Stream<ConsumptionLine> lineStream = contract.getConsumptionLineList().stream().filter(c -> c.getIsInvoiced() == false);
        if (contract.getCurrentContractVersion().getIsConsumptionBeforeEndDate().booleanValue()) {
            lineStream = lineStream.filter(line -> line.getLineDate().isBefore(contract.getInvoicePeriodEndDate()));
        }
        lineStream.forEach(arg_0 -> this.lambda$mergeConsumptionLines$7(contract, (Multimap)mergedLines, arg_0));
        return mergedLines;
    }

    public InvoiceLine generate(Invoice invoice, ContractLine line) throws AxelorException {
        InvoiceLineGenerator invoiceLineGenerator = new InvoiceLineGenerator(invoice, line.getProduct(), line.getProductName(), line.getPrice(), this.invoiceLineService.convertUnitPrice(Boolean.valueOf(false), line.getTaxLine(), line.getPrice()), null, line.getDescription(), line.getQty(), line.getUnit(), line.getTaxLine(), line.getSequence(), BigDecimal.ZERO, 0, line.getExTaxTotal(), line.getInTaxTotal(), false, false, 0){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        InvoiceLine invoiceLine = (InvoiceLine)((Object)invoiceLineGenerator.creates().get(0));
        FiscalPositionAccountService fiscalPositionAccountService = (FiscalPositionAccountService)Beans.get(FiscalPositionAccountService.class);
        FiscalPosition fiscalPosition = line.getFiscalPosition();
        Account currentAccount = invoiceLine.getAccount();
        Account replacedAccount = fiscalPositionAccountService.getAccount(fiscalPosition, currentAccount);
        boolean isPurchase = ((InvoiceService)Beans.get(InvoiceService.class)).getPurchaseTypeOrSaleType(invoice) == 2;
        TaxLine taxLine = ((AccountManagementService)Beans.get(AccountManagementService.class)).getTaxLine(this.appBaseService.getTodayDate(), invoiceLine.getProduct(), invoice.getCompany(), fiscalPosition, isPurchase);
        invoiceLine.setTaxLine(taxLine);
        invoiceLine.setAccount(replacedAccount);
        if (line.getAnalyticDistributionTemplate() != null) {
            invoiceLine.setAnalyticDistributionTemplate(line.getAnalyticDistributionTemplate());
            this.copyAnalyticMoveLines(line.getAnalyticMoveLineList(), invoiceLine);
        }
        invoice.addInvoiceLineListItem(invoiceLine);
        return (InvoiceLine)((Object)((InvoiceLineRepository)((Object)Beans.get(InvoiceLineRepository.class))).save((Model)((Object)invoiceLine)));
    }

    public void copyAnalyticMoveLines(List<AnalyticMoveLine> originalAnalyticMoveLineList, InvoiceLine invoiceLine) {
        if (originalAnalyticMoveLineList == null) {
            return;
        }
        AnalyticMoveLineRepository analyticMoveLineRepo = (AnalyticMoveLineRepository)((Object)Beans.get(AnalyticMoveLineRepository.class));
        for (AnalyticMoveLine originalAnalyticMoveLine : originalAnalyticMoveLineList) {
            AnalyticMoveLine analyticMoveLine = (AnalyticMoveLine)((Object)analyticMoveLineRepo.copy((Model)((Object)originalAnalyticMoveLine), false));
            analyticMoveLine.setTypeSelect(2);
            analyticMoveLine.setContractLine(null);
            invoiceLine.addAnalyticMoveLineListItem(analyticMoveLine);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void renewContract(Contract contract, LocalDate date) throws AxelorException {
        ContractVersion currentVersion = contract.getCurrentContractVersion();
        ContractVersion nextVersion = (ContractVersion)((Object)((ContractVersionRepository)((Object)Beans.get(ContractVersionRepository.class))).copy((Model)((Object)currentVersion), true));
        this.versionService.terminate(currentVersion, date.minusDays(1L));
        contract.addVersionHistory(currentVersion);
        currentVersion.setContract(null);
        contract.setCurrentContractVersion(nextVersion);
        nextVersion.setNextContract(null);
        nextVersion.setContract(contract);
        if (nextVersion.getIsTacitRenewal().booleanValue()) {
            nextVersion.setSupposedEndDate(this.durationService.computeDuration(nextVersion.getRenewalDuration(), date));
        }
        if (nextVersion.getIsAutoEnableVersionOnRenew().booleanValue()) {
            this.versionService.ongoing(nextVersion, date);
        } else {
            this.versionService.waiting(nextVersion, date);
        }
        contract.setLastRenewalDate(date);
        contract.setRenewalNumber(contract.getRenewalNumber() + 1);
        this.save(contract);
    }

    public List<Contract> getContractToTerminate(LocalDate date) {
        return this.all().filter("self.statusSelect = ?1 AND self.currentContractVersion.statusSelect = ?2 AND self.isTacitRenewal IS FALSE AND (self.toClosed IS TRUE OR self.currentContractVersion.supposedEndDate >= ?3)", new Object[]{2, 3, date}).fetch();
    }

    public List<Contract> getContractToRenew(LocalDate date) {
        return this.all().filter("self.statusSelect = ?1 AND self.isTacitRenewal IS TRUE AND self.toClosed IS FALSE AND self.currentContractVersion.statusSelect = ?2 AND self.currentContractVersion.supposedEndDate >= ?3", new Object[]{2, 3, date}).fetch();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Contract copyFromTemplate(Contract contract, ContractTemplate template) throws AxelorException {
        if (template.getAdditionalBenefitContractLineList() != null && !template.getAdditionalBenefitContractLineList().isEmpty()) {
            for (ContractLine line : template.getAdditionalBenefitContractLineList()) {
                ContractLine newLine = (ContractLine)((Object)this.contractLineRepo.copy((Model)((Object)line), false));
                this.contractLineService.compute(newLine, contract, newLine.getProduct());
                this.contractLineService.computeTotal(newLine);
                this.contractLineRepo.save((Model)((Object)newLine));
                contract.addAdditionalBenefitContractLineListItem(newLine);
            }
        }
        contract.setCompany(template.getCompany());
        contract.setCurrency(template.getCurrency());
        contract.setIsAdditionaBenefitManagement(template.getIsAdditionaBenefitManagement());
        contract.setIsConsumptionManagement(template.getIsConsumptionManagement());
        contract.setIsInvoicingManagement(template.getIsInvoicingManagement());
        contract.setName(template.getName());
        contract.setNote(template.getNote());
        ContractVersion version = new ContractVersion();
        if (template.getContractLineList() != null && !template.getContractLineList().isEmpty()) {
            for (ContractLine line : template.getContractLineList()) {
                ContractLine newLine = (ContractLine)((Object)this.contractLineRepo.copy((Model)((Object)line), false));
                this.contractLineService.compute(newLine, contract, newLine.getProduct());
                this.contractLineService.computeTotal(newLine);
                this.contractLineRepo.save((Model)((Object)newLine));
                version.addContractLineListItem(newLine);
            }
        }
        version.setIsConsumptionBeforeEndDate(template.getIsConsumptionBeforeEndDate());
        version.setIsPeriodicInvoicing(template.getIsPeriodicInvoicing());
        version.setIsProratedFirstInvoice(template.getIsProratedFirstInvoice());
        version.setIsProratedInvoice(template.getIsProratedInvoice());
        version.setIsProratedLastInvoice(template.getIsProratedLastInvoice());
        version.setIsTacitRenewal(template.getIsTacitRenewal());
        version.setIsTimeProratedInvoice(template.getIsTimeProratedInvoice());
        version.setIsVersionProratedInvoice(template.getIsVersionProratedInvoice());
        version.setIsWithEngagement(template.getIsWithEngagement());
        version.setIsWithPriorNotice(template.getIsWithPriorNotice());
        version.setIsAutoEnableVersionOnRenew(template.getIsAutoEnableVersionOnRenew());
        version.setAutomaticInvoicing(template.getAutomaticInvoicing());
        version.setEngagementDuration(template.getEngagementDuration());
        version.setEngagementStartFromVersion(template.getEngagementStartFromVersion());
        version.setInvoicingDuration(template.getInvoicingDuration());
        version.setInvoicingMomentSelect(template.getInvoicingMomentSelect());
        version.setPaymentCondition(template.getPaymentCondition());
        version.setPaymentMode(template.getPaymentMode());
        version.setPriorNoticeDuration(template.getPriorNoticeDuration());
        version.setRenewalDuration(template.getRenewalDuration());
        version.setDescription(template.getDescription());
        contract.setCurrentContractVersion(version);
        return contract;
    }

    @Override
    public List<ContractVersion> getVersions(Contract contract) {
        if (contract.getCurrentContractVersion() == null || this.isFullProrated(contract)) {
            return ContractService.super.getVersions(contract);
        }
        return Collections.singletonList(contract.getCurrentContractVersion());
    }

    private /* synthetic */ void lambda$mergeConsumptionLines$7(Contract contract, Multimap mergedLines, ConsumptionLine line) {
        ContractVersion version = contract.getCurrentContractVersion();
        if (this.isFullProrated(contract)) {
            version = this.versionService.getContractVersion(contract, line.getLineDate());
        }
        if (version == null) {
            line.setIsError(true);
        } else {
            ContractLine matchLine = this.contractLineRepo.findOneBy(version, line.getProduct(), line.getReference(), true);
            if (matchLine == null) {
                line.setIsError(true);
            } else {
                matchLine.setQty(matchLine.getQty().add(line.getQty()));
                this.contractLineService.computeTotal(matchLine);
                line.setIsError(false);
                line.setContractLine(matchLine);
                mergedLines.put((Object)matchLine, (Object)line);
            }
        }
    }
}

