/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.web;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.db.ContractTemplate;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.contract.db.repo.ContractRepository;
import com.axelor.apps.contract.db.repo.ContractTemplateRepository;
import com.axelor.apps.contract.db.repo.ContractVersionRepository;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.apps.contract.service.ContractService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.time.LocalDate;

@Singleton
public class ContractController {
    public void waiting(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        try {
            ((ContractService)Beans.get(ContractService.class)).waitingCurrentVersion(contract, this.getTodayDate());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void ongoing(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        try {
            Invoice invoice = ((ContractService)Beans.get(ContractService.class)).ongoingCurrentVersion(contract, this.getTodayDate());
            if (invoice == null) {
                response.setReload(true);
            } else {
                response.setView(ActionView.define((String)I18n.get((String)"Invoice")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").param("forceTitle", "true").context("_showRecord", (Object)invoice.getId().toString()).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void invoicing(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        try {
            Invoice invoice = ((ContractService)Beans.get(ContractService.class)).invoicingContract(contract);
            response.setReload(true);
            response.setView(ActionView.define((String)I18n.get((String)"Invoice")).model(Invoice.class.getName()).add("form", "invoice-form").add("grid", "invoice-grid").param("forceTitle", "true").context("_showRecord", (Object)invoice.getId().toString()).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void terminated(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        try {
            ContractService service = (ContractService)Beans.get(ContractService.class);
            service.checkCanTerminateContract(contract);
            service.terminateContract(contract, true, contract.getTerminatedDate());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void close(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        ContractService service = (ContractService)Beans.get(ContractService.class);
        try {
            service.checkCanTerminateContract(contract);
            service.close(contract, contract.getTerminatedDate());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void renew(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        try {
            ((ContractService)Beans.get(ContractService.class)).renewContract(contract, this.getTodayDate());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void deleteNextVersion(ActionRequest request, ActionResponse response) {
        final Contract contract = (Contract)((Object)JPA.find(Contract.class, (Long)((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
        JPA.runInTransaction((Runnable)new Runnable(){

            @Override
            public void run() {
                ContractVersion version = contract.getNextVersion();
                contract.setNextVersion(null);
                ((ContractVersionRepository)((Object)Beans.get(ContractVersionRepository.class))).remove((Model)((Object)version));
                ((ContractRepository)((Object)Beans.get(ContractRepository.class))).save(contract);
            }
        });
        response.setReload(true);
    }

    public void saveNextVersion(ActionRequest request, ActionResponse response) {
        final ContractVersion version = (ContractVersion)((Object)JPA.find(ContractVersion.class, (Long)((ContractVersion)((Object)request.getContext().asType(ContractVersion.class))).getId()));
        if (version.getNextContract() != null) {
            return;
        }
        Object xContractId = request.getContext().get((Object)"_xContractId");
        final Long contractId = xContractId != null ? Long.valueOf(xContractId.toString()) : (version.getContract() != null ? version.getContract().getId() : null);
        if (contractId == null) {
            return;
        }
        JPA.runInTransaction((Runnable)new Runnable(){

            @Override
            public void run() {
                Contract contract = (Contract)((Object)JPA.find(Contract.class, (Long)contractId));
                contract.setNextVersion(version);
                ((ContractRepository)((Object)Beans.get(ContractRepository.class))).save(contract);
            }
        });
        response.setReload(true);
    }

    public void copyFromTemplate(ActionRequest request, ActionResponse response) {
        try {
            ContractTemplate template = (ContractTemplate)((Object)ModelTool.toBean(ContractTemplate.class, (Object)request.getContext().get((Object)"contractTemplate")));
            template = (ContractTemplate)((Object)((ContractTemplateRepository)((Object)Beans.get(ContractTemplateRepository.class))).find(template.getId()));
            Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(((Contract)((Object)request.getContext().asType(Contract.class))).getId()));
            ((ContractService)Beans.get(ContractService.class)).copyFromTemplate(contract, template);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }

    public void changeProduct(ActionRequest request, ActionResponse response) {
        ContractLineService contractLineService = (ContractLineService)Beans.get(ContractLineService.class);
        ContractLine contractLine = new ContractLine();
        try {
            contractLine = (ContractLine)((Object)request.getContext().asType(ContractLine.class));
            Contract contract = (Contract)((Object)request.getContext().getParent().asType(Contract.class));
            Product product = contractLine.getProduct();
            contractLine = contractLineService.fillAndCompute(contractLine, contract, product);
            response.setValues((Object)contractLine);
        }
        catch (Exception e) {
            response.setValues((Object)contractLineService.reset(contractLine));
        }
    }

    private LocalDate getTodayDate() {
        return ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate();
    }

    public void isValid(ActionRequest request, ActionResponse response) {
        Contract contract = (Contract)((Object)request.getContext().asType(Contract.class));
        try {
            ((ContractService)Beans.get(ContractService.class)).isValid(contract);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.ERROR);
        }
    }
}

