/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.web;

import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;

@Singleton
public class ContractLineController {
    public void computeTotal(ActionRequest request, ActionResponse response) {
        ContractLine contractLine = (ContractLine)((Object)request.getContext().asType(ContractLine.class));
        ContractLineService contractLineService = (ContractLineService)Beans.get(ContractLineService.class);
        try {
            contractLine = contractLineService.computeTotal(contractLine);
            response.setValues((Object)contractLine);
        }
        catch (Exception e) {
            response.setValues((Object)contractLineService.reset(contractLine));
        }
    }

    public void createAnalyticDistributionWithTemplate(ActionRequest request, ActionResponse response) {
        ContractLine contractLine = (ContractLine)((Object)request.getContext().asType(ContractLine.class));
        Context parentContext = request.getContext().getParent();
        Contract contract = null;
        if (parentContext.get((Object)"_model").equals(Contract.class.getCanonicalName())) {
            contract = (Contract)((Object)parentContext.asType(Contract.class));
        } else if (parentContext.getParent() != null && parentContext.getParent().get((Object)"_model").equals(Contract.class.getCanonicalName())) {
            contract = (Contract)((Object)parentContext.getParent().asType(Contract.class));
        }
        contractLine = ((ContractLineService)Beans.get(ContractLineService.class)).createAnalyticDistributionWithTemplate(contractLine, contract);
        response.setValue("analyticMoveLineList", contractLine.getAnalyticMoveLineList());
    }
}

