/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.contract.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.contract.db.Contract;
import com.axelor.apps.contract.db.ContractLine;
import com.axelor.apps.contract.db.ContractVersion;
import com.axelor.apps.contract.db.repo.ContractRepository;
import com.axelor.apps.contract.db.repo.ContractVersionRepository;
import com.axelor.apps.contract.service.ContractLineService;
import com.axelor.apps.contract.service.ContractService;
import com.axelor.apps.contract.service.ContractVersionService;
import com.axelor.db.JPA;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.time.LocalDate;

@Singleton
public class ContractVersionController {
    public void newDraft(ActionRequest request, ActionResponse response) {
        Long contractId = Long.valueOf(request.getContext().get((Object)"_xContractId").toString());
        Contract contract = (Contract)((Object)((ContractRepository)((Object)Beans.get(ContractRepository.class))).find(contractId));
        ContractVersion newVersion = ((ContractVersionService)Beans.get(ContractVersionService.class)).newDraft(contract);
        response.setValues((Object)Mapper.toMap((Object)((Object)newVersion)));
    }

    public void save(ActionRequest request, ActionResponse response) {
        ContractVersion version = (ContractVersion)((Object)JPA.find(ContractVersion.class, (Long)((ContractVersion)((Object)request.getContext().asType(ContractVersion.class))).getId()));
        if (version.getNextContract() != null) {
            return;
        }
        Object xContractId = request.getContext().get((Object)"_xContractId");
        Long contractId = xContractId != null ? Long.valueOf(xContractId.toString()) : (version.getContract() != null ? version.getContract().getId() : null);
        if (contractId == null) {
            return;
        }
        JPA.runInTransaction(() -> {
            Contract contract = (Contract)((Object)((Object)JPA.find(Contract.class, (Long)contractId)));
            contract.setNextVersion(version);
            ((ContractRepository)((Object)((Object)Beans.get(ContractRepository.class)))).save(contract);
        });
        response.setReload(true);
    }

    public void active(ActionRequest request, ActionResponse response) {
        try {
            Long id = ((ContractVersion)((Object)request.getContext().asType(ContractVersion.class))).getId();
            ContractVersion contractVersion = (ContractVersion)((Object)((ContractVersionRepository)((Object)Beans.get(ContractVersionRepository.class))).find(id));
            ((ContractService)Beans.get(ContractService.class)).activeNextVersion(contractVersion.getNextContract(), this.getTodayDate());
            response.setView(ActionView.define((String)"Contract").model(Contract.class.getName()).add("form", "contract-form").add("grid", "contract-grid").context("_showRecord", (Object)contractVersion.getContract().getId()).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void waiting(ActionRequest request, ActionResponse response) {
        try {
            Long id = ((ContractVersion)((Object)request.getContext().asType(ContractVersion.class))).getId();
            ContractVersion contractVersion = (ContractVersion)((Object)((ContractVersionRepository)((Object)Beans.get(ContractVersionRepository.class))).find(id));
            ((ContractService)Beans.get(ContractService.class)).waitingNextVersion(contractVersion.getNextContract(), this.getTodayDate());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void changeProduct(ActionRequest request, ActionResponse response) {
        ContractLineService contractLineService = (ContractLineService)Beans.get(ContractLineService.class);
        ContractLine contractLine = new ContractLine();
        try {
            contractLine = (ContractLine)((Object)request.getContext().asType(ContractLine.class));
            ContractVersion contractVersion = (ContractVersion)((Object)request.getContext().getParent().asType(ContractVersion.class));
            Contract contract = contractVersion.getNextContract() == null ? contractVersion.getContract() : contractVersion.getNextContract();
            Product product = contractLine.getProduct();
            contractLine = contractLineService.fillAndCompute(contractLine, contract, product);
            response.setValues((Object)contractLine);
        }
        catch (Exception e) {
            response.setValues((Object)contractLineService.reset(contractLine));
        }
    }

    private LocalDate getTodayDate() {
        return ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate();
    }
}

