/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_PROJECT_FOLDER", indexes={@Index(columnList="name")})
public class ProjectFolder
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_FOLDER_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_FOLDER_SEQ", sequenceName="PROJECT_PROJECT_FOLDER_SEQ", allocationSize=1)
    private Long id;
    private String name;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="projectFolderSet", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Project> projectSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProjectFolder() {
    }

    public ProjectFolder(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Project> getProjectSet() {
        return this.projectSet;
    }

    public void setProjectSet(Set<Project> projectSet) {
        this.projectSet = projectSet;
    }

    public void addProjectSetItem(Project item) {
        if (this.getProjectSet() == null) {
            this.setProjectSet(new HashSet<Project>());
        }
        this.getProjectSet().add(item);
    }

    public void removeProjectSetItem(Project item) {
        if (this.getProjectSet() == null) {
            return;
        }
        this.getProjectSet().remove((Object)item);
    }

    public void clearProjectSet() {
        if (this.getProjectSet() != null) {
            this.getProjectSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectFolder)) {
            return false;
        }
        ProjectFolder other = (ProjectFolder)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

