/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_PROJECT_STATUS", indexes={@Index(columnList="name")})
public class ProjectStatus
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_PROJECT_STATUS_SEQ")
    @SequenceGenerator(name="PROJECT_PROJECT_STATUS_SEQ", sequenceName="PROJECT_PROJECT_STATUS_SEQ", allocationSize=1)
    private Long id;
    private String name;
    private Boolean defaultStatus = Boolean.FALSE;
    private Boolean isOpen = Boolean.FALSE;
    private Boolean isClose = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ProjectStatus() {
    }

    public ProjectStatus(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getDefaultStatus() {
        return this.defaultStatus == null ? Boolean.FALSE : this.defaultStatus;
    }

    public void setDefaultStatus(Boolean defaultStatus) {
        this.defaultStatus = defaultStatus;
    }

    public Boolean getIsOpen() {
        return this.isOpen == null ? Boolean.FALSE : this.isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Boolean getIsClose() {
        return this.isClose == null ? Boolean.FALSE : this.isClose;
    }

    public void setIsClose(Boolean isClose) {
        this.isClose = isClose;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProjectStatus)) {
            return false;
        }
        ProjectStatus other = (ProjectStatus)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("defaultStatus", (Object)this.getDefaultStatus()).add("isOpen", (Object)this.getIsOpen()).add("isClose", (Object)this.getIsClose()).omitNullValues().toString();
    }
}

