/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectFolder;
import com.axelor.apps.project.db.ProjectTemplate;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.apps.project.db.Wiki;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.project.db.repo.WikiRepository;
import com.axelor.apps.project.service.ProjectService;
import com.axelor.apps.project.service.TeamTaskProjectService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.TypedQuery;

public class ProjectServiceImpl
implements ProjectService {
    public static final int MAX_LEVEL_OF_PROJECT = 10;
    private ProjectRepository projectRepository;
    @Inject
    WikiRepository wikiRepo;
    @Inject
    TeamTaskProjectService teamTaskProjectService;

    @Inject
    public ProjectServiceImpl(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Override
    public Project generateProject(Project parentProject, String fullName, User assignedTo, Company company, Partner clientPartner) {
        Project project = this.projectRepository.findByName(fullName);
        if (project != null) {
            return project;
        }
        project = new Project();
        project.setStatusSelect(ProjectRepository.STATE_NEW);
        project.setParentProject(parentProject);
        if (parentProject != null) {
            parentProject.addChildProjectListItem(project);
            project.setProjectTypeSelect(ProjectRepository.TYPE_PHASE);
        } else {
            project.setProjectTypeSelect(ProjectRepository.TYPE_PROJECT);
        }
        if (Strings.isNullOrEmpty((String)fullName)) {
            fullName = "project";
        }
        project.setName(fullName);
        project.setFullName(project.getName());
        project.setCompany(company);
        project.setClientPartner(clientPartner);
        project.setAssignedTo(assignedTo);
        project.setProgress(BigDecimal.ZERO);
        return project;
    }

    @Override
    @Transactional
    public Project generateProject(Partner partner) {
        Preconditions.checkNotNull((Object)partner);
        User user = AuthUtils.getUser();
        Project project = ((ProjectService)Beans.get(ProjectService.class)).generateProject(null, this.getUniqueProjectName(partner), user, user.getActiveCompany(), partner);
        return (Project)((Object)this.projectRepository.save((Model)((Object)project)));
    }

    private String getUniqueProjectName(Partner partner) {
        String name;
        String baseName = String.format(I18n.get((String)"%s project"), partner.getName());
        long count = this.projectRepository.all().filter(String.format("self.name LIKE '%s%%'", baseName)).count();
        if (count == 0L) {
            return baseName;
        }
        while (this.projectRepository.findByName(name = String.format("%s %d", baseName, ++count)) != null) {
        }
        return name;
    }

    @Override
    public Partner getClientPartnerFromProject(Project project) throws AxelorException {
        return this.getClientPartnerFromProject(project, 0);
    }

    private Partner getClientPartnerFromProject(Project project, int counter) throws AxelorException {
        if (project.getParentProject() == null) {
            if (project.getClientPartner() == null) {
                throw new AxelorException(4, I18n.get((String)"The selected project/task doesn't contain any customers"));
            }
            return project.getClientPartner();
        }
        if (counter > 10) {
            throw new AxelorException(4, I18n.get((String)"The deep limit of the project is too high"));
        }
        return this.getClientPartnerFromProject(project.getParentProject(), counter + 1);
    }

    @Override
    public BigDecimal computeDurationFromChildren(Long projectId) {
        String query = "SELECT SUM(pt.duration) FROM Project as pt WHERE pt.project.id = :projectId";
        TypedQuery q = JPA.em().createQuery(query, BigDecimal.class);
        q.setParameter("projectId", (Object)projectId);
        return (BigDecimal)q.getSingleResult();
    }

    @Override
    @Transactional
    public Project createProjectFromTemplate(ProjectTemplate projectTemplate, String projectCode, Partner clientPartner) throws AxelorException {
        Project project = new Project();
        project.setName(projectTemplate.getName());
        if (this.projectRepository.all().filter("self.code = ?", new Object[]{projectCode}).count() > 0L) {
            throw new AxelorException(5, "Project code is already used. Please provide unique code");
        }
        project.setCode(projectCode);
        project.setClientPartner(clientPartner);
        if (clientPartner != null && clientPartner.getContactPartnerSet() != null && !clientPartner.getContactPartnerSet().isEmpty()) {
            project.setContactPartner((Partner)clientPartner.getContactPartnerSet().iterator().next());
        }
        project.setDescription(projectTemplate.getDescription());
        project.setTeam(projectTemplate.getTeam());
        project.setProjectFolderSet(new HashSet<ProjectFolder>(projectTemplate.getProjectFolderSet()));
        project.setAssignedTo(projectTemplate.getAssignedTo());
        project.setTeamTaskCategorySet(new HashSet<TeamTaskCategory>(projectTemplate.getTeamTaskCategorySet()));
        project.setSynchronize(projectTemplate.getSynchronize());
        project.setMembersUserSet(new HashSet<User>(projectTemplate.getMembersUserSet()));
        project.setImputable(projectTemplate.getImputable());
        project.setCompany(projectTemplate.getCompany());
        project.setProductSet(new HashSet<Product>(projectTemplate.getProductSet()));
        project.setExcludePlanning(projectTemplate.getExcludePlanning());
        project.setProjectTypeSelect(ProjectRepository.TYPE_PROJECT);
        List<Wiki> wikiList = projectTemplate.getWikiList();
        if (wikiList != null && !wikiList.isEmpty()) {
            for (Wiki wiki : wikiList) {
                wiki = (Wiki)((Object)this.wikiRepo.copy((Model)((Object)wiki), false));
                wiki.setProjectTemplate(null);
                project.addWikiListItem(wiki);
            }
        }
        this.projectRepository.save((Model)((Object)project));
        Set<TaskTemplate> taskTemplateSet = projectTemplate.getTaskTemplateSet();
        if (taskTemplateSet != null) {
            Iterator<TaskTemplate> taskTemplateItr = taskTemplateSet.iterator();
            while (taskTemplateItr.hasNext()) {
                this.createTask(taskTemplateItr.next(), project);
            }
        }
        return project;
    }

    public TeamTask createTask(TaskTemplate taskTemplate, Project project) {
        TeamTask task = this.teamTaskProjectService.create(taskTemplate.getName(), project, taskTemplate.getAssignedTo());
        task.setDescription(taskTemplate.getDescription());
        return task;
    }
}

