/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.base.service.TeamTaskServiceImpl;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.service.TeamTaskProjectService;
import com.axelor.auth.db.User;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import java.time.LocalDate;

public class TeamTaskProjectServiceImpl
extends TeamTaskServiceImpl
implements TeamTaskProjectService {
    @Inject
    public TeamTaskProjectServiceImpl(TeamTaskRepository teamTaskRepo) {
        super(teamTaskRepo);
    }

    @Override
    public TeamTask create(String subject, Project project, User assignedTo) {
        TeamTask task = new TeamTask();
        task.setName(subject);
        task.setAssignedTo(assignedTo);
        task.setTaskDate(LocalDate.now());
        task.setStatus("new");
        task.setPriority("normal");
        project.addTeamTaskListItem(task);
        return task;
    }

    protected void setModuleFields(TeamTask teamTask, LocalDate date, TeamTask newTeamTask) {
        super.setModuleFields(teamTask, date, newTeamTask);
        newTeamTask.setProgressSelect(0);
        newTeamTask.setTaskEndDate(date);
    }

    protected void updateModuleFields(TeamTask teamTask, TeamTask nextTeamTask) {
        super.updateModuleFields(teamTask, nextTeamTask);
        nextTeamTask.setFullName(teamTask.getFullName());
        nextTeamTask.setProject(teamTask.getProject());
        nextTeamTask.setTeamTaskCategory(teamTask.getTeamTaskCategory());
        nextTeamTask.setProgressSelect(0);
        teamTask.getMembersUserSet().forEach(nextTeamTask::addMembersUserSetItem);
        nextTeamTask.setTeam(teamTask.getTeam());
        nextTeamTask.setParentTask(teamTask.getParentTask());
        nextTeamTask.setProduct(teamTask.getProduct());
        nextTeamTask.setUnit(teamTask.getUnit());
        nextTeamTask.setQuantity(teamTask.getQuantity());
        nextTeamTask.setUnitPrice(teamTask.getUnitPrice());
        nextTeamTask.setTaskEndDate(teamTask.getTaskEndDate());
        nextTeamTask.setBudgetedTime(teamTask.getBudgetedTime());
        nextTeamTask.setCurrency(teamTask.getCurrency());
    }
}

