/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.web;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.service.ProjectService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class PartnerController {
    public void generateProject(ActionRequest request, ActionResponse response) {
        try {
            Partner partner = (Partner)request.getContext().asType(Partner.class);
            partner = (Partner)((PartnerRepository)Beans.get(PartnerRepository.class)).find(partner.getId());
            Project project = ((ProjectService)Beans.get(ProjectService.class)).generateProject(partner);
            response.setView(ActionView.define((String)I18n.get((String)"Generated project")).model(Project.class.getName()).add("form", "project-form").add("grid", "project-grid").param("forceTitle", "true").param("forceEdit", "true").context("_showRecord", (Object)project.getId()).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

