/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.fleet.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.fleet.db.Vehicle;
import com.axelor.apps.fleet.db.VehicleService;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="FLEET_VEHICLE_CONTRACT", indexes={@Index(columnList="name"), @Index(columnList="insurer_partner"), @Index(columnList="purchaser_partner"), @Index(columnList="vehicle")})
public class VehicleContract
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FLEET_VEHICLE_CONTRACT_SEQ")
    @SequenceGenerator(name="FLEET_VEHICLE_CONTRACT_SEQ", sequenceName="FLEET_VEHICLE_CONTRACT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Active")
    private Boolean active = Boolean.FALSE;
    @Widget(title="Contract Start date")
    private LocalDate startDate;
    @Widget(title="Contract Expiration Date")
    private LocalDate expiryDate;
    @Widget(title="Warning Date")
    private Integer daysLeft = 0;
    @Widget(title="Vendor")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner insurerPartner;
    @Widget(title="Contractor")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner purchaserPartner;
    @Widget(title="Type", selection="fleet.vehicle.cost.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Contract Reference")
    private String reference;
    @Widget(title="Status", selection="fleet.vehicle.contract.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String notes;
    @Widget(title="Recurring Cost")
    private BigDecimal recurringCost = BigDecimal.ZERO;
    @Widget(title="Recurring Cost Frequency", selection="fleet.vehicle.contract.cost.frequency.select")
    private Integer costFrequencySelect = 0;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<VehicleService> vehicleServiceList;
    @Widget(title="Total cost")
    private BigDecimal totalCost = BigDecimal.ZERO;
    @Widget(title="Activation Cost")
    private BigDecimal activationCost = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Vehicle vehicle;
    @Widget(title="Invoice Date")
    private LocalDate invoiceDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public VehicleContract() {
    }

    public VehicleContract(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getActive() {
        return this.active == null ? Boolean.FALSE : this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(LocalDate expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Integer getDaysLeft() {
        return this.daysLeft == null ? 0 : this.daysLeft;
    }

    public void setDaysLeft(Integer daysLeft) {
        this.daysLeft = daysLeft;
    }

    public Partner getInsurerPartner() {
        return this.insurerPartner;
    }

    public void setInsurerPartner(Partner insurerPartner) {
        this.insurerPartner = insurerPartner;
    }

    public Partner getPurchaserPartner() {
        return this.purchaserPartner;
    }

    public void setPurchaserPartner(Partner purchaserPartner) {
        this.purchaserPartner = purchaserPartner;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public BigDecimal getRecurringCost() {
        return this.recurringCost == null ? BigDecimal.ZERO : this.recurringCost;
    }

    public void setRecurringCost(BigDecimal recurringCost) {
        this.recurringCost = recurringCost;
    }

    public Integer getCostFrequencySelect() {
        return this.costFrequencySelect == null ? 0 : this.costFrequencySelect;
    }

    public void setCostFrequencySelect(Integer costFrequencySelect) {
        this.costFrequencySelect = costFrequencySelect;
    }

    public List<VehicleService> getVehicleServiceList() {
        return this.vehicleServiceList;
    }

    public void setVehicleServiceList(List<VehicleService> vehicleServiceList) {
        this.vehicleServiceList = vehicleServiceList;
    }

    public void addVehicleServiceListItem(VehicleService item) {
        if (this.getVehicleServiceList() == null) {
            this.setVehicleServiceList(new ArrayList<VehicleService>());
        }
        this.getVehicleServiceList().add(item);
    }

    public void removeVehicleServiceListItem(VehicleService item) {
        if (this.getVehicleServiceList() == null) {
            return;
        }
        this.getVehicleServiceList().remove((Object)item);
    }

    public void clearVehicleServiceList() {
        if (this.getVehicleServiceList() != null) {
            this.getVehicleServiceList().clear();
        }
    }

    public BigDecimal getTotalCost() {
        return this.totalCost == null ? BigDecimal.ZERO : this.totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public BigDecimal getActivationCost() {
        return this.activationCost == null ? BigDecimal.ZERO : this.activationCost;
    }

    public void setActivationCost(BigDecimal activationCost) {
        this.activationCost = activationCost;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VehicleContract)) {
            return false;
        }
        VehicleContract other = (VehicleContract)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("active", (Object)this.getActive()).add("startDate", (Object)this.getStartDate()).add("expiryDate", (Object)this.getExpiryDate()).add("daysLeft", (Object)this.getDaysLeft()).add("typeSelect", (Object)this.getTypeSelect()).add("reference", (Object)this.getReference()).add("statusSelect", (Object)this.getStatusSelect()).add("recurringCost", (Object)this.getRecurringCost()).add("costFrequencySelect", (Object)this.getCostFrequencySelect()).add("totalCost", (Object)this.getTotalCost()).omitNullValues().toString();
    }
}

