/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.fleet.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.fleet.db.VehicleMake;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="FLEET_VEHICLE_MODEL", indexes={@Index(columnList="vehicle_make"), @Index(columnList="name")})
public class VehicleModel
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FLEET_VEHICLE_MODEL_SEQ")
    @SequenceGenerator(name="FLEET_VEHICLE_MODEL_SEQ", sequenceName="FLEET_VEHICLE_MODEL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Make")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private VehicleMake vehicleMake;
    @Widget(title="Model")
    @NotNull
    private String model;
    @Widget(title="Name")
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    @NotNull
    private String name;
    @Widget(title="Vendors")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> vehicleVendorsSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public VehicleModel() {
    }

    public VehicleModel(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public VehicleMake getVehicleMake() {
        return this.vehicleMake;
    }

    public void setVehicleMake(VehicleMake vehicleMake) {
        this.vehicleMake = vehicleMake;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.vehicleMake != null) {
            return this.vehicleMake != null ? this.vehicleMake.getName() + " " + this.model : this.model;
        }
        return this.model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Partner> getVehicleVendorsSet() {
        return this.vehicleVendorsSet;
    }

    public void setVehicleVendorsSet(Set<Partner> vehicleVendorsSet) {
        this.vehicleVendorsSet = vehicleVendorsSet;
    }

    public void addVehicleVendorsSetItem(Partner item) {
        if (this.getVehicleVendorsSet() == null) {
            this.setVehicleVendorsSet(new HashSet<Partner>());
        }
        this.getVehicleVendorsSet().add(item);
    }

    public void removeVehicleVendorsSetItem(Partner item) {
        if (this.getVehicleVendorsSet() == null) {
            return;
        }
        this.getVehicleVendorsSet().remove(item);
    }

    public void clearVehicleVendorsSet() {
        if (this.getVehicleVendorsSet() != null) {
            this.getVehicleVendorsSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VehicleModel)) {
            return false;
        }
        VehicleModel other = (VehicleModel)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("model", (Object)this.getModel()).omitNullValues().toString();
    }
}

