/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.fleet.db;

import com.axelor.apps.base.db.Unit;
import com.axelor.apps.fleet.db.Vehicle;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="FLEET_VEHICLE_ODOMETER", indexes={@Index(columnList="name"), @Index(columnList="vehicle"), @Index(columnList="unit")})
public class VehicleOdometer
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="FLEET_VEHICLE_ODOMETER_SEQ")
    @SequenceGenerator(name="FLEET_VEHICLE_ODOMETER_SEQ", sequenceName="FLEET_VEHICLE_ODOMETER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    private String name;
    @Widget(title="Date")
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Kilometric value")
    private BigDecimal value = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Vehicle vehicle;
    @Widget(title="Odometer unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit unit;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public VehicleOdometer() {
    }

    public VehicleOdometer(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BigDecimal getValue() {
        return this.value == null ? BigDecimal.ZERO : this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public Vehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(Vehicle vehicle) {
        this.vehicle = vehicle;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VehicleOdometer)) {
            return false;
        }
        VehicleOdometer other = (VehicleOdometer)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("date", (Object)this.getDate()).add("value", (Object)this.getValue()).omitNullValues().toString();
    }
}

