/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="STOCK_CUSTOMS_CODE_NOMENCLATURE", indexes={@Index(columnList="parent_customs_code")})
public class CustomsCodeNomenclature
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_CUSTOMS_CODE_NOMENCLATURE_SEQ")
    @SequenceGenerator(name="STOCK_CUSTOMS_CODE_NOMENCLATURE_SEQ", sequenceName="STOCK_CUSTOMS_CODE_NOMENCLATURE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @NameColumn
    @Size(max=10)
    @Column(unique=true, nullable=false)
    private String code;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String wording;
    private String supplementaryUnit;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CustomsCodeNomenclature parentCustomsCode;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public CustomsCodeNomenclature() {
    }

    public CustomsCodeNomenclature(String code) {
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getWording() {
        return this.wording;
    }

    public void setWording(String wording) {
        this.wording = wording;
    }

    public String getSupplementaryUnit() {
        return this.supplementaryUnit;
    }

    public void setSupplementaryUnit(String supplementaryUnit) {
        this.supplementaryUnit = supplementaryUnit;
    }

    public CustomsCodeNomenclature getParentCustomsCode() {
        return this.parentCustomsCode;
    }

    public void setParentCustomsCode(CustomsCodeNomenclature parentCustomsCode) {
        this.parentCustomsCode = parentCustomsCode;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomsCodeNomenclature)) {
            return false;
        }
        CustomsCodeNomenclature other = (CustomsCodeNomenclature)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(843547942, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("supplementaryUnit", (Object)this.getSupplementaryUnit()).omitNullValues().toString();
    }
}

