/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="STOCK_INCOTERM", indexes={@Index(columnList="name"), @Index(columnList="code"), @Index(columnList="fullname")})
public class Incoterm
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="STOCK_INCOTERM_SEQ")
    @SequenceGenerator(name="STOCK_INCOTERM_SEQ", sequenceName="STOCK_INCOTERM_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Incoterm Name")
    @NotNull
    private String name;
    @Widget(title="Incoterm Code")
    @NotNull
    private String code;
    @Widget(title="Fullname")
    @NameColumn
    private String fullname;
    @Widget(title="Export customs declaration", selection="stock.incoterm.allocation.select")
    private Integer exportCustomsDeclaration = 0;
    @Widget(title="Carriage to port of export", selection="stock.incoterm.allocation.select")
    private Integer carriageToPortOfExport = 0;
    @Widget(title="Unloading of truck in port of export", selection="stock.incoterm.allocation.select")
    private Integer unloadingOfTruckInPortOfExport = 0;
    @Widget(title="Loading on vessel/airplane in port of export", selection="stock.incoterm.allocation.select")
    private Integer loadingInPortOfExport = 0;
    @Widget(title="Carriage (Sea/Air) to port of import", selection="stock.incoterm.allocation.select")
    private Integer carriageToPortOfImport = 0;
    @Widget(title="Insurance", selection="stock.incoterm.allocation.select")
    private Integer insurance = 0;
    @Widget(title="Unloading in port of import", selection="stock.incoterm.allocation.select")
    private Integer unloadingInPortOfImport = 0;
    @Widget(title="Loading on truck in port of import", selection="stock.incoterm.allocation.select")
    private Integer loadingOnTruckInPortOfImport = 0;
    @Widget(title="Carriage to place of destination", selection="stock.incoterm.allocation.select")
    private Integer carriageToPlaceOfDestination = 0;
    @Widget(title="Import customs clearance", selection="stock.incoterm.allocation.select")
    private Integer importCustomsClearance = 0;
    @Widget(title="Import duties and taxes", selection="stock.incoterm.allocation.select")
    private Integer importDutiesAndTaxes = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Incoterm() {
    }

    public Incoterm(String name, String code, String fullname) {
        this.name = name;
        this.code = code;
        this.fullname = fullname;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public Integer getExportCustomsDeclaration() {
        return this.exportCustomsDeclaration == null ? 0 : this.exportCustomsDeclaration;
    }

    public void setExportCustomsDeclaration(Integer exportCustomsDeclaration) {
        this.exportCustomsDeclaration = exportCustomsDeclaration;
    }

    public Integer getCarriageToPortOfExport() {
        return this.carriageToPortOfExport == null ? 0 : this.carriageToPortOfExport;
    }

    public void setCarriageToPortOfExport(Integer carriageToPortOfExport) {
        this.carriageToPortOfExport = carriageToPortOfExport;
    }

    public Integer getUnloadingOfTruckInPortOfExport() {
        return this.unloadingOfTruckInPortOfExport == null ? 0 : this.unloadingOfTruckInPortOfExport;
    }

    public void setUnloadingOfTruckInPortOfExport(Integer unloadingOfTruckInPortOfExport) {
        this.unloadingOfTruckInPortOfExport = unloadingOfTruckInPortOfExport;
    }

    public Integer getLoadingInPortOfExport() {
        return this.loadingInPortOfExport == null ? 0 : this.loadingInPortOfExport;
    }

    public void setLoadingInPortOfExport(Integer loadingInPortOfExport) {
        this.loadingInPortOfExport = loadingInPortOfExport;
    }

    public Integer getCarriageToPortOfImport() {
        return this.carriageToPortOfImport == null ? 0 : this.carriageToPortOfImport;
    }

    public void setCarriageToPortOfImport(Integer carriageToPortOfImport) {
        this.carriageToPortOfImport = carriageToPortOfImport;
    }

    public Integer getInsurance() {
        return this.insurance == null ? 0 : this.insurance;
    }

    public void setInsurance(Integer insurance) {
        this.insurance = insurance;
    }

    public Integer getUnloadingInPortOfImport() {
        return this.unloadingInPortOfImport == null ? 0 : this.unloadingInPortOfImport;
    }

    public void setUnloadingInPortOfImport(Integer unloadingInPortOfImport) {
        this.unloadingInPortOfImport = unloadingInPortOfImport;
    }

    public Integer getLoadingOnTruckInPortOfImport() {
        return this.loadingOnTruckInPortOfImport == null ? 0 : this.loadingOnTruckInPortOfImport;
    }

    public void setLoadingOnTruckInPortOfImport(Integer loadingOnTruckInPortOfImport) {
        this.loadingOnTruckInPortOfImport = loadingOnTruckInPortOfImport;
    }

    public Integer getCarriageToPlaceOfDestination() {
        return this.carriageToPlaceOfDestination == null ? 0 : this.carriageToPlaceOfDestination;
    }

    public void setCarriageToPlaceOfDestination(Integer carriageToPlaceOfDestination) {
        this.carriageToPlaceOfDestination = carriageToPlaceOfDestination;
    }

    public Integer getImportCustomsClearance() {
        return this.importCustomsClearance == null ? 0 : this.importCustomsClearance;
    }

    public void setImportCustomsClearance(Integer importCustomsClearance) {
        this.importCustomsClearance = importCustomsClearance;
    }

    public Integer getImportDutiesAndTaxes() {
        return this.importDutiesAndTaxes == null ? 0 : this.importDutiesAndTaxes;
    }

    public void setImportDutiesAndTaxes(Integer importDutiesAndTaxes) {
        this.importDutiesAndTaxes = importDutiesAndTaxes;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Incoterm)) {
            return false;
        }
        Incoterm other = (Incoterm)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("fullname", (Object)this.getFullname()).add("exportCustomsDeclaration", (Object)this.getExportCustomsDeclaration()).add("carriageToPortOfExport", (Object)this.getCarriageToPortOfExport()).add("unloadingOfTruckInPortOfExport", (Object)this.getUnloadingOfTruckInPortOfExport()).add("loadingInPortOfExport", (Object)this.getLoadingInPortOfExport()).add("carriageToPortOfImport", (Object)this.getCarriageToPortOfImport()).add("insurance", (Object)this.getInsurance()).add("unloadingInPortOfImport", (Object)this.getUnloadingInPortOfImport()).add("loadingOnTruckInPortOfImport", (Object)this.getLoadingOnTruckInPortOfImport()).omitNullValues().toString();
    }
}

