/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCategory;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.Inventory;
import com.axelor.apps.stock.db.InventoryLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.repo.InventoryRepository;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.db.repo.TrackingNumberRepository;
import com.axelor.apps.stock.service.InventoryLineService;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected InventoryLineService inventoryLineService;
    protected SequenceService sequenceService;
    protected StockConfigService stockConfigService;
    protected ProductRepository productRepo;
    protected InventoryRepository inventoryRepo;
    protected StockMoveRepository stockMoveRepo;
    protected StockLocationLineService stockLocationLineService;
    protected StockMoveService stockMoveService;
    protected StockMoveLineService stockMoveLineService;
    protected StockLocationLineRepository stockLocationLineRepository;
    protected TrackingNumberRepository trackingNumberRepository;
    protected AppBaseService appBaseService;

    @Inject
    public InventoryService(InventoryLineService inventoryLineService, SequenceService sequenceService, StockConfigService stockConfigService, ProductRepository productRepo, InventoryRepository inventoryRepo, StockMoveRepository stockMoveRepo, StockLocationLineService stockLocationLineService, StockMoveService stockMoveService, StockMoveLineService stockMoveLineService, StockLocationLineRepository stockLocationLineRepository, TrackingNumberRepository trackingNumberRepository, AppBaseService appBaseService) {
        this.inventoryLineService = inventoryLineService;
        this.sequenceService = sequenceService;
        this.stockConfigService = stockConfigService;
        this.productRepo = productRepo;
        this.inventoryRepo = inventoryRepo;
        this.stockMoveRepo = stockMoveRepo;
        this.stockLocationLineService = stockLocationLineService;
        this.stockMoveService = stockMoveService;
        this.stockMoveLineService = stockMoveLineService;
        this.stockLocationLineRepository = stockLocationLineRepository;
        this.trackingNumberRepository = trackingNumberRepository;
        this.appBaseService = appBaseService;
    }

    public Inventory createInventory(LocalDate plannedStartDate, LocalDate plannedEndDate, String description, StockLocation stockLocation, boolean excludeOutOfStock, boolean includeObsolete, ProductFamily productFamily, ProductCategory productCategory) throws AxelorException {
        if (stockLocation == null) {
            throw new AxelorException(4, I18n.get((String)"You must select a stock location"));
        }
        Inventory inventory = new Inventory();
        inventory.setInventorySeq(this.getInventorySequence(stockLocation.getCompany()));
        inventory.setPlannedStartDateT(plannedStartDate.atStartOfDay(ZoneOffset.UTC));
        inventory.setPlannedEndDateT(plannedEndDate.atStartOfDay(ZoneOffset.UTC));
        inventory.setDescription(description);
        inventory.setFormatSelect("pdf");
        inventory.setStockLocation(stockLocation);
        inventory.setExcludeOutOfStock(excludeOutOfStock);
        inventory.setIncludeObsolete(includeObsolete);
        inventory.setProductCategory(productCategory);
        inventory.setProductFamily(productFamily);
        inventory.setStatusSelect(1);
        return inventory;
    }

    public String getInventorySequence(Company company) throws AxelorException {
        String ref = this.sequenceService.getSequenceNumber("inventory", company);
        if (ref == null) {
            throw new AxelorException(4, I18n.get((String)"There's no configured sequence for inventory for company") + " " + company.getName());
        }
        return ref;
    }

    @Transactional(rollbackOn={Exception.class})
    public Path importFile(Inventory inventory) throws AxelorException {
        List<InventoryLine> inventoryLineList = inventory.getInventoryLineList();
        Path filePath = MetaFiles.getPath((MetaFile)inventory.getImportFile());
        List<String[]> data = this.getDatas(filePath);
        HashMap<String, InventoryLine> inventoryLineMap = this.getInventoryLines(inventory);
        for (String[] line : data) {
            BigDecimal currentQty;
            BigDecimal realQty;
            if (line.length < 6) {
                throw new AxelorException(new Throwable(I18n.get((String)"Line length too big")), (Model)((Object)inventory), 4, I18n.get((String)"An error occurred while importing the file data. Please contact your application administrator to check Traceback logs."));
            }
            String code = line[1].replace("\"", "");
            String rack = line[2].replace("\"", "");
            String trackingNumberSeq = line[3].replace("\"", "");
            try {
                realQty = new BigDecimal(line[5].replace("\"", ""));
            }
            catch (NumberFormatException e) {
                throw new AxelorException(new Throwable(I18n.get((String)"Real quantity problem")), (Model)((Object)inventory), 4, I18n.get((String)"An error occurred while importing the file data. Please contact your application administrator to check Traceback logs."));
            }
            String description = line[6].replace("\"", "");
            if (inventoryLineMap.containsKey(code)) {
                inventoryLineMap.get(code).setRealQty(realQty);
                inventoryLineMap.get(code).setDescription(description);
                continue;
            }
            try {
                currentQty = new BigDecimal(line[4].replace("\"", ""));
            }
            catch (NumberFormatException e) {
                throw new AxelorException(new Throwable(I18n.get((String)"Current quantity problem")), (Model)((Object)inventory), 4, I18n.get((String)"An error occurred while importing the file data. Please contact your application administrator to check Traceback logs."));
            }
            InventoryLine inventoryLine = new InventoryLine();
            List productList = this.productRepo.all().filter("self.code = :code").bind("code", (Object)code).fetch();
            if (productList != null && !productList.isEmpty() && productList.size() > 1) {
                throw new AxelorException((Model)((Object)inventory), 4, I18n.get((String)"An error occurred while importing the file data, there are multiple products with code :") + " " + code);
            }
            Product product = (Product)((Object)productList.get(0));
            if (product == null || !product.getProductTypeSelect().equals("storable")) {
                throw new AxelorException((Model)((Object)inventory), 4, I18n.get((String)"An error occurred while importing the file data, product not found with code :") + " " + code);
            }
            inventoryLine.setProduct(product);
            inventoryLine.setInventory(inventory);
            inventoryLine.setRack(rack);
            inventoryLine.setCurrentQty(currentQty);
            inventoryLine.setRealQty(realQty);
            inventoryLine.setDescription(description);
            inventoryLine.setTrackingNumber(this.getTrackingNumber(trackingNumberSeq));
            inventoryLineList.add(inventoryLine);
        }
        inventory.setInventoryLineList(inventoryLineList);
        this.inventoryRepo.save((Model)((Object)inventory));
        return filePath;
    }

    public List<String[]> getDatas(Path filePath) throws AxelorException {
        List data = null;
        char separator = ';';
        try {
            data = CsvTool.cSVFileReader((String)filePath.toString(), (char)separator);
        }
        catch (Exception e) {
            throw new AxelorException(e.getCause(), 4, I18n.get((String)"There is currently no such file in the specified folder or the folder may not exists."));
        }
        if (data == null || data.isEmpty()) {
            throw new AxelorException(new Throwable(I18n.get((String)"Data is null or empty")), 4, I18n.get((String)"An error occurred while importing the file data. Please contact your application administrator to check Traceback logs."));
        }
        data.remove(0);
        return data;
    }

    public HashMap<String, InventoryLine> getInventoryLines(Inventory inventory) {
        HashMap<String, InventoryLine> inventoryLineMap = new HashMap<String, InventoryLine>();
        for (InventoryLine line : inventory.getInventoryLineList()) {
            String key = "";
            if (line.getProduct() != null) {
                key = key + line.getProduct().getCode();
            }
            if (line.getTrackingNumber() != null) {
                key = key + line.getTrackingNumber().getTrackingNumberSeq();
            }
            inventoryLineMap.put(key, line);
        }
        return inventoryLineMap;
    }

    public TrackingNumber getTrackingNumber(String sequence) {
        if (sequence != null && !sequence.isEmpty()) {
            return this.trackingNumberRepository.findBySeq(sequence);
        }
        return null;
    }

    @Transactional(rollbackOn={Exception.class})
    public void validateInventory(Inventory inventory) throws AxelorException {
        inventory.setValidatedOn(this.appBaseService.getTodayDate());
        inventory.setStatusSelect(5);
        inventory.setValidatedBy(AuthUtils.getUser());
        this.generateStockMove(inventory, true);
        this.generateStockMove(inventory, false);
        this.storeLastInventoryData(inventory);
    }

    private void storeLastInventoryData(Inventory inventory) {
        List<StockLocationLine> list;
        List<StockLocationLine> stockLocationLineList;
        BigDecimal realQty;
        HashMap<Pair, BigDecimal> realQties = new HashMap<Pair, BigDecimal>();
        HashMap<Product, BigDecimal> consolidatedRealQties = new HashMap<Product, BigDecimal>();
        HashMap<Product, String> realRacks = new HashMap<Product, String>();
        List<InventoryLine> inventoryLineList = inventory.getInventoryLineList();
        if (inventoryLineList != null) {
            for (InventoryLine inventoryLine : inventoryLineList) {
                Product product = inventoryLine.getProduct();
                TrackingNumber trackingNumber = inventoryLine.getTrackingNumber();
                realQties.put(Pair.of((Object)((Object)product), (Object)((Object)trackingNumber)), inventoryLine.getRealQty());
                realQty = consolidatedRealQties.getOrDefault((Object)product, BigDecimal.ZERO);
                realQty = realQty.add(inventoryLine.getRealQty());
                consolidatedRealQties.put(product, realQty);
                realRacks.put(product, inventoryLine.getRack());
            }
        }
        if ((stockLocationLineList = inventory.getStockLocation().getStockLocationLineList()) != null) {
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                String rack;
                Product product = stockLocationLine.getProduct();
                realQty = (BigDecimal)consolidatedRealQties.get((Object)product);
                if (realQty != null) {
                    stockLocationLine.setLastInventoryRealQty(realQty);
                    stockLocationLine.setLastInventoryDateT(inventory.getValidatedOn().atStartOfDay().atZone(ZoneOffset.UTC));
                }
                if ((rack = (String)realRacks.get((Object)product)) == null) continue;
                stockLocationLine.setRack(rack);
            }
        }
        if ((list = inventory.getStockLocation().getDetailsStockLocationLineList()) != null) {
            for (StockLocationLine detailsStockLocationLine : list) {
                String rack;
                TrackingNumber trackingNumber;
                Product product = detailsStockLocationLine.getProduct();
                BigDecimal realQty2 = (BigDecimal)realQties.get(Pair.of((Object)((Object)product), (Object)((Object)(trackingNumber = detailsStockLocationLine.getTrackingNumber()))));
                if (realQty2 != null) {
                    detailsStockLocationLine.setLastInventoryRealQty(realQty2);
                    detailsStockLocationLine.setLastInventoryDateT(inventory.getValidatedOn().atStartOfDay().atZone(ZoneOffset.UTC));
                }
                if ((rack = (String)realRacks.get((Object)product)) == null) continue;
                detailsStockLocationLine.setRack(rack);
            }
        }
    }

    public StockMove generateStockMove(Inventory inventory, boolean isEnteringStock) throws AxelorException {
        StockLocation fromStockLocation;
        StockLocation toStockLocation;
        Company company = inventory.getCompany();
        if (isEnteringStock) {
            toStockLocation = inventory.getStockLocation();
            fromStockLocation = this.stockConfigService.getInventoryVirtualStockLocation(this.stockConfigService.getStockConfig(company));
        } else {
            toStockLocation = this.stockConfigService.getInventoryVirtualStockLocation(this.stockConfigService.getStockConfig(company));
            fromStockLocation = inventory.getStockLocation();
        }
        String inventorySeq = inventory.getInventorySeq();
        LocalDate inventoryDate = inventory.getPlannedStartDateT().toLocalDate();
        LocalDate realDate = inventory.getValidatedOn();
        StockMove stockMove = this.stockMoveService.createStockMove(null, null, company, fromStockLocation, toStockLocation, realDate, inventoryDate, null, 1);
        stockMove.setName(inventorySeq);
        stockMove.setOriginTypeSelect("com.axelor.apps.stock.db.Inventory");
        stockMove.setOriginId(inventory.getId());
        stockMove.setOrigin(inventorySeq);
        for (InventoryLine inventoryLine : inventory.getInventoryLineList()) {
            this.generateStockMoveLines(inventoryLine, stockMove, isEnteringStock);
        }
        if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
            this.stockMoveService.plan(stockMove);
            this.stockMoveService.copyQtyToRealQty(stockMove);
            this.stockMoveService.realize(stockMove, false);
        }
        return stockMove;
    }

    protected void generateStockMoveLines(InventoryLine inventoryLine, StockMove stockMove, boolean isEnteringStock) throws AxelorException {
        Product product = inventoryLine.getProduct();
        TrackingNumber trackingNumber = inventoryLine.getTrackingNumber();
        BigDecimal diff = inventoryLine.getRealQty().subtract(inventoryLine.getCurrentQty());
        if (!isEnteringStock) {
            diff = diff.negate();
        }
        if (diff.signum() > 0) {
            StockLocationLine stockLocationLine = this.stockLocationLineService.getStockLocationLine(stockMove.getToStockLocation(), product);
            BigDecimal avgPrice = stockLocationLine != null ? stockLocationLine.getAvgPrice() : BigDecimal.ZERO;
            StockMoveLine stockMoveLine = this.stockMoveLineService.createStockMoveLine(product, product.getName(), product.getDescription(), diff, avgPrice, avgPrice, product.getUnit(), stockMove, 0, false, BigDecimal.ZERO);
            if (stockMoveLine == null) {
                throw new AxelorException((Model)((Object)inventoryLine.getInventory()), 4, I18n.get((String)"Incorrect product in inventory line") + " " + inventoryLine.getInventory().getInventorySeq());
            }
            if (trackingNumber != null && stockMoveLine.getTrackingNumber() == null) {
                stockMoveLine.setTrackingNumber(trackingNumber);
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancel(Inventory inventory) throws AxelorException {
        List stockMoveList = this.stockMoveRepo.all().filter("self.originTypeSelect = :originTypeSelect AND self.originId = :originId").bind("originTypeSelect", (Object)"com.axelor.apps.stock.db.Inventory").bind("originId", (Object)inventory.getId()).fetch();
        for (StockMove stockMove : stockMoveList) {
            this.stockMoveService.cancel(stockMove);
        }
        inventory.setStatusSelect(6);
    }

    @Transactional(rollbackOn={Exception.class})
    public Boolean fillInventoryLineList(Inventory inventory) throws AxelorException {
        if (inventory.getStockLocation() == null) {
            throw new AxelorException((Model)((Object)inventory), 4, I18n.get((String)"You must select a stock location"));
        }
        this.initInventoryLines(inventory);
        List<? extends StockLocationLine> stockLocationLineList = this.getStockLocationLines(inventory);
        if (stockLocationLineList != null) {
            Boolean succeed = false;
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                long numberOfTrackingNumberOnAProduct;
                if (stockLocationLine.getTrackingNumber() == null && (numberOfTrackingNumberOnAProduct = this.stockLocationLineRepository.all().filter("self.product = ?1 AND self.trackingNumber IS NOT null AND self.detailsStockLocation = ?2", new Object[]{stockLocationLine.getProduct(), inventory.getStockLocation()}).count()) != 0L) continue;
                inventory.addInventoryLineListItem(this.createInventoryLine(inventory, stockLocationLine));
                succeed = true;
            }
            this.inventoryRepo.save((Model)((Object)inventory));
            return succeed;
        }
        return null;
    }

    public List<? extends StockLocationLine> getStockLocationLines(Inventory inventory) {
        String query = "(self.stockLocation = ? OR self.detailsStockLocation = ?)";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add((Object)inventory.getStockLocation());
        params.add((Object)inventory.getStockLocation());
        if (inventory.getExcludeOutOfStock().booleanValue()) {
            query = query + " and self.currentQty > 0";
        }
        if (!inventory.getIncludeObsolete().booleanValue()) {
            query = query + " and (self.product.endDate > ? or self.product.endDate is null)";
            params.add(inventory.getPlannedEndDateT().toLocalDate());
        }
        if (inventory.getProductFamily() != null) {
            query = query + " and self.product.productFamily = ?";
            params.add(inventory.getProductFamily());
        }
        if (inventory.getProductCategory() != null) {
            query = query + " and self.product.productCategory = ?";
            params.add(inventory.getProductCategory());
        }
        if (inventory.getProduct() != null) {
            query = query + " and self.product = ?";
            params.add((Object)inventory.getProduct());
        }
        if (!Strings.isNullOrEmpty((String)inventory.getFromRack())) {
            query = query + " and self.rack >= ?";
            params.add(inventory.getFromRack());
        }
        if (!Strings.isNullOrEmpty((String)inventory.getToRack())) {
            query = query + " and self.rack <= ?";
            params.add(inventory.getToRack());
        }
        return this.stockLocationLineRepository.all().filter(query, params.toArray()).fetch();
    }

    public InventoryLine createInventoryLine(Inventory inventory, StockLocationLine stockLocationLine) {
        return this.inventoryLineService.createInventoryLine(inventory, stockLocationLine.getProduct(), stockLocationLine.getCurrentQty(), stockLocationLine.getRack(), stockLocationLine.getTrackingNumber());
    }

    public void initInventoryLines(Inventory inventory) {
        if (inventory.getInventoryLineList() == null) {
            inventory.setInventoryLineList(new ArrayList<InventoryLine>());
        } else {
            inventory.getInventoryLineList().clear();
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public MetaFile exportInventoryAsCSV(Inventory inventory) throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (InventoryLine inventoryLine : inventory.getInventoryLineList()) {
            String[] item = new String[9];
            String realQty = "";
            item[0] = inventoryLine.getProduct() == null ? "" : inventoryLine.getProduct().getName();
            String string = item[1] = inventoryLine.getProduct() == null ? "" : inventoryLine.getProduct().getCode();
            item[2] = inventoryLine.getProduct() == null ? "" : (inventoryLine.getProduct().getProductCategory() == null ? "" : inventoryLine.getProduct().getProductCategory().getName());
            item[3] = inventoryLine.getRack() == null ? "" : inventoryLine.getRack();
            item[4] = inventoryLine.getTrackingNumber() == null ? "" : inventoryLine.getTrackingNumber().getTrackingNumberSeq();
            item[5] = inventoryLine.getCurrentQty().toString();
            if (inventoryLine.getRealQty() != null && inventory.getStatusSelect() != 1 && inventory.getStatusSelect() != 2) {
                realQty = inventoryLine.getRealQty().toString();
            }
            item[6] = realQty;
            item[7] = inventoryLine.getDescription() == null ? "" : inventoryLine.getDescription();
            String lastInventoryDateTString = "";
            StockLocationLine stockLocationLine = this.stockLocationLineService.getStockLocationLine(inventory.getStockLocation(), inventoryLine.getProduct());
            if (stockLocationLine != null) {
                ZonedDateTime lastInventoryDateT = stockLocationLine.getLastInventoryDateT();
                lastInventoryDateTString = lastInventoryDateT == null ? "" : lastInventoryDateT.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            }
            item[8] = lastInventoryDateTString;
            list.add(item);
        }
        Collections.sort(list, new Comparator<String[]>(){

            @Override
            public int compare(String[] strings, String[] otherStrings) {
                return strings[1].compareTo(otherStrings[1]);
            }
        });
        String fileName = I18n.get((String)"Inventory") + "_" + inventory.getInventorySeq() + ".csv";
        String filePath = AppSettings.get().get("file.upload.dir");
        Path path = Paths.get(filePath, fileName);
        File file = path.toFile();
        this.log.debug("File Located at: {}", (Object)path);
        String[] headers = new String[]{I18n.get((String)"Product Name"), I18n.get((String)"Product Code"), I18n.get((String)"Product category"), I18n.get((String)"Rack"), I18n.get((String)"Tracking Number"), I18n.get((String)"Current Quantity"), I18n.get((String)"Real Quantity"), I18n.get((String)"Description"), I18n.get((String)"Last Inventory date")};
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', (char)'\"', (String[])headers, list);
        try (FileInputStream is = new FileInputStream(file);){
            MetaFile metaFile = ((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)is, fileName);
            return metaFile;
        }
    }

    public List<StockMove> findStockMoves(Inventory inventory) {
        return this.stockMoveRepo.all().filter("self.originTypeSelect = ?1 AND self.originId = ?2", new Object[]{"com.axelor.apps.stock.db.Inventory", inventory.getId()}).fetch();
    }

    public String computeTitle(Inventory entity) {
        return entity.getStockLocation().getName() + (!Strings.isNullOrEmpty((String)entity.getDescription()) ? "-" + StringUtils.abbreviate((String)entity.getDescription(), (int)10) : "");
    }
}

