/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.exception.LogisticalFormError;
import com.axelor.apps.stock.exception.LogisticalFormWarning;
import com.axelor.exception.AxelorException;
import com.axelor.meta.CallMethod;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface LogisticalFormService {
    public void addDetailLines(LogisticalForm var1, StockMove var2) throws AxelorException;

    public void addParcelPalletLine(LogisticalForm var1, int var2);

    public void computeTotals(LogisticalForm var1) throws LogisticalFormError;

    public void checkLines(LogisticalForm var1) throws LogisticalFormWarning, LogisticalFormError;

    public List<StockMoveLine> getFullySpreadStockMoveLineList(LogisticalForm var1);

    public Map<StockMoveLine, BigDecimal> getSpreadableQtyMap(LogisticalForm var1);

    public Map<StockMoveLine, BigDecimal> getSpreadQtyMap(LogisticalForm var1);

    public String getStockMoveDomain(LogisticalForm var1) throws AxelorException;

    public int getNextParcelPalletNumber(LogisticalForm var1, int var2);

    public int getNextLineSequence(LogisticalForm var1);

    public void sortLines(LogisticalForm var1);

    @CallMethod
    public List<Long> getIdList(StockMove var1) throws AxelorException;

    public void processCollected(LogisticalForm var1) throws AxelorException;

    public Optional<String> getCustomerAccountNumberToCarrier(LogisticalForm var1) throws AxelorException;

    public void updateProductNetMass(LogisticalForm var1) throws AxelorException;
}

