/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.stock.db.FreightCarrierCustomerAccountNumber;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.LogisticalFormLine;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.LogisticalFormLineRepository;
import com.axelor.apps.stock.exception.LogisticalFormError;
import com.axelor.apps.stock.exception.LogisticalFormWarning;
import com.axelor.apps.stock.service.LogisticalFormLineService;
import com.axelor.apps.stock.service.LogisticalFormService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.apps.tool.QueryBuilder;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.Context;
import com.axelor.rpc.ContextEntity;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.ScriptHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;

public class LogisticalFormServiceImpl
implements LogisticalFormService {
    @Inject
    ProductRepository productRepository;

    @Override
    public void addDetailLines(LogisticalForm logisticalForm, StockMove stockMove) throws AxelorException {
        Objects.requireNonNull(logisticalForm);
        Objects.requireNonNull(stockMove);
        if (logisticalForm.getDeliverToCustomerPartner() != null && !logisticalForm.getDeliverToCustomerPartner().equals((Object)stockMove.getPartner())) {
            throw new AxelorException((Model)((Object)logisticalForm), 5, I18n.get((String)"Partner mismatch: %s"), new Object[]{logisticalForm.getDeliverToCustomerPartner().getName()});
        }
        if (stockMove.getStockMoveLineList() == null) {
            return;
        }
        StockMoveLineService stockMoveLineService = (StockMoveLineService)Beans.get(StockMoveLineService.class);
        ArrayList<Pair> toAddList = new ArrayList<Pair>();
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            BigDecimal spreadableQty = stockMoveLineService.computeSpreadableQtyOverLogisticalFormLines(stockMoveLine, logisticalForm);
            if (spreadableQty.signum() <= 0 || !this.testForDetailLine(stockMoveLine)) continue;
            toAddList.add(Pair.of((Object)((Object)stockMoveLine), (Object)spreadableQty));
        }
        if (!toAddList.isEmpty()) {
            if (logisticalForm.getLogisticalFormLineList() == null || logisticalForm.getLogisticalFormLineList().isEmpty()) {
                this.addParcelPalletLine(logisticalForm, LogisticalFormLineRepository.TYPE_PARCEL);
            }
            toAddList.forEach(item -> this.addDetailLine(logisticalForm, (StockMoveLine)((Object)((Object)item.getLeft())), (BigDecimal)item.getRight()));
        }
    }

    protected boolean testForDetailLine(StockMoveLine stockMoveLine) {
        return true;
    }

    @Override
    public void checkLines(LogisticalForm logisticalForm) throws LogisticalFormWarning, LogisticalFormError {
        ArrayList<String> warningMessageList = new ArrayList<String>();
        this.checkRequiredLineFields(logisticalForm);
        this.checkInvalidLineDimensions(logisticalForm);
        this.checkEmptyParcelPalletLines(logisticalForm, warningMessageList);
        this.checkInconsistentQties(logisticalForm, warningMessageList);
        if (!warningMessageList.isEmpty()) {
            String errorMessage = String.format("<ul>%s</ul>", warningMessageList.stream().map(message -> String.format("<li>%s</li>", message)).collect(Collectors.joining("\n")));
            throw new LogisticalFormWarning(logisticalForm, errorMessage);
        }
    }

    protected void checkRequiredLineFields(LogisticalForm logisticalForm) throws LogisticalFormError {
        if (logisticalForm.getLogisticalFormLineList() == null) {
            return;
        }
        for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
            if (logisticalFormLine.getTypeSelect() == 0) {
                throw new LogisticalFormError(logisticalFormLine, I18n.get((String)"Type is required on line %d."), logisticalFormLine.getSequence() + 1);
            }
            if (logisticalFormLine.getTypeSelect() != LogisticalFormLineRepository.TYPE_DETAIL) continue;
            if (logisticalFormLine.getStockMoveLine() == null) {
                throw new LogisticalFormError(logisticalFormLine, I18n.get((String)"Stock move line is required on line %d."), logisticalFormLine.getSequence() + 1);
            }
            if (logisticalFormLine.getQty() != null && logisticalFormLine.getQty().signum() > 0) continue;
            throw new LogisticalFormError(logisticalFormLine, I18n.get((String)"Quantity is required on line %d."), logisticalFormLine.getSequence() + 1);
        }
    }

    protected void checkInconsistentQties(LogisticalForm logisticalForm, List<String> errorMessageList) {
        Map<StockMoveLine, BigDecimal> spreadableQtyMap = this.getSpreadableQtyMap(logisticalForm);
        Map<StockMoveLine, BigDecimal> spreadQtyMap = this.getSpreadQtyMap(logisticalForm);
        Locale locale = new Locale(((UserService)Beans.get(UserService.class)).getLanguage());
        NumberFormat nf = NumberFormat.getInstance(locale);
        for (Map.Entry<StockMoveLine, BigDecimal> entry : spreadableQtyMap.entrySet()) {
            StockMoveLine stockMoveLine = entry.getKey();
            BigDecimal spreadableQty = entry.getValue();
            if (spreadableQty.signum() == 0) continue;
            BigDecimal spreadQty = spreadQtyMap.getOrDefault((Object)stockMoveLine, BigDecimal.ZERO);
            BigDecimal expectedQty = spreadQty.add(spreadableQty);
            String errorMessage = String.format(locale, I18n.get((String)"Total quantity for %s: %s (expected: %s)"), String.format("%s (%s)", stockMoveLine.getProductName(), stockMoveLine.getStockMove().getStockMoveSeq()), nf.format(spreadQty), nf.format(expectedQty));
            errorMessageList.add(errorMessage);
        }
    }

    protected void checkEmptyParcelPalletLines(LogisticalForm logisticalForm, List<String> errorMessageList) throws LogisticalFormError {
        if (logisticalForm.getLogisticalFormLineList() == null) {
            return;
        }
        HashMap<LogisticalFormLine, BigDecimal> qtyMap = new HashMap<LogisticalFormLine, BigDecimal>();
        LogisticalFormLine currentLine = null;
        for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
            if (logisticalFormLine.getTypeSelect() != LogisticalFormLineRepository.TYPE_DETAIL) {
                currentLine = logisticalFormLine;
                qtyMap.put(currentLine, BigDecimal.ZERO);
                continue;
            }
            if (currentLine == null) {
                throw new LogisticalFormError(logisticalForm, I18n.get((String)"Detail line(s) not inside a parcel/pallet"));
            }
            qtyMap.merge(currentLine, logisticalFormLine.getQty(), BigDecimal::add);
        }
        for (Map.Entry entry : qtyMap.entrySet()) {
            LogisticalFormLine logisticalFormLine = (LogisticalFormLine)((Object)entry.getKey());
            BigDecimal qty = (BigDecimal)entry.getValue();
            if (qty.signum() > 0) continue;
            String msg = logisticalFormLine.getTypeSelect() == LogisticalFormLineRepository.TYPE_PARCEL ? I18n.get((String)"Parcel %d is empty.") : I18n.get((String)"Pallet %d is empty.");
            String errorMessage = String.format(msg, logisticalFormLine.getParcelPalletNumber());
            errorMessageList.add(errorMessage);
        }
    }

    protected void checkInvalidLineDimensions(LogisticalForm logisticalForm) throws LogisticalFormError {
        if (logisticalForm.getLogisticalFormLineList() != null) {
            LogisticalFormLineService logisticalFormLineService = (LogisticalFormLineService)Beans.get(LogisticalFormLineService.class);
            for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
                logisticalFormLineService.validateDimensions(logisticalFormLine);
            }
        }
    }

    @Override
    public List<StockMoveLine> getFullySpreadStockMoveLineList(LogisticalForm logisticalForm) {
        ArrayList<StockMoveLine> stockMoveLineList = new ArrayList<StockMoveLine>();
        HashMap<StockMoveLine, BigDecimal> spreadableQtyMap = new HashMap<StockMoveLine, BigDecimal>();
        for (LogisticalForm logisticalForm2 : this.findPendingLogisticalForms(logisticalForm)) {
            spreadableQtyMap.putAll(this.getSpreadableQtyMap(logisticalForm2));
        }
        for (Map.Entry entry : spreadableQtyMap.entrySet()) {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)entry.getKey());
            BigDecimal spreadableQty = (BigDecimal)entry.getValue();
            if (spreadableQty.signum() > 0) continue;
            stockMoveLineList.add(stockMoveLine);
        }
        return stockMoveLineList;
    }

    private List<LogisticalForm> findPendingLogisticalForms(LogisticalForm logisticalForm) {
        Preconditions.checkNotNull((Object)((Object)logisticalForm));
        Preconditions.checkNotNull((Object)((Object)logisticalForm.getDeliverToCustomerPartner()));
        QueryBuilder queryBuilder = QueryBuilder.of(LogisticalForm.class);
        queryBuilder.add("self.deliverToCustomerPartner = :deliverToCustomerPartner");
        queryBuilder.bind("deliverToCustomerPartner", (Object)logisticalForm.getDeliverToCustomerPartner());
        queryBuilder.add("self.statusSelect < :statusSelect");
        queryBuilder.bind("statusSelect", (Object)3);
        if (logisticalForm.getId() != null) {
            queryBuilder.add("self.id != :id");
            queryBuilder.bind("id", (Object)logisticalForm.getId());
        }
        List logisticalFormList = queryBuilder.build().fetch();
        logisticalFormList.add(logisticalForm);
        return logisticalFormList;
    }

    protected List<StockMove> getFullySpreadStockMoveList(LogisticalForm logisticalForm) {
        ArrayList<StockMove> fullySpreadStockMoveList = new ArrayList<StockMove>();
        List<StockMoveLine> fullySpreadStockMoveLineList = this.getFullySpreadStockMoveLineList(logisticalForm);
        HashSet<StockMove> stockMoveSet = new HashSet<StockMove>();
        for (StockMoveLine stockMoveLine : fullySpreadStockMoveLineList) {
            stockMoveSet.add(stockMoveLine.getStockMove());
        }
        for (StockMove stockMove : stockMoveSet) {
            if (!fullySpreadStockMoveLineList.containsAll(stockMove.getStockMoveLineList())) continue;
            fullySpreadStockMoveList.add(stockMove);
        }
        return fullySpreadStockMoveList;
    }

    @Override
    public Map<StockMoveLine, BigDecimal> getSpreadableQtyMap(LogisticalForm logisticalForm) {
        LinkedHashSet stockMoveSet = new LinkedHashSet();
        LinkedHashMap<StockMoveLine, BigDecimal> spreadableQtyMap = new LinkedHashMap<StockMoveLine, BigDecimal>();
        if (logisticalForm.getLogisticalFormLineList() != null) {
            StockMoveLineService stockMoveLineService = (StockMoveLineService)Beans.get(StockMoveLineService.class);
            logisticalForm.getLogisticalFormLineList().stream().filter(logisticalFormLine -> logisticalFormLine.getTypeSelect() == LogisticalFormLineRepository.TYPE_DETAIL && logisticalFormLine.getStockMoveLine() != null && logisticalFormLine.getStockMoveLine().getStockMove() != null).forEach(logisticalFormLine -> stockMoveSet.add(logisticalFormLine.getStockMoveLine().getStockMove()));
            for (StockMove stockMove : stockMoveSet) {
                if (stockMove.getStockMoveLineList() == null) continue;
                for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                    BigDecimal spreadableQty = stockMoveLineService.computeSpreadableQtyOverLogisticalFormLines(stockMoveLine, logisticalForm);
                    spreadableQtyMap.put(stockMoveLine, spreadableQty);
                }
            }
        }
        return spreadableQtyMap;
    }

    @Override
    public Map<StockMoveLine, BigDecimal> getSpreadQtyMap(LogisticalForm logisticalForm) {
        LinkedHashMap<StockMoveLine, BigDecimal> spreadQtyMap = new LinkedHashMap<StockMoveLine, BigDecimal>();
        if (logisticalForm.getLogisticalFormLineList() != null) {
            logisticalForm.getLogisticalFormLineList().stream().filter(logisticalFormLine -> logisticalFormLine.getTypeSelect() == LogisticalFormLineRepository.TYPE_DETAIL).forEach(logisticalFormLine -> {
                StockMoveLine stockMoveLine = logisticalFormLine.getStockMoveLine();
                if (stockMoveLine != null && logisticalFormLine.getQty() != null) {
                    spreadQtyMap.merge(stockMoveLine, logisticalFormLine.getQty(), BigDecimal::add);
                }
            });
        }
        return spreadQtyMap;
    }

    protected void addDetailLine(LogisticalForm logisticalForm, StockMoveLine stockMoveLine, BigDecimal qty) {
        Preconditions.checkNotNull((Object)((Object)logisticalForm));
        Preconditions.checkNotNull((Object)((Object)stockMoveLine));
        LogisticalFormLine logisticalFormLine = this.createLogisticalFormLine(logisticalForm, stockMoveLine, qty);
        this.addLogisticalFormLineListItem(logisticalForm, logisticalFormLine);
    }

    @Override
    public void addParcelPalletLine(LogisticalForm logisticalForm, int typeSelect) {
        LogisticalFormLine logisticalFormLine = new LogisticalFormLine();
        logisticalFormLine.setTypeSelect(typeSelect);
        logisticalFormLine.setParcelPalletNumber(this.getNextParcelPalletNumber(logisticalForm, typeSelect));
        logisticalFormLine.setSequence(this.getNextLineSequence(logisticalForm));
        this.addLogisticalFormLineListItem(logisticalForm, logisticalFormLine);
    }

    protected void addLogisticalFormLineListItem(LogisticalForm logisticalForm, LogisticalFormLine logisticalFormLine) {
        if (logisticalForm instanceof ContextEntity) {
            List<LogisticalFormLine> logisticalFormLineList = logisticalForm.getLogisticalFormLineList();
            if (logisticalFormLineList == null) {
                logisticalFormLineList = new ArrayList<LogisticalFormLine>();
                logisticalForm.setLogisticalFormLineList(logisticalFormLineList);
            }
            logisticalFormLineList.add(logisticalFormLine);
        } else {
            logisticalForm.addLogisticalFormLineListItem(logisticalFormLine);
        }
    }

    @Override
    public int getNextParcelPalletNumber(LogisticalForm logisticalForm, int typeSelect) {
        int highest = 0;
        HashSet<Integer> parcelPalletNumberSet = new HashSet<Integer>();
        if (logisticalForm.getLogisticalFormLineList() != null) {
            for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
                if (logisticalFormLine.getTypeSelect() != typeSelect || logisticalFormLine.getParcelPalletNumber() == null) continue;
                parcelPalletNumberSet.add(logisticalFormLine.getParcelPalletNumber());
                if (logisticalFormLine.getParcelPalletNumber() <= highest) continue;
                highest = logisticalFormLine.getParcelPalletNumber();
            }
        }
        for (int i = 1; i < highest; ++i) {
            if (parcelPalletNumberSet.contains(i)) continue;
            return i;
        }
        return highest + 1;
    }

    @Override
    public int getNextLineSequence(LogisticalForm logisticalForm) {
        if (logisticalForm.getLogisticalFormLineList() == null) {
            return 0;
        }
        OptionalInt max = logisticalForm.getLogisticalFormLineList().stream().mapToInt(LogisticalFormLine::getSequence).max();
        return max.isPresent() ? max.getAsInt() + 1 : 0;
    }

    @Override
    public void computeTotals(LogisticalForm logisticalForm) throws LogisticalFormError {
        BigDecimal totalNetMass = BigDecimal.ZERO;
        BigDecimal totalGrossMass = BigDecimal.ZERO;
        BigDecimal totalVolume = BigDecimal.ZERO;
        if (logisticalForm.getLogisticalFormLineList() != null) {
            ScriptHelper scriptHelper = this.getScriptHelper(logisticalForm);
            LogisticalFormLineService logisticalFormLineService = (LogisticalFormLineService)Beans.get(LogisticalFormLineService.class);
            for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
                StockMoveLine stockMoveLine = logisticalFormLine.getStockMoveLine();
                if (logisticalFormLine.getTypeSelect() != LogisticalFormLineRepository.TYPE_DETAIL) {
                    if (logisticalFormLine.getGrossMass() != null) {
                        totalGrossMass = totalGrossMass.add(logisticalFormLine.getGrossMass());
                    }
                    totalVolume = totalVolume.add(logisticalFormLineService.evalVolume(logisticalFormLine, scriptHelper));
                    continue;
                }
                if (stockMoveLine == null) continue;
                totalNetMass = totalNetMass.add(logisticalFormLine.getQty().multiply(stockMoveLine.getNetMass()));
            }
            totalVolume = totalVolume.divide(new BigDecimal(1000000), 10, RoundingMode.HALF_UP);
            logisticalForm.setTotalNetMass(totalNetMass.setScale(3, RoundingMode.HALF_EVEN));
            logisticalForm.setTotalGrossMass(totalGrossMass.setScale(3, RoundingMode.HALF_EVEN));
            logisticalForm.setTotalVolume(totalVolume.setScale(3, RoundingMode.HALF_EVEN));
        }
    }

    protected ScriptHelper getScriptHelper(LogisticalForm logisticalForm) {
        Context scriptContext = new Context(Mapper.toMap((Object)((Object)logisticalForm)), ((Object)((Object)logisticalForm)).getClass());
        return new GroovyScriptHelper(scriptContext);
    }

    @Override
    public String getStockMoveDomain(LogisticalForm logisticalForm) throws AxelorException {
        List<StockMove> fullySpreadStockMoveList;
        if (logisticalForm.getDeliverToCustomerPartner() == null) {
            return "self IS NULL";
        }
        ArrayList<String> domainList = new ArrayList<String>();
        domainList.add("self.partner = :deliverToCustomerPartner");
        domainList.add(String.format("self.typeSelect = %d", 2));
        domainList.add(String.format("self.statusSelect in (%d, %d)", 2, 3));
        domainList.add("COALESCE(self.fullySpreadOverLogisticalFormsFlag, FALSE) = FALSE");
        if (logisticalForm.getStockLocation() != null) {
            domainList.add("self.fromStockLocation = :stockLocation");
        }
        if (!(fullySpreadStockMoveList = this.getFullySpreadStockMoveList(logisticalForm)).isEmpty()) {
            String idListString = StringTool.getIdListString(fullySpreadStockMoveList);
            domainList.add(String.format("self.id NOT IN (%s)", idListString));
        }
        return domainList.stream().map(domain -> String.format("(%s)", domain)).collect(Collectors.joining(" AND "));
    }

    @Override
    public void sortLines(LogisticalForm logisticalForm) {
        if (logisticalForm.getLogisticalFormLineList() != null) {
            logisticalForm.getLogisticalFormLineList().sort(Comparator.comparing(LogisticalFormLine::getSequence));
        }
    }

    @Override
    public List<Long> getIdList(StockMove stockMove) throws AxelorException {
        if (stockMove.getId() == null) {
            throw new AxelorException(StockMove.class, 3, I18n.get((String)"Unsaved record"));
        }
        TypedQuery query = JPA.em().createQuery("SELECT DISTINCT self FROM LogisticalForm self JOIN self.logisticalFormLineList logisticalFormLine WHERE logisticalFormLine.stockMoveLine.stockMove.id = :stockMoveId", LogisticalForm.class);
        query.setParameter("stockMoveId", (Object)stockMove.getId());
        List resultList = query.getResultList();
        return resultList.isEmpty() ? Lists.newArrayList((Object[])new Long[]{0L}) : resultList.stream().map(LogisticalForm::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void processCollected(LogisticalForm logisticalForm) throws AxelorException {
        if (logisticalForm.getLogisticalFormLineList() == null) {
            return;
        }
        HashSet stockMoveSet = new HashSet();
        logisticalForm.getLogisticalFormLineList().stream().filter(logisticalFormLine -> logisticalFormLine.getTypeSelect() == LogisticalFormLineRepository.TYPE_DETAIL && logisticalFormLine.getStockMoveLine() != null && logisticalFormLine.getStockMoveLine().getStockMove() != null).forEach(logisticalFormLine -> stockMoveSet.add(logisticalFormLine.getStockMoveLine().getStockMove()));
        StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
        stockMoveSet.forEach(stockMoveService::updateFullySpreadOverLogisticalFormsFlag);
        StockConfigService stockConfigService = (StockConfigService)Beans.get(StockConfigService.class);
        StockConfig stockConfig = stockConfigService.getStockConfig(logisticalForm.getCompany());
        if (stockConfig.getRealizeStockMovesUponParcelPalletCollection().booleanValue()) {
            for (StockMove stockMove : stockMoveSet) {
                if (!stockMove.getFullySpreadOverLogisticalFormsFlag().booleanValue()) continue;
                stockMoveService.realize(stockMove);
            }
        }
        logisticalForm.setStatusSelect(3);
    }

    @Override
    public Optional<String> getCustomerAccountNumberToCarrier(LogisticalForm logisticalForm) throws AxelorException {
        Optional<FreightCarrierCustomerAccountNumber> freightCarrierCustomerAccountNumber;
        Preconditions.checkNotNull((Object)((Object)logisticalForm));
        List<FreightCarrierCustomerAccountNumber> freightCarrierCustomerAccountNumberList = null;
        switch (logisticalForm.getAccountSelectionToCarrierSelect()) {
            case 1: {
                if (logisticalForm.getCompany() == null || logisticalForm.getCompany().getStockConfig() == null) break;
                freightCarrierCustomerAccountNumberList = logisticalForm.getCompany().getStockConfig().getFreightCarrierCustomerAccountNumberList();
                break;
            }
            case 2: {
                if (logisticalForm.getDeliverToCustomerPartner() == null) break;
                freightCarrierCustomerAccountNumberList = logisticalForm.getDeliverToCustomerPartner().getFreightCarrierCustomerAccountNumberList();
                break;
            }
            default: {
                throw new AxelorException((Model)((Object)logisticalForm), 4, I18n.get((String)"Unknown account selection"));
            }
        }
        if (freightCarrierCustomerAccountNumberList != null && (freightCarrierCustomerAccountNumber = freightCarrierCustomerAccountNumberList.stream().filter(it -> it.getCarrierPartner().equals((Object)logisticalForm.getCarrierPartner())).findFirst()).isPresent()) {
            return Optional.ofNullable(freightCarrierCustomerAccountNumber.get().getCustomerAccountNumber());
        }
        return Optional.empty();
    }

    protected LogisticalFormLine createLogisticalFormLine(LogisticalForm logisticalForm, StockMoveLine stockMoveLine, BigDecimal qty) {
        LogisticalFormLine logisticalFormLine = new LogisticalFormLine();
        logisticalFormLine.setTypeSelect(LogisticalFormLineRepository.TYPE_DETAIL);
        logisticalFormLine.setStockMoveLine(stockMoveLine);
        logisticalFormLine.setQty(qty);
        logisticalFormLine.setSequence(this.getNextLineSequence(logisticalForm));
        logisticalFormLine.setUnitNetMass(stockMoveLine.getNetMass());
        return logisticalFormLine;
    }

    @Override
    public void updateProductNetMass(LogisticalForm logisticalForm) {
        BigDecimal totalNetMass = BigDecimal.ZERO;
        if (logisticalForm.getLogisticalFormLineList() != null) {
            for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
                if (logisticalFormLine.getStockMoveLine() == null || logisticalFormLine.getStockMoveLine().getProduct() == null || !logisticalFormLine.getTypeSelect().equals(LogisticalFormLineRepository.TYPE_DETAIL)) continue;
                Product product = (Product)((Object)this.productRepository.find(logisticalFormLine.getStockMoveLine().getProduct().getId()));
                logisticalFormLine.setUnitNetMass(product.getNetMass());
                totalNetMass = totalNetMass.add(logisticalFormLine.getQty().multiply(product.getNetMass()));
            }
            logisticalForm.setTotalNetMass(totalNetMass);
        }
    }
}

