/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.stock.db.PartnerProductQualityRating;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.PartnerProductQualityRatingRepository;
import com.axelor.apps.stock.service.PartnerProductQualityRatingService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;

public class PartnerProductQualityRatingServiceImpl
implements PartnerProductQualityRatingService {
    public static final BigDecimal MAX_QUALITY_RATING = new BigDecimal(5);
    private PartnerProductQualityRatingRepository partnerProductQualityRatingRepo;

    @Inject
    public PartnerProductQualityRatingServiceImpl(PartnerProductQualityRatingRepository partnerProductQualityRatingRepo) {
        this.partnerProductQualityRatingRepo = partnerProductQualityRatingRepo;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void calculate(StockMove stockMove) throws AxelorException {
        Partner partner = stockMove.getPartner();
        if (partner == null || !partner.getIsSupplier().booleanValue()) {
            return;
        }
        List<StockMoveLine> stockMoveLines = stockMove.getStockMoveLineList();
        if (stockMoveLines != null) {
            for (StockMoveLine stockMoveLine : stockMoveLines) {
                Product product = stockMoveLine.getProduct();
                PartnerProductQualityRating partnerProductQualityRating = this.searchPartnerProductQualityRating(partner, product).orElseGet(() -> this.createPartnerProductQualityRating(partner, product));
                this.updatePartnerProductQualityRating(partnerProductQualityRating, stockMoveLine);
            }
        }
        this.updateSupplier(partner);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void undoCalculation(StockMove stockMove) throws AxelorException {
        Partner partner = stockMove.getPartner();
        if (partner == null || !partner.getIsSupplier().booleanValue()) {
            return;
        }
        List<StockMoveLine> stockMoveLines = stockMove.getStockMoveLineList();
        if (stockMoveLines != null) {
            for (StockMoveLine stockMoveLine : stockMoveLines) {
                Product product = stockMoveLine.getProduct();
                Optional<PartnerProductQualityRating> optional = this.searchPartnerProductQualityRating(partner, product);
                if (!optional.isPresent()) continue;
                PartnerProductQualityRating partnerProductQualityRating = optional.get();
                this.updatePartnerProductQualityRating(partnerProductQualityRating, stockMoveLine, true);
            }
        }
        this.updateSupplier(partner);
    }

    private Optional<PartnerProductQualityRating> searchPartnerProductQualityRating(Partner partner, Product product) {
        List<PartnerProductQualityRating> partnerProductQualityRatingList = partner.getPartnerProductQualityRatingList();
        if (partnerProductQualityRatingList == null) {
            return Optional.empty();
        }
        Optional<PartnerProductQualityRating> productQualityRating = partnerProductQualityRatingList.stream().filter(PartnerProductQualityRating2 -> PartnerProductQualityRating2.getProduct() != null && PartnerProductQualityRating2.getProduct().equals((Object)product)).findFirst();
        if (productQualityRating == null) {
            productQualityRating = Optional.empty();
        }
        return productQualityRating;
    }

    @Transactional
    protected PartnerProductQualityRating createPartnerProductQualityRating(Partner partner, Product product) {
        PartnerProductQualityRating partnerProductQualityRating = new PartnerProductQualityRating(product);
        partner.addPartnerProductQualityRatingListItem(partnerProductQualityRating);
        this.partnerProductQualityRatingRepo.persist((Model)((Object)partnerProductQualityRating));
        return partnerProductQualityRating;
    }

    private void updatePartnerProductQualityRating(PartnerProductQualityRating partnerProductQualityRating, StockMoveLine stockMoveLine) {
        this.updatePartnerProductQualityRating(partnerProductQualityRating, stockMoveLine, false);
    }

    private void updatePartnerProductQualityRating(PartnerProductQualityRating partnerProductQualityRating, StockMoveLine stockMoveLine, boolean undo) {
        BigDecimal qty = !undo ? stockMoveLine.getRealQty() : stockMoveLine.getRealQty().negate();
        BigDecimal compliantArrivalProductQty = partnerProductQualityRating.getCompliantArrivalProductQty();
        if (stockMoveLine.getConformitySelect() == 2) {
            compliantArrivalProductQty = compliantArrivalProductQty.add(qty);
            partnerProductQualityRating.setCompliantArrivalProductQty(compliantArrivalProductQty);
        }
        BigDecimal arrivalProductQty = partnerProductQualityRating.getArrivalProductQty().add(qty);
        partnerProductQualityRating.setArrivalProductQty(arrivalProductQty);
        if (arrivalProductQty.signum() > 0) {
            BigDecimal qualityRating = this.computeQualityRating(compliantArrivalProductQty, arrivalProductQty);
            partnerProductQualityRating.setQualityRating(qualityRating);
            partnerProductQualityRating.setQualityRatingSelect(this.computeQualityRatingSelect(qualityRating));
        } else {
            partnerProductQualityRating.getPartner().removePartnerProductQualityRatingListItem(partnerProductQualityRating);
        }
    }

    private void updateSupplier(Partner partner) {
        BigDecimal supplierQualityRating = BigDecimal.ZERO;
        BigDecimal supplierArrivalProductQty = BigDecimal.ZERO;
        List<PartnerProductQualityRating> partnerProductQualityRatingList = partner.getPartnerProductQualityRatingList();
        if (partnerProductQualityRatingList != null) {
            for (PartnerProductQualityRating partnerProductQualityRating : partnerProductQualityRatingList) {
                BigDecimal qualityRating = partnerProductQualityRating.getQualityRating();
                BigDecimal arrivalProductQty = partnerProductQualityRating.getArrivalProductQty();
                supplierQualityRating = supplierQualityRating.add(qualityRating.multiply(arrivalProductQty));
                supplierArrivalProductQty = supplierArrivalProductQty.add(arrivalProductQty);
            }
            supplierQualityRating = supplierArrivalProductQty.signum() > 0 ? supplierQualityRating.divide(supplierArrivalProductQty, 2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        }
        partner.setSupplierQualityRating(supplierQualityRating);
        partner.setSupplierQualityRatingSelect(this.computeQualityRatingSelect(supplierQualityRating));
        partner.setSupplierArrivalProductQty(supplierArrivalProductQty);
    }

    private BigDecimal computeQualityRating(BigDecimal compliantArrivalProductQty, BigDecimal arrivalProductQty) {
        return compliantArrivalProductQty.multiply(MAX_QUALITY_RATING).divide(arrivalProductQty, 2, RoundingMode.HALF_UP);
    }

    private BigDecimal computeQualityRatingSelect(BigDecimal qualityRating) {
        BigDecimal two = new BigDecimal(2);
        return qualityRating.multiply(two).setScale(0, RoundingMode.HALF_UP).divide(two, 2, RoundingMode.HALF_UP);
    }
}

