/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.PartnerStockSettings;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.PartnerStockSettingsRepository;
import com.axelor.apps.stock.service.PartnerStockSettingsService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.util.List;
import java.util.Optional;

public class PartnerStockSettingsServiceImpl
implements PartnerStockSettingsService {
    @Override
    public PartnerStockSettings getOrCreateMailSettings(Partner partner, Company company) throws AxelorException {
        List<PartnerStockSettings> mailSettingsList = partner.getPartnerStockSettingsList();
        if (mailSettingsList == null || mailSettingsList.isEmpty()) {
            return this.createMailSettings(partner, company);
        }
        Optional<PartnerStockSettings> partnerStockSettings = mailSettingsList.stream().filter(stockSettings -> company.equals((Object)stockSettings.getCompany())).findAny();
        return partnerStockSettings.isPresent() ? partnerStockSettings.get() : this.createMailSettings(partner, company);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public PartnerStockSettings createMailSettings(Partner partner, Company company) throws AxelorException {
        PartnerStockSettings mailSettings = new PartnerStockSettings();
        mailSettings.setCompany(company);
        StockConfig stockConfig = ((StockConfigService)Beans.get(StockConfigService.class)).getStockConfig(company);
        mailSettings.setPlannedStockMoveAutomaticMail(stockConfig.getPlannedStockMoveAutomaticMail());
        mailSettings.setPlannedStockMoveMessageTemplate(stockConfig.getPlannedStockMoveMessageTemplate());
        mailSettings.setRealStockMoveAutomaticMail(stockConfig.getRealStockMoveAutomaticMail());
        mailSettings.setRealStockMoveMessageTemplate(stockConfig.getRealStockMoveMessageTemplate());
        partner.addPartnerStockSettingsListItem(mailSettings);
        return (PartnerStockSettings)((Object)((PartnerStockSettingsRepository)((Object)Beans.get(PartnerStockSettingsRepository.class))).save((Model)((Object)mailSettings)));
    }

    @Override
    public StockLocation getDefaultStockLocation(Partner partner, Company company) {
        PartnerStockSettings partnerStockSettings;
        if (partner != null && company != null && (partnerStockSettings = (PartnerStockSettings)((Object)((PartnerStockSettingsRepository)((Object)Beans.get(PartnerStockSettingsRepository.class))).all().filter("self.partner = ? AND self.company = ?", new Object[]{partner, company}).fetchOne())) != null) {
            return partnerStockSettings.getDefaultStockLocation();
        }
        return null;
    }
}

