/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.stock.db.StockHistoryLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.service.StockHistoryService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class StockHistoryServiceImpl
implements StockHistoryService {
    protected StockMoveLineRepository stockMoveLineRepository;
    protected UnitConversionService unitConversionService;

    @Inject
    public StockHistoryServiceImpl(StockMoveLineRepository stockMoveLineRepository, UnitConversionService unitConversionService) {
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.unitConversionService = unitConversionService;
    }

    @Override
    public List<StockHistoryLine> computeStockHistoryLineList(Long productId, Long companyId, Long stockLocationId, LocalDate beginDate, LocalDate endDate) throws AxelorException {
        ArrayList<StockHistoryLine> stockHistoryLineList = new ArrayList<StockHistoryLine>();
        LocalDate periodBeginDate = beginDate.withDayOfMonth(1);
        while (periodBeginDate.isBefore(endDate)) {
            LocalDate periodEndDate = periodBeginDate.plusMonths(1L);
            StockHistoryLine stockHistoryLine = new StockHistoryLine();
            stockHistoryLine.setLabel(periodBeginDate.toString());
            this.fetchAndFillResultForStockHistoryQuery(stockHistoryLine, productId, companyId, stockLocationId, periodBeginDate, periodEndDate, true);
            this.fetchAndFillResultForStockHistoryQuery(stockHistoryLine, productId, companyId, stockLocationId, periodBeginDate, periodEndDate, false);
            stockHistoryLineList.add(stockHistoryLine);
            periodBeginDate = periodBeginDate.plusMonths(1L);
        }
        StockHistoryLine totalStockHistoryLine = this.createStockHistoryTotalLine(stockHistoryLineList);
        StockHistoryLine avgStockHistoryLine = this.createStockHistoryAvgLine(stockHistoryLineList, totalStockHistoryLine);
        stockHistoryLineList.add(totalStockHistoryLine);
        stockHistoryLineList.add(avgStockHistoryLine);
        return stockHistoryLineList;
    }

    protected void fetchAndFillResultForStockHistoryQuery(StockHistoryLine stockHistoryLine, Long productId, Long companyId, Long stockLocationId, LocalDate periodBeginDate, LocalDate periodEndDate, boolean incoming) throws AxelorException {
        String filter = "self.product.id = :productId AND self.stockMove.statusSelect = :realized AND self.stockMove.company.id = :companyId AND self.stockMove.realDate >= :beginDate AND self.stockMove.realDate < :endDate ";
        filter = incoming ? filter + "AND self.stockMove.toStockLocation.id = :stockLocationId " : filter + "AND self.stockMove.fromStockLocation.id = :stockLocationId ";
        List stockMoveLineList = this.stockMoveLineRepository.all().filter(filter).bind("productId", (Object)productId).bind("companyId", (Object)companyId).bind("stockLocationId", (Object)stockLocationId).bind("realized", (Object)3).bind("beginDate", (Object)periodBeginDate).bind("endDate", (Object)periodEndDate).fetch();
        if (incoming) {
            this.fillIncomingStockHistoryLineFields(stockHistoryLine, stockMoveLineList);
        } else {
            this.fillOutgoingStockHistoryLineFields(stockHistoryLine, stockMoveLineList);
        }
        JPA.clear();
    }

    protected void fillIncomingStockHistoryLineFields(StockHistoryLine stockHistoryLine, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        stockHistoryLine.setCountIncMvtStockPeriod(Math.toIntExact(stockMoveLineList.stream().map(StockMoveLine::getStockMove).distinct().count()));
        BigDecimal sumIncQtyPeriod = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            BigDecimal qtyConverted = this.unitConversionService.convert(stockMoveLine.getUnit(), stockMoveLine.getProduct().getUnit(), stockMoveLine.getRealQty(), stockMoveLine.getRealQty().scale(), stockMoveLine.getProduct());
            sumIncQtyPeriod = sumIncQtyPeriod.add(qtyConverted);
        }
        stockHistoryLine.setSumIncQtyPeriod(sumIncQtyPeriod);
        stockHistoryLine.setPriceIncStockMovePeriod(stockMoveLineList.stream().map(StockMoveLine::getCompanyUnitPriceUntaxed).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    protected void fillOutgoingStockHistoryLineFields(StockHistoryLine stockHistoryLine, List<StockMoveLine> stockMoveLineList) throws AxelorException {
        stockHistoryLine.setCountOutMvtStockPeriod(Math.toIntExact(stockMoveLineList.stream().map(StockMoveLine::getStockMove).distinct().count()));
        BigDecimal sumOutQtyPeriod = BigDecimal.ZERO;
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            BigDecimal qtyConverted = this.unitConversionService.convert(stockMoveLine.getUnit(), stockMoveLine.getProduct().getUnit(), stockMoveLine.getRealQty(), stockMoveLine.getRealQty().scale(), stockMoveLine.getProduct());
            sumOutQtyPeriod = sumOutQtyPeriod.add(qtyConverted);
        }
        stockHistoryLine.setSumOutQtyPeriod(sumOutQtyPeriod);
        stockHistoryLine.setPriceOutStockMovePeriod(stockMoveLineList.stream().map(StockMoveLine::getCompanyUnitPriceUntaxed).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
    }

    protected StockHistoryLine createStockHistoryTotalLine(List<StockHistoryLine> stockHistoryLineList) {
        StockHistoryLine stockHistoryLine = new StockHistoryLine();
        stockHistoryLine.setLabel(I18n.get((String)"Total"));
        Integer countIncMvtStock = stockHistoryLineList.stream().map(StockHistoryLine::getCountIncMvtStockPeriod).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        stockHistoryLine.setCountIncMvtStockPeriod(countIncMvtStock);
        BigDecimal sumIncQtyPeriod = stockHistoryLineList.stream().map(StockHistoryLine::getSumIncQtyPeriod).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        stockHistoryLine.setSumIncQtyPeriod(sumIncQtyPeriod);
        BigDecimal priceIncStockMove = stockHistoryLineList.stream().map(StockHistoryLine::getPriceIncStockMovePeriod).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        stockHistoryLine.setPriceIncStockMovePeriod(priceIncStockMove);
        Integer countOutMvtStock = stockHistoryLineList.stream().map(StockHistoryLine::getCountOutMvtStockPeriod).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        stockHistoryLine.setCountOutMvtStockPeriod(countOutMvtStock);
        BigDecimal sumOutQtyPeriod = stockHistoryLineList.stream().map(StockHistoryLine::getSumOutQtyPeriod).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        stockHistoryLine.setSumOutQtyPeriod(sumOutQtyPeriod);
        BigDecimal priceOutStockMove = stockHistoryLineList.stream().map(StockHistoryLine::getPriceOutStockMovePeriod).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        stockHistoryLine.setPriceOutStockMovePeriod(priceOutStockMove);
        return stockHistoryLine;
    }

    protected StockHistoryLine createStockHistoryAvgLine(List<StockHistoryLine> stockHistoryLineList, StockHistoryLine totalStockHistoryLine) {
        StockHistoryLine stockHistoryLine = new StockHistoryLine();
        stockHistoryLine.setLabel(I18n.get((String)"Average"));
        int sizeOfList = stockHistoryLineList.size();
        if (sizeOfList == 0) {
            return stockHistoryLine;
        }
        stockHistoryLine.setCountIncMvtStockPeriod(totalStockHistoryLine.getCountIncMvtStockPeriod() / sizeOfList);
        stockHistoryLine.setSumIncQtyPeriod(totalStockHistoryLine.getSumIncQtyPeriod().divide(BigDecimal.valueOf(sizeOfList), 2, RoundingMode.HALF_EVEN));
        stockHistoryLine.setPriceIncStockMovePeriod(totalStockHistoryLine.getPriceIncStockMovePeriod().divide(BigDecimal.valueOf(sizeOfList), 2, RoundingMode.HALF_EVEN));
        stockHistoryLine.setCountOutMvtStockPeriod(totalStockHistoryLine.getCountOutMvtStockPeriod() / sizeOfList);
        stockHistoryLine.setSumOutQtyPeriod(totalStockHistoryLine.getSumOutQtyPeriod().divide(BigDecimal.valueOf(sizeOfList), 2, RoundingMode.HALF_EVEN));
        stockHistoryLine.setPriceOutStockMovePeriod(totalStockHistoryLine.getPriceOutStockMovePeriod().divide(BigDecimal.valueOf(sizeOfList), 2, RoundingMode.HALF_EVEN));
        return stockHistoryLine;
    }
}

