/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public interface StockLocationLineService {
    @Transactional(rollbackOn={Exception.class})
    public void updateLocation(StockLocation var1, Product var2, Unit var3, BigDecimal var4, boolean var5, boolean var6, boolean var7, LocalDate var8, TrackingNumber var9) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void updateLocation(StockLocation var1, Product var2, Unit var3, BigDecimal var4, boolean var5, boolean var6, boolean var7, LocalDate var8) throws AxelorException;

    public void minStockRules(Product var1, BigDecimal var2, StockLocationLine var3, boolean var4, boolean var5) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void updateDetailLocation(StockLocation var1, Product var2, Unit var3, BigDecimal var4, boolean var5, boolean var6, boolean var7, LocalDate var8, TrackingNumber var9) throws AxelorException;

    public void checkStockMin(StockLocationLine var1, boolean var2) throws AxelorException;

    public void checkIfEnoughStock(StockLocation var1, Product var2, BigDecimal var3) throws AxelorException;

    public StockLocationLine updateLocation(StockLocationLine var1, Unit var2, Product var3, BigDecimal var4, boolean var5, boolean var6, boolean var7, LocalDate var8) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void updateStockLocationFromProduct(StockLocationLine var1, Product var2) throws AxelorException;

    public StockLocationLine updateLocationFromProduct(StockLocationLine var1, Product var2) throws AxelorException;

    public StockLocationLine getOrCreateStockLocationLine(StockLocation var1, Product var2);

    public StockLocationLine getOrCreateDetailLocationLine(StockLocation var1, Product var2, TrackingNumber var3);

    public StockLocationLine getStockLocationLine(StockLocation var1, Product var2);

    public List<StockLocationLine> getStockLocationLines(Product var1);

    public StockLocationLine getDetailLocationLine(StockLocation var1, Product var2, TrackingNumber var3);

    public StockLocationLine createLocationLine(StockLocation var1, Product var2);

    public StockLocationLine createDetailLocationLine(StockLocation var1, Product var2, TrackingNumber var3);

    public BigDecimal getAvailableQty(StockLocation var1, Product var2);

    public BigDecimal getTrackingNumberAvailableQty(StockLocation var1, TrackingNumber var2);

    public BigDecimal computeFutureQty(StockLocationLine var1) throws AxelorException;

    public String getStockLocationLineListForAProduct(Long var1, Long var2, Long var3);

    public String getAvailableStockForAProduct(Long var1, Long var2, Long var3);

    public String getRequestedReservedQtyForAProduct(Long var1, Long var2, Long var3);

    public void updateWap(StockLocationLine var1, BigDecimal var2);

    public void updateWap(StockLocationLine var1, BigDecimal var2, StockMoveLine var3);
}

