/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.db.repo.StockRulesRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.rpc.filter.Filter;
import com.axelor.rpc.filter.JPQLFilter;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Query;

@RequestScoped
public class StockLocationServiceImpl
implements StockLocationService {
    protected StockLocationRepository stockLocationRepo;
    protected StockLocationLineService stockLocationLineService;
    protected ProductRepository productRepo;
    protected Set<Long> locationIdSet = new HashSet<Long>();

    @Inject
    public StockLocationServiceImpl(StockLocationRepository stockLocationRepo, StockLocationLineService stockLocationLineService, ProductRepository productRepo) {
        this.stockLocationRepo = stockLocationRepo;
        this.stockLocationLineService = stockLocationLineService;
        this.productRepo = productRepo;
    }

    @Override
    public StockLocation getDefaultReceiptStockLocation(Company company) {
        try {
            StockConfigService stockConfigService = (StockConfigService)Beans.get(StockConfigService.class);
            StockConfig stockConfig = stockConfigService.getStockConfig(company);
            return stockConfigService.getReceiptDefaultStockLocation(stockConfig);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public StockLocation getPickupDefaultStockLocation(Company company) {
        try {
            StockConfigService stockConfigService = (StockConfigService)Beans.get(StockConfigService.class);
            StockConfig stockConfig = stockConfigService.getStockConfig(company);
            return stockConfigService.getPickupDefaultStockLocation(stockConfig);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected List<StockLocation> getNonVirtualStockLocations(Long companyId) {
        ArrayList queryFilter = Lists.newArrayList((Object[])new Filter[]{new JPQLFilter("self.typeSelect != :stockLocationTypSelect", new Object[0])});
        if (companyId != null && companyId != 0L) {
            queryFilter.add(new JPQLFilter("self.company.id = :companyId ", new Object[0]));
        }
        return Filter.and((List)queryFilter).build(StockLocation.class).bind("stockLocationTypSelect", (Object)3).bind("companyId", (Object)companyId).fetch();
    }

    @Override
    public BigDecimal getQty(Long productId, Long locationId, Long companyId, String qtyType) throws AxelorException {
        if (productId != null) {
            Product product = (Product)((Object)this.productRepo.find(productId));
            Unit productUnit = product.getUnit();
            UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
            if (locationId == null || locationId == 0L) {
                List<StockLocation> stockLocations = this.getNonVirtualStockLocations(companyId);
                if (!stockLocations.isEmpty()) {
                    BigDecimal qty = BigDecimal.ZERO;
                    for (StockLocation stockLocation : stockLocations) {
                        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine((StockLocation)((Object)this.stockLocationRepo.find(stockLocation.getId())), (Product)((Object)this.productRepo.find(productId)));
                        if (stockLocationLine == null) continue;
                        Unit stockLocationLineUnit = stockLocationLine.getUnit();
                        qty = qty.add(qtyType.equals("real") ? stockLocationLine.getCurrentQty() : stockLocationLine.getFutureQty());
                        if (productUnit == null || productUnit.equals((Object)stockLocationLineUnit)) continue;
                        qty = unitConversionService.convert(stockLocationLineUnit, productUnit, qty, qty.scale(), product);
                    }
                    return qty;
                }
            } else {
                StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine((StockLocation)((Object)this.stockLocationRepo.find(locationId)), (Product)((Object)this.productRepo.find(productId)));
                if (stockLocationLine != null) {
                    Unit stockLocationLineUnit = stockLocationLine.getUnit();
                    BigDecimal qty = BigDecimal.ZERO;
                    BigDecimal bigDecimal = qty = qtyType.equals("real") ? stockLocationLine.getCurrentQty() : stockLocationLine.getFutureQty();
                    if (productUnit != null && !productUnit.equals((Object)stockLocationLineUnit)) {
                        qty = unitConversionService.convert(stockLocationLineUnit, productUnit, qty, qty.scale(), product);
                    }
                    return qty;
                }
            }
        }
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getRealQty(Long productId, Long locationId, Long companyId) throws AxelorException {
        return this.getQty(productId, locationId, companyId, "real");
    }

    @Override
    public BigDecimal getFutureQty(Long productId, Long locationId, Long companyId) throws AxelorException {
        return this.getQty(productId, locationId, companyId, "future");
    }

    @Override
    public List<Long> getBadStockLocationLineId() {
        List stockLocationLineList = ((StockLocationLineRepository)((Object)Beans.get(StockLocationLineRepository.class))).all().filter("self.stockLocation.typeSelect = 1 OR self.stockLocation.typeSelect = 2").fetch();
        ArrayList<Long> idList = new ArrayList<Long>();
        StockRulesRepository stockRulesRepository = (StockRulesRepository)((Object)Beans.get(StockRulesRepository.class));
        for (StockLocationLine stockLocationLine : stockLocationLineList) {
            StockRules stockRules = (StockRules)((Object)stockRulesRepository.all().filter("self.stockLocation = ?1 AND self.product = ?2", new Object[]{stockLocationLine.getStockLocation(), stockLocationLine.getProduct()}).fetchOne());
            if (stockRules == null || stockLocationLine.getFutureQty().compareTo(stockRules.getMinQty()) >= 0) continue;
            idList.add(stockLocationLine.getId());
        }
        if (idList.isEmpty()) {
            idList.add(0L);
        }
        return idList;
    }

    @Override
    public Set<Long> getContentStockLocationIds(StockLocation stockLocation) {
        this.locationIdSet = new HashSet<Long>();
        if (stockLocation != null) {
            List<StockLocation> stockLocations = this.getAllLocationAndSubLocation(stockLocation, true);
            for (StockLocation item : stockLocations) {
                this.locationIdSet.add(item.getId());
            }
        } else {
            this.locationIdSet.add(0L);
        }
        return this.locationIdSet;
    }

    @Override
    public List<StockLocation> getAllLocationAndSubLocation(StockLocation stockLocation, boolean isVirtualInclude) {
        ArrayList<StockLocation> resultList = new ArrayList<StockLocation>();
        if (stockLocation == null) {
            return resultList;
        }
        if (isVirtualInclude) {
            for (StockLocation subLocation : this.stockLocationRepo.all().filter("self.parentStockLocation.id = :stockLocationId").bind("stockLocationId", (Object)stockLocation.getId()).fetch()) {
                resultList.addAll(this.getAllLocationAndSubLocation(subLocation, isVirtualInclude));
            }
        } else {
            for (StockLocation subLocation : this.stockLocationRepo.all().filter("self.parentStockLocation.id = :stockLocationId AND self.typeSelect != :virtual").bind("stockLocationId", (Object)stockLocation.getId()).bind("virtual", (Object)3).fetch()) {
                resultList.addAll(this.getAllLocationAndSubLocation(subLocation, isVirtualInclude));
            }
        }
        resultList.add(stockLocation);
        return resultList;
    }

    @Override
    public BigDecimal getStockLocationValue(StockLocation stockLocation) {
        Query query = JPA.em().createQuery("SELECT SUM( self.currentQty * CASE WHEN (location.company.stockConfig.stockValuationTypeSelect = 1) THEN (self.avgPrice)  WHEN (location.company.stockConfig.stockValuationTypeSelect = 2) THEN CASE WHEN (self.product.costTypeSelect = 3) THEN (self.avgPrice) ELSE (self.product.costPrice) END WHEN (location.company.stockConfig.stockValuationTypeSelect = 3) THEN (self.product.salePrice) ELSE (self.avgPrice) END ) AS value FROM StockLocationLine AS self LEFT JOIN StockLocation AS location ON location.id= self.stockLocation WHERE self.stockLocation.id =:id");
        query.setParameter("id", (Object)stockLocation.getId());
        List result = query.getResultList();
        return result.get(0) == null || ((BigDecimal)result.get(0)).signum() == 0 ? BigDecimal.ZERO : ((BigDecimal)result.get(0)).setScale(2, 6);
    }

    @Override
    public List<Long> getAllLocationAndSubLocationId(StockLocation stockLocation, boolean isVirtualInclude) {
        List<StockLocation> stockLocationList = this.getAllLocationAndSubLocation(stockLocation, isVirtualInclude);
        List stockLocationListId = null;
        if (stockLocationList != null) {
            stockLocationListId = stockLocationList.stream().map(StockLocation::getId).collect(Collectors.toList());
        }
        return stockLocationListId;
    }

    @Override
    public boolean isConfigMissing(StockLocation stockLocation, int printType) {
        StockConfig stockConfig = stockLocation.getCompany().getStockConfig();
        return printType == 1 && (stockConfig == null || stockConfig.getIsDisplayAccountingValueInPrinting() == false && stockConfig.getIsDisplayAgPriceInPrinting() == false && stockConfig.getIsDisplaySaleValueInPrinting() == false);
    }
}

