/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.CustomsCodeNomenclature;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.LogisticalFormLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.TrackingNumberConfiguration;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.TrackingNumberRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.apps.stock.service.TrackingNumberService;
import com.axelor.apps.stock.service.WeightedAveragePriceService;
import com.axelor.apps.stock.service.app.AppStockService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.google.inject.servlet.RequestScoped;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class StockMoveLineServiceImpl
implements StockMoveLineService {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppBaseService appBaseService;
    protected AppStockService appStockService;
    protected StockMoveToolService stockMoveToolService;
    protected StockMoveLineRepository stockMoveLineRepository;
    protected StockLocationLineService stockLocationLineService;
    protected UnitConversionService unitConversionService;
    protected TrackingNumberService trackingNumberService;
    protected WeightedAveragePriceService weightedAveragePriceService;
    protected TrackingNumberRepository trackingNumberRepo;

    @Inject
    public StockMoveLineServiceImpl(TrackingNumberService trackingNumberService, AppBaseService appBaseService, AppStockService appStockService, StockMoveToolService stockMoveToolService, StockMoveLineRepository stockMoveLineRepository, StockLocationLineService stockLocationLineService, UnitConversionService unitConversionService, WeightedAveragePriceService weightedAveragePriceService, TrackingNumberRepository trackingNumberRepo) {
        this.trackingNumberService = trackingNumberService;
        this.appBaseService = appBaseService;
        this.appStockService = appStockService;
        this.stockMoveToolService = stockMoveToolService;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.stockLocationLineService = stockLocationLineService;
        this.unitConversionService = unitConversionService;
        this.weightedAveragePriceService = weightedAveragePriceService;
        this.trackingNumberRepo = trackingNumberRepo;
    }

    @Override
    public StockMoveLine createStockMoveLine(Product product, String productName, String description, BigDecimal quantity, BigDecimal unitPrice, BigDecimal companyUnitPriceUntaxed, Unit unit, StockMove stockMove, int type, boolean taxed, BigDecimal taxRate) throws AxelorException {
        if (product != null) {
            StockMoveLine stockMoveLine = this.generateStockMoveLineConvertingUnitPrice(product, productName, description, quantity, unitPrice, companyUnitPriceUntaxed, unit, stockMove, taxed, taxRate);
            TrackingNumberConfiguration trackingNumberConfiguration = product.getTrackingNumberConfiguration();
            return this.assignOrGenerateTrackingNumber(stockMoveLine, stockMove, product, trackingNumberConfiguration, type);
        }
        return this.createStockMoveLine(product, productName, description, quantity, BigDecimal.ZERO, BigDecimal.ZERO, companyUnitPriceUntaxed, unit, stockMove, null);
    }

    protected StockMoveLine generateStockMoveLineConvertingUnitPrice(Product product, String productName, String description, BigDecimal quantity, BigDecimal unitPrice, BigDecimal companyUnitPriceUntaxed, Unit unit, StockMove stockMove, boolean taxed, BigDecimal taxRate) throws AxelorException {
        BigDecimal unitPriceUntaxed;
        BigDecimal unitPriceTaxed;
        if (taxed) {
            unitPriceTaxed = unitPrice.setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
            unitPriceUntaxed = unitPrice.divide(taxRate.add(BigDecimal.ONE), this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
        } else {
            unitPriceUntaxed = unitPrice.setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
            unitPriceTaxed = unitPrice.multiply(taxRate.add(BigDecimal.ONE)).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
        }
        return this.createStockMoveLine(product, productName, description, quantity, unitPriceUntaxed, unitPriceTaxed, companyUnitPriceUntaxed, unit, stockMove, null);
    }

    @Override
    public StockMoveLine assignOrGenerateTrackingNumber(StockMoveLine stockMoveLine, StockMove stockMove, Product product, TrackingNumberConfiguration trackingNumberConfiguration, int type) throws AxelorException {
        if (trackingNumberConfiguration != null) {
            switch (type) {
                case 1: {
                    if (!trackingNumberConfiguration.getIsSaleTrackingManaged().booleanValue()) break;
                    if (trackingNumberConfiguration.getGenerateSaleAutoTrackingNbr().booleanValue()) {
                        this.generateTrackingNumber(stockMoveLine, trackingNumberConfiguration, product, trackingNumberConfiguration.getSaleQtyByTracking());
                        break;
                    }
                    this.assignTrackingNumber(stockMoveLine, product, stockMove.getFromStockLocation());
                    break;
                }
                case 2: {
                    if (!trackingNumberConfiguration.getIsPurchaseTrackingManaged().booleanValue() || !trackingNumberConfiguration.getGeneratePurchaseAutoTrackingNbr().booleanValue()) break;
                    this.generateTrackingNumber(stockMoveLine, trackingNumberConfiguration, product, trackingNumberConfiguration.getPurchaseQtyByTracking());
                    break;
                }
                case 3: {
                    if (!trackingNumberConfiguration.getIsProductionTrackingManaged().booleanValue() || !trackingNumberConfiguration.getGenerateProductionAutoTrackingNbr().booleanValue()) break;
                    this.generateTrackingNumber(stockMoveLine, trackingNumberConfiguration, product, trackingNumberConfiguration.getProductionQtyByTracking());
                    break;
                }
                case 4: {
                    if (!trackingNumberConfiguration.getHasProductAutoSelectTrackingNbr().booleanValue()) break;
                    this.assignTrackingNumber(stockMoveLine, product, stockMove.getFromStockLocation());
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        return stockMoveLine;
    }

    @Override
    public void generateTrackingNumber(StockMoveLine stockMoveLine, TrackingNumberConfiguration trackingNumberConfiguration, Product product, BigDecimal qtyByTracking) throws AxelorException {
        int generateTrakingNumberCounter = 0;
        StockMove stockMove = stockMoveLine.getStockMove();
        if (qtyByTracking.compareTo(BigDecimal.ZERO) <= 0) {
            throw new AxelorException(4, I18n.get((String)"The tracking number configuration quantity is equal to zero, it must be at least one."));
        }
        while (stockMoveLine.getQty().compareTo(qtyByTracking) > 0) {
            BigDecimal minQty = stockMoveLine.getQty().min(qtyByTracking);
            this.splitStockMoveLine(stockMoveLine, minQty, this.trackingNumberService.getTrackingNumber(product, qtyByTracking, stockMove.getCompany(), stockMove.getEstimatedDate()));
            if (++generateTrakingNumberCounter != 1000) continue;
            throw new AxelorException(0, I18n.get((String)"Too many iterations while trying to generate stock move line with tracking numbers."));
        }
        if (stockMoveLine.getTrackingNumber() == null) {
            stockMoveLine.setTrackingNumber(this.trackingNumberService.getTrackingNumber(product, qtyByTracking, stockMove.getCompany(), stockMove.getEstimatedDate()));
        }
    }

    @Override
    public StockMoveLine createStockMoveLine(Product product, String productName, String description, BigDecimal quantity, BigDecimal unitPriceUntaxed, BigDecimal unitPriceTaxed, BigDecimal companyUnitPriceUntaxed, Unit unit, StockMove stockMove, TrackingNumber trackingNumber) throws AxelorException {
        StockMoveLine stockMoveLine = new StockMoveLine();
        stockMoveLine.setProduct(product);
        stockMoveLine.setProductName(productName);
        stockMoveLine.setDescription(description);
        stockMoveLine.setQty(quantity);
        stockMoveLine.setRealQty(quantity);
        stockMoveLine.setUnitPriceUntaxed(unitPriceUntaxed);
        stockMoveLine.setUnitPriceTaxed(unitPriceTaxed);
        stockMoveLine.setUnit(unit);
        stockMoveLine.setTrackingNumber(trackingNumber);
        stockMoveLine.setCompanyUnitPriceUntaxed(companyUnitPriceUntaxed);
        if (stockMove != null) {
            stockMove.addStockMoveLineListItem(stockMoveLine);
            stockMoveLine.setNetMass(this.computeNetMass(stockMove, stockMoveLine, stockMove.getCompany()));
            stockMoveLine.setSequence(stockMove.getStockMoveLineList().size());
        } else {
            stockMoveLine.setNetMass(this.computeNetMass(stockMove, stockMoveLine, null));
        }
        stockMoveLine.setTotalNetMass(stockMoveLine.getRealQty().multiply(stockMoveLine.getNetMass()).setScale(2, RoundingMode.HALF_EVEN));
        if (product != null) {
            stockMoveLine.setCountryOfOrigin(product.getCountryOfOrigin());
            stockMoveLine.setProductTypeSelect(product.getProductTypeSelect());
        }
        return stockMoveLine;
    }

    @Override
    public void assignTrackingNumber(StockMoveLine stockMoveLine, Product product, StockLocation stockLocation) throws AxelorException {
        List<? extends StockLocationLine> stockLocationLineList = this.getStockLocationLines(product, stockLocation);
        if (stockLocationLineList != null) {
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                BigDecimal qty = stockLocationLine.getFutureQty();
                if (stockMoveLine.getQty().compareTo(qty) > 0) {
                    this.splitStockMoveLine(stockMoveLine, qty, stockLocationLine.getTrackingNumber());
                    continue;
                }
                stockMoveLine.setTrackingNumber(stockLocationLine.getTrackingNumber());
                break;
            }
        }
    }

    @Override
    public List<? extends StockLocationLine> getStockLocationLines(Product product, StockLocation stockLocation) throws AxelorException {
        List stockLocationLineList = ((StockLocationLineRepository)((Object)Beans.get(StockLocationLineRepository.class))).all().filter("self.product = ?1 AND self.futureQty > 0 AND self.trackingNumber IS NOT NULL AND self.detailsStockLocation = ?2" + this.trackingNumberService.getOrderMethod(product.getTrackingNumberConfiguration()), new Object[]{product, stockLocation}).fetch();
        return stockLocationLineList;
    }

    @Override
    public StockMoveLine splitStockMoveLine(StockMoveLine stockMoveLine, BigDecimal qty, TrackingNumber trackingNumber) throws AxelorException {
        StockMoveLine newStockMoveLine = this.createStockMoveLine(stockMoveLine.getProduct(), stockMoveLine.getProductName(), stockMoveLine.getDescription(), qty, stockMoveLine.getUnitPriceUntaxed(), stockMoveLine.getUnitPriceTaxed(), stockMoveLine.getCompanyUnitPriceUntaxed(), stockMoveLine.getUnit(), stockMoveLine.getStockMove(), trackingNumber);
        stockMoveLine.setQty(stockMoveLine.getQty().subtract(qty));
        stockMoveLine.setRealQty(stockMoveLine.getRealQty().subtract(qty));
        return newStockMoveLine;
    }

    @Override
    public void updateLocations(StockLocation fromStockLocation, StockLocation toStockLocation, int fromStatus, int toStatus, List<StockMoveLine> stockMoveLineList, LocalDate lastFutureStockMoveDate, boolean realQty) throws AxelorException {
        stockMoveLineList = (List)MoreObjects.firstNonNull(stockMoveLineList, Collections.emptyList());
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            Product product = stockMoveLine.getProduct();
            if (product == null || stockMoveLine.getLineTypeSelect() == 2 || !product.getProductTypeSelect().equals("storable")) continue;
            BigDecimal qty = realQty ? stockMoveLine.getRealQty() : stockMoveLine.getQty();
            this.updateLocations(stockMoveLine, fromStockLocation, toStockLocation, stockMoveLine.getProduct(), qty, fromStatus, toStatus, lastFutureStockMoveDate, stockMoveLine.getTrackingNumber());
            if (toStockLocation.getTypeSelect() != 3) {
                this.updateAveragePriceLocationLine(toStockLocation, stockMoveLine, fromStatus, toStatus);
            }
            this.weightedAveragePriceService.computeAvgPriceForProduct(stockMoveLine.getProduct());
        }
    }

    @Override
    public void updateAveragePriceLocationLine(StockLocation stockLocation, StockMoveLine stockMoveLine, int fromStatus, int toStatus) throws AxelorException {
        StockLocationLine stockLocationLine = this.stockLocationLineService.getOrCreateStockLocationLine(stockLocation, stockMoveLine.getProduct());
        if (stockLocationLine == null) {
            return;
        }
        if (toStatus == 3) {
            this.computeNewAveragePriceLocationLine(stockLocationLine, stockMoveLine);
        }
    }

    protected void computeNewAveragePriceLocationLine(StockLocationLine stockLocationLine, StockMoveLine stockMoveLine) throws AxelorException {
        BigDecimal newAvgPrice;
        BigDecimal newPrice;
        BigDecimal oldAvgPrice = stockLocationLine.getAvgPrice();
        BigDecimal newQty = stockMoveLine.getRealQty();
        BigDecimal oldQty = stockLocationLine.getCurrentQty().subtract(newQty);
        BigDecimal bigDecimal = newPrice = stockMoveLine.getWapPrice() != null ? stockMoveLine.getWapPrice() : stockMoveLine.getCompanyUnitPriceUntaxed();
        if (oldAvgPrice == null || oldQty == null || oldAvgPrice.compareTo(BigDecimal.ZERO) == 0 || oldQty.compareTo(BigDecimal.ZERO) == 0) {
            oldAvgPrice = BigDecimal.ZERO;
            oldQty = BigDecimal.ZERO;
        }
        Unit stockLocationLineUnit = stockLocationLine.getUnit();
        Unit stockMoveLineUnit = stockMoveLine.getUnit();
        if (stockLocationLineUnit != null && !stockLocationLineUnit.equals((Object)stockMoveLineUnit)) {
            newQty = this.unitConversionService.convert(stockMoveLineUnit, stockLocationLineUnit, newQty, newQty.scale(), stockMoveLine.getProduct());
            newPrice = this.unitConversionService.convert(stockMoveLineUnit, stockLocationLineUnit, newPrice, newPrice.scale(), stockMoveLine.getProduct());
        }
        log.debug("Old price: {}, Old quantity: {}, New price: {}, New quantity: {}", new Object[]{oldAvgPrice, oldQty, newPrice, newQty});
        BigDecimal sum = oldAvgPrice.multiply(oldQty);
        sum = sum.add(newPrice.multiply(newQty));
        BigDecimal denominator = oldQty.add(newQty);
        if (denominator.compareTo(BigDecimal.ZERO) != 0) {
            int scale = this.appBaseService.getNbDecimalDigitForUnitPrice();
            newAvgPrice = sum.divide(denominator, scale, RoundingMode.HALF_UP);
        } else {
            newAvgPrice = oldAvgPrice;
        }
        this.stockLocationLineService.updateWap(stockLocationLine, newAvgPrice, stockMoveLine);
    }

    @Override
    public void checkConformitySelection(StockMoveLine stockMoveLine, StockMove stockMove) throws AxelorException {
        Product product = stockMoveLine.getProduct();
        if (product == null || !product.getControlOnReceipt().booleanValue()) {
            return;
        }
        if (stockMove.getTypeSelect() != 3) {
            return;
        }
        if (stockMoveLine.getConformitySelect() <= 1) {
            throw new AxelorException((Model)((Object)stockMoveLine), 4, I18n.get((String)"Please fill the conformity for the product(s) : %s"), new Object[]{product.getName()});
        }
    }

    @Override
    public void checkConformitySelection(StockMove stockMove) throws AxelorException {
        if (!this.appStockService.getAppStock().getRequireToFillConformityOnReceipt().booleanValue()) {
            return;
        }
        ArrayList<String> productsWithErrors = new ArrayList<String>();
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            Product product = stockMoveLine.getProduct();
            if (product == null || !product.getProductTypeSelect().equals("storable")) continue;
            try {
                this.checkConformitySelection(stockMoveLine, stockMove);
            }
            catch (Exception e) {
                productsWithErrors.add(product.getName());
            }
        }
        if (!productsWithErrors.isEmpty()) {
            String productsWithErrorStr = productsWithErrors.stream().collect(Collectors.joining(", "));
            throw new AxelorException((Model)((Object)stockMove), 4, I18n.get((String)"Please fill the conformity for the product(s) : %s"), new Object[]{productsWithErrorStr});
        }
    }

    @Override
    public void checkExpirationDates(StockMove stockMove) throws AxelorException {
        ArrayList<String> errorList = new ArrayList<String>();
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            Product product;
            TrackingNumber trackingNumber = stockMoveLine.getTrackingNumber();
            if (trackingNumber == null || (product = trackingNumber.getProduct()) == null || !product.getCheckExpirationDateAtStockMoveRealization().booleanValue() || (!product.getHasWarranty().booleanValue() || !trackingNumber.getWarrantyExpirationDate().isBefore(this.appBaseService.getTodayDate())) && (!product.getIsPerishable().booleanValue() || !trackingNumber.getPerishableExpirationDate().isBefore(this.appBaseService.getTodayDate()))) continue;
            errorList.add(product.getName());
        }
        if (!errorList.isEmpty()) {
            String errorStr = errorList.stream().collect(Collectors.joining(", "));
            throw new AxelorException(4, I18n.get((String)"Expired product(s): %s"), new Object[]{errorStr});
        }
    }

    @Override
    public void checkTrackingNumber(StockMove stockMove) throws AxelorException {
        ArrayList<String> productsWithErrors = new ArrayList<String>();
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            if (stockMoveLine.getProduct() == null) continue;
            TrackingNumberConfiguration trackingNumberConfig = stockMoveLine.getProduct().getTrackingNumberConfiguration();
            if (stockMoveLine.getProduct() == null || trackingNumberConfig == null || !trackingNumberConfig.getIsPurchaseTrackingManaged().booleanValue() && !trackingNumberConfig.getIsProductionTrackingManaged().booleanValue() && (!trackingNumberConfig.getIsSaleTrackingManaged().booleanValue() || stockMove.getTypeSelect() != 2) || stockMoveLine.getTrackingNumber() != null || stockMoveLine.getRealQty().compareTo(BigDecimal.ZERO) == 0 || productsWithErrors.contains(stockMoveLine.getProduct().getName())) continue;
            productsWithErrors.add(stockMoveLine.getProduct().getName());
        }
        if (!productsWithErrors.isEmpty()) {
            String productWithErrorsStr = productsWithErrors.stream().collect(Collectors.joining(", "));
            throw new AxelorException(3, I18n.get((String)"Please fill the tracking number for the product(s) : %s"), new Object[]{productWithErrorsStr});
        }
    }

    @Override
    public void updateLocations(StockMoveLine stockMoveLine, StockLocation fromStockLocation, StockLocation toStockLocation, Product product, BigDecimal qty, int fromStatus, int toStatus, LocalDate lastFutureStockMoveDate, TrackingNumber trackingNumber) throws AxelorException {
        Unit stockMoveLineUnit = stockMoveLine.getUnit();
        switch (fromStatus) {
            case 2: {
                this.stockLocationLineService.updateLocation(fromStockLocation, product, stockMoveLineUnit, qty, false, true, true, null, trackingNumber);
                this.stockLocationLineService.updateLocation(toStockLocation, product, stockMoveLineUnit, qty, false, true, false, null, trackingNumber);
                break;
            }
            case 3: {
                this.stockLocationLineService.updateLocation(fromStockLocation, product, stockMoveLineUnit, qty, true, true, true, null, trackingNumber);
                this.stockLocationLineService.updateLocation(toStockLocation, product, stockMoveLineUnit, qty, true, true, false, null, trackingNumber);
                break;
            }
        }
        switch (toStatus) {
            case 2: {
                this.stockLocationLineService.updateLocation(fromStockLocation, product, stockMoveLineUnit, qty, false, true, false, lastFutureStockMoveDate, trackingNumber);
                this.stockLocationLineService.updateLocation(toStockLocation, product, stockMoveLineUnit, qty, false, true, true, lastFutureStockMoveDate, trackingNumber);
                break;
            }
            case 3: {
                this.stockLocationLineService.updateLocation(fromStockLocation, product, stockMoveLineUnit, qty, true, true, false, null, trackingNumber);
                this.stockLocationLineService.updateLocation(toStockLocation, product, stockMoveLineUnit, qty, true, true, true, null, trackingNumber);
                break;
            }
        }
    }

    @Override
    public Unit getStockUnit(StockMoveLine stockMoveLine) {
        Unit stockUnit = stockMoveLine.getUnit();
        if (stockUnit == null && stockMoveLine.getProduct() != null) {
            stockUnit = stockMoveLine.getProduct().getUnit();
        }
        return stockUnit;
    }

    @Override
    public StockMoveLine compute(StockMoveLine stockMoveLine, StockMove stockMove) throws AxelorException {
        BigDecimal unitPriceUntaxed = BigDecimal.ZERO;
        if (stockMoveLine.getProduct() != null && stockMove != null) {
            unitPriceUntaxed = stockMove.getTypeSelect() == 2 ? stockMoveLine.getProduct().getSalePrice() : (stockMove.getTypeSelect() == 3 ? stockMoveLine.getProduct().getPurchasePrice() : (stockMove.getTypeSelect() == 1 && stockMove.getFromStockLocation() != null && stockMove.getFromStockLocation().getTypeSelect() != 3 ? this.computeFromStockLocation(stockMoveLine, stockMove.getFromStockLocation()) : stockMoveLine.getProduct().getCostPrice()));
        }
        stockMoveLine.setUnitPriceUntaxed(unitPriceUntaxed);
        stockMoveLine.setUnitPriceTaxed(unitPriceUntaxed);
        stockMoveLine.setCompanyUnitPriceUntaxed(unitPriceUntaxed);
        return stockMoveLine;
    }

    protected BigDecimal computeFromStockLocation(StockMoveLine stockMoveLine, StockLocation stockLocation) throws AxelorException {
        Optional<StockLocationLine> stockLocationLine = Optional.ofNullable(this.stockLocationLineService.getStockLocationLine(stockLocation, stockMoveLine.getProduct()));
        BigDecimal priceFromLocation = BigDecimal.ZERO;
        if (stockLocationLine.isPresent()) {
            priceFromLocation = stockLocationLine.get().getAvgPrice();
            priceFromLocation = this.unitConversionService.convert(stockMoveLine.getUnit(), this.getStockUnit(stockMoveLine), priceFromLocation, priceFromLocation.scale(), null);
        }
        return priceFromLocation;
    }

    @Override
    public void storeCustomsCodes(List<StockMoveLine> stockMoveLineList) {
        if (stockMoveLineList == null) {
            return;
        }
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            Product product = stockMoveLine.getProduct();
            CustomsCodeNomenclature customsCodeNomenclature = product != null ? product.getCustomsCodeNomenclature() : null;
            stockMoveLine.setCustomsCodeNomenclature(customsCodeNomenclature);
            stockMoveLine.setCustomsCode(customsCodeNomenclature != null ? customsCodeNomenclature.getCode() : null);
        }
    }

    @Override
    public boolean computeFullySpreadOverLogisticalFormLinesFlag(StockMoveLine stockMoveLine) {
        return this.computeSpreadableQtyOverLogisticalFormLines(stockMoveLine).signum() <= 0;
    }

    @Override
    public BigDecimal computeSpreadableQtyOverLogisticalFormLines(StockMoveLine stockMoveLine) {
        return stockMoveLine != null ? this.computeSpreadableQtyOverLogisticalFormLines(stockMoveLine, stockMoveLine.getLogisticalFormLineList()) : BigDecimal.ZERO;
    }

    @Override
    public BigDecimal computeSpreadableQtyOverLogisticalFormLines(StockMoveLine stockMoveLine, LogisticalForm logisticalForm) {
        if (logisticalForm == null && stockMoveLine != null) {
            return this.computeSpreadableQtyOverLogisticalFormLines(stockMoveLine, stockMoveLine.getLogisticalFormLineList());
        }
        ArrayList<LogisticalFormLine> updatedLogisticalFormLineList = new ArrayList<LogisticalFormLine>();
        if (stockMoveLine != null && stockMoveLine.getLogisticalFormLineList() != null) {
            for (LogisticalFormLine logisticalFormLine : stockMoveLine.getLogisticalFormLineList()) {
                if (logisticalForm.equals((Object)logisticalFormLine.getLogisticalForm())) continue;
                updatedLogisticalFormLineList.add(logisticalFormLine);
            }
        }
        if (logisticalForm.getLogisticalFormLineList() != null) {
            for (LogisticalFormLine logisticalFormLine : logisticalForm.getLogisticalFormLineList()) {
                if (stockMoveLine == null || !stockMoveLine.equals((Object)logisticalFormLine.getStockMoveLine())) continue;
                updatedLogisticalFormLineList.add(logisticalFormLine);
            }
        }
        return this.computeSpreadableQtyOverLogisticalFormLines(stockMoveLine, updatedLogisticalFormLineList);
    }

    private BigDecimal computeSpreadableQtyOverLogisticalFormLines(StockMoveLine stockMoveLine, List<LogisticalFormLine> logisticalFormLineList) {
        if (stockMoveLine == null) {
            return null;
        }
        if (stockMoveLine.getProduct() == null || !"storable".equals(stockMoveLine.getProduct().getProductTypeSelect())) {
            return BigDecimal.ZERO;
        }
        if (logisticalFormLineList == null) {
            return stockMoveLine.getRealQty();
        }
        BigDecimal qtySpreadOverLogisticalMoveLines = logisticalFormLineList.stream().map(logisticalFormLine -> logisticalFormLine.getQty() != null ? logisticalFormLine.getQty() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        return stockMoveLine.getRealQty().subtract(qtySpreadOverLogisticalMoveLines);
    }

    @Override
    public void setProductInfo(StockMove stockMove, StockMoveLine stockMoveLine, Company company) throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)stockMoveLine));
        Preconditions.checkNotNull((Object)((Object)company));
        Product product = stockMoveLine.getProduct();
        if (product == null) {
            return;
        }
        stockMoveLine.setUnit(product.getUnit());
        stockMoveLine.setProductName(product.getName());
        if (this.appStockService.getAppStock().getIsEnabledProductDescriptionCopy().booleanValue()) {
            stockMoveLine.setDescription(product.getDescription());
        }
        if (this.appBaseService.getAppBase().getManageProductVariants().booleanValue()) {
            stockMoveLine.setProductModel(product.getParentProduct());
        }
        stockMoveLine.setCountryOfOrigin(product.getCountryOfOrigin());
        BigDecimal netMass = this.computeNetMass(stockMove, stockMoveLine, company);
        stockMoveLine.setNetMass(netMass);
    }

    public BigDecimal computeNetMass(StockMove stockMove, StockMoveLine stockMoveLine, Company company) throws AxelorException {
        Product product = stockMoveLine.getProduct();
        if (product == null || !product.getProductTypeSelect().equals("storable")) {
            return null;
        }
        Unit startUnit = product.getMassUnit();
        if (startUnit == null) {
            if (stockMove != null && !this.checkMassesRequired(stockMove, stockMoveLine)) {
                return product.getNetMass();
            }
            throw new AxelorException(4, I18n.get((String)"Please configure mass units for this product packing : %s"), new Object[]{product.getName()});
        }
        Unit endUnit = company != null && company.getStockConfig() != null && company.getStockConfig().getCustomsMassUnit() != null ? company.getStockConfig().getCustomsMassUnit() : startUnit;
        BigDecimal netMass = this.unitConversionService.convert(startUnit, endUnit, product.getNetMass(), 10, product);
        return netMass;
    }

    @Override
    public boolean checkMassesRequired(StockMove stockMove, StockMoveLine stockMoveLine) {
        Address fromAddress = this.stockMoveToolService.getFromAddress(stockMove);
        Address toAddress = this.stockMoveToolService.getToAddress(stockMove);
        Country fromCountry = fromAddress != null ? fromAddress.getAddressL7Country() : null;
        Country toCountry = toAddress != null ? toAddress.getAddressL7Country() : null;
        return fromCountry != null && toCountry != null && !fromCountry.equals((Object)toCountry) && stockMoveLine.getProduct() != null && fromCountry.getEconomicArea() != null && fromCountry.getEconomicArea().equals((Object)toCountry.getEconomicArea()) && stockMoveLine.getProduct().getUsedInDEB() != false;
    }

    @Override
    @Transactional
    public void splitStockMoveLineByTrackingNumber(StockMoveLine stockMoveLine, List<LinkedHashMap<String, Object>> trackingNumbers) {
        BigDecimal totalSplitQty = BigDecimal.ZERO;
        for (LinkedHashMap<String, Object> trackingNumberItem : trackingNumbers) {
            BigDecimal counter = new BigDecimal(trackingNumberItem.get("counter").toString());
            if (counter.compareTo(BigDecimal.ZERO) == 0) continue;
            totalSplitQty = totalSplitQty.add(counter);
            TrackingNumber trackingNumber = (TrackingNumber)((Object)this.trackingNumberRepo.all().filter("self.product.id = ?1 and self.trackingNumberSeq = ?2", new Object[]{stockMoveLine.getProduct(), trackingNumberItem.get("trackingNumberSeq").toString()}).fetchOne());
            if (trackingNumber == null) {
                trackingNumber = new TrackingNumber();
                trackingNumber.setCounter(counter);
                trackingNumber.setTrackingNumberSeq(trackingNumberItem.get("trackingNumberSeq").toString());
                if (trackingNumberItem.get("warrantyExpirationDate") != null) {
                    trackingNumber.setWarrantyExpirationDate(LocalDate.parse(trackingNumberItem.get("warrantyExpirationDate").toString()));
                }
                if (trackingNumberItem.get("perishableExpirationDate") != null) {
                    trackingNumber.setPerishableExpirationDate(LocalDate.parse(trackingNumberItem.get("perishableExpirationDate").toString()));
                }
                trackingNumber.setProduct(stockMoveLine.getProduct());
            }
            StockMoveLine newStockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepository.copy((Model)((Object)stockMoveLine), true));
            newStockMoveLine.setQty(counter);
            newStockMoveLine.setRealQty(counter);
            newStockMoveLine.setTrackingNumber(trackingNumber);
            newStockMoveLine.setStockMove(stockMoveLine.getStockMove());
            this.stockMoveLineRepository.save((Model)((Object)newStockMoveLine));
        }
        if (totalSplitQty.compareTo(stockMoveLine.getQty()) < 0) {
            BigDecimal remainingQty = stockMoveLine.getQty().subtract(totalSplitQty);
            stockMoveLine.setQty(remainingQty);
            stockMoveLine.setRealQty(remainingQty);
            stockMoveLine.setTrackingNumber(null);
            stockMoveLine.setStockMove(stockMoveLine.getStockMove());
        } else {
            this.stockMoveLineRepository.remove((Model)((Object)stockMoveLine));
        }
    }

    @Override
    public void updateAvailableQty(StockMoveLine stockMoveLine, StockLocation stockLocation) {
        BigDecimal availableQty = BigDecimal.ZERO;
        BigDecimal availableQtyForProduct = BigDecimal.ZERO;
        if (stockMoveLine.getProduct() != null) {
            if (stockMoveLine.getProduct().getTrackingNumberConfiguration() != null) {
                StockLocationLine stockLocationLineForProduct;
                StockLocationLine stockLocationLine;
                if (stockMoveLine.getTrackingNumber() != null && (stockLocationLine = this.stockLocationLineService.getDetailLocationLine(stockLocation, stockMoveLine.getProduct(), stockMoveLine.getTrackingNumber())) != null) {
                    availableQty = stockLocationLine.getCurrentQty();
                }
                if (availableQty.compareTo(stockMoveLine.getRealQty()) < 0 && (stockLocationLineForProduct = this.stockLocationLineService.getStockLocationLine(stockLocation, stockMoveLine.getProduct())) != null) {
                    availableQtyForProduct = stockLocationLineForProduct.getCurrentQty();
                }
            } else {
                StockLocationLine stockLocationLine = this.stockLocationLineService.getStockLocationLine(stockLocation, stockMoveLine.getProduct());
                if (stockLocationLine != null) {
                    availableQty = stockLocationLine.getCurrentQty();
                }
            }
        }
        stockMoveLine.setAvailableQty(availableQty);
        stockMoveLine.setAvailableQtyForProduct(availableQtyForProduct);
    }

    @Override
    public String createDomainForProduct(StockMoveLine stockMoveLine, StockMove stockMove) {
        String domain = "self.isModel = false AND self.isShippingCostsProduct = false";
        if (stockMoveLine.getProductModel() != null) {
            domain = domain + " AND self.parentProduct.id = " + stockMoveLine.getProductModel().getId();
        }
        if (stockMoveLine.getFilterOnAvailableProducts().booleanValue() && stockMove.getFromStockLocation().getTypeSelect() != 3) {
            domain = domain + " AND self.id in (select sll.product.id from StockLocation sl inner join sl.stockLocationLineList sll WHERE sl.id = " + stockMove.getFromStockLocation().getId() + " AND sll.currentQty > 0)";
        }
        return domain;
    }

    @Override
    public void setAvailableStatus(StockMoveLine stockMoveLine) {
        if (stockMoveLine.getStockMove() != null) {
            this.updateAvailableQty(stockMoveLine, stockMoveLine.getStockMove().getFromStockLocation());
        }
        if (stockMoveLine.getProduct() != null) {
            BigDecimal availableQty = stockMoveLine.getAvailableQty();
            BigDecimal availableQtyForProduct = stockMoveLine.getAvailableQtyForProduct();
            BigDecimal realQty = stockMoveLine.getRealQty();
            if (availableQty.compareTo(realQty) >= 0 || !stockMoveLine.getProduct().getStockManaged().booleanValue()) {
                stockMoveLine.setAvailableStatus(I18n.get((String)"Available"));
                stockMoveLine.setAvailableStatusSelect(1);
            } else if (availableQtyForProduct.compareTo(realQty) >= 0) {
                stockMoveLine.setAvailableStatus(I18n.get((String)"Av. for product"));
                stockMoveLine.setAvailableStatusSelect(2);
            } else if (availableQty.compareTo(realQty) < 0 && availableQtyForProduct.compareTo(realQty) < 0) {
                BigDecimal missingQty = BigDecimal.ZERO;
                missingQty = stockMoveLine.getProduct().getTrackingNumberConfiguration() != null ? availableQtyForProduct.subtract(realQty) : availableQty.subtract(realQty);
                stockMoveLine.setAvailableStatus(I18n.get((String)"Missing") + " (" + missingQty + ")");
                stockMoveLine.setAvailableStatusSelect(3);
            }
        }
    }

    @Override
    public List<TrackingNumber> getAvailableTrackingNumbers(StockMoveLine stockMoveLine, StockMove stockMove) {
        List trackingNumbers = null;
        String domain = "self.product.id = " + stockMoveLine.getProduct().getId() + " AND self.id in (select stockLocationLine.trackingNumber.id from StockLocationLine stockLocationLine join StockLocation sl on sl.id = stockLocationLine.detailsStockLocation.id WHERE sl.id = " + stockMove.getFromStockLocation().getId() + " )";
        trackingNumbers = this.trackingNumberRepo.all().filter(domain).fetch();
        return trackingNumbers;
    }

    @Override
    public void fillRealizeWapPrice(StockMoveLine stockMoveLine) {
        StockLocation stockLocation = stockMoveLine.getStockMove().getFromStockLocation();
        Optional<StockLocationLine> stockLocationLineOpt = Optional.ofNullable(this.stockLocationLineService.getStockLocationLine(stockLocation, stockMoveLine.getProduct()));
        stockLocationLineOpt.ifPresent(stockLocationLine -> stockMoveLine.setWapPrice(stockLocationLine.getAvgPrice()));
    }
}

