/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.FreightCarrierMode;
import com.axelor.apps.stock.db.Incoterm;
import com.axelor.apps.stock.db.InventoryLine;
import com.axelor.apps.stock.db.ShipmentMode;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.InventoryLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.PartnerProductQualityRatingService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockMoveServiceImpl
implements StockMoveService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected StockMoveLineService stockMoveLineService;
    protected AppBaseService appBaseService;
    protected StockMoveRepository stockMoveRepo;
    protected PartnerProductQualityRatingService partnerProductQualityRatingService;
    protected ProductRepository productRepository;
    private StockMoveToolService stockMoveToolService;
    private StockMoveLineRepository stockMoveLineRepo;

    @Inject
    public StockMoveServiceImpl(StockMoveLineService stockMoveLineService, StockMoveToolService stockMoveToolService, StockMoveLineRepository stockMoveLineRepository, AppBaseService appBaseService, StockMoveRepository stockMoveRepository, PartnerProductQualityRatingService partnerProductQualityRatingService, ProductRepository productRepository) {
        this.stockMoveLineService = stockMoveLineService;
        this.stockMoveToolService = stockMoveToolService;
        this.stockMoveLineRepo = stockMoveLineRepository;
        this.appBaseService = appBaseService;
        this.stockMoveRepo = stockMoveRepository;
        this.partnerProductQualityRatingService = partnerProductQualityRatingService;
        this.productRepository = productRepository;
    }

    @Override
    public StockMove createStockMove(Address fromAddress, Address toAddress, Company company, Partner clientPartner, StockLocation fromStockLocation, StockLocation toStockLocation, LocalDate realDate, LocalDate estimatedDate, String note, ShipmentMode shipmentMode, FreightCarrierMode freightCarrierMode, Partner carrierPartner, Partner forwarderPartner, Incoterm incoterm, int typeSelect) throws AxelorException {
        StockMove stockMove = this.createStockMove(fromAddress, toAddress, company, fromStockLocation, toStockLocation, realDate, estimatedDate, note, typeSelect);
        stockMove.setPartner(clientPartner);
        stockMove.setShipmentMode(shipmentMode);
        stockMove.setFreightCarrierMode(freightCarrierMode);
        stockMove.setCarrierPartner(carrierPartner);
        stockMove.setForwarderPartner(forwarderPartner);
        stockMove.setIncoterm(incoterm);
        stockMove.setNote(note);
        stockMove.setIsIspmRequired(this.stockMoveToolService.getDefaultISPM(clientPartner, toAddress));
        return stockMove;
    }

    @Override
    public StockMove createStockMove(Address fromAddress, Address toAddress, Company company, StockLocation fromStockLocation, StockLocation toStockLocation, LocalDate realDate, LocalDate estimatedDate, String note, int typeSelect) throws AxelorException {
        StockMove stockMove = new StockMove();
        if (stockMove.getStockMoveLineList() == null) {
            stockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
        }
        stockMove.setFromAddress(fromAddress);
        stockMove.setToAddress(toAddress);
        this.stockMoveToolService.computeAddressStr(stockMove);
        stockMove.setCompany(company);
        stockMove.setStatusSelect(1);
        stockMove.setRealDate(realDate);
        stockMove.setEstimatedDate(estimatedDate);
        stockMove.setFromStockLocation(fromStockLocation);
        stockMove.setToStockLocation(toStockLocation);
        stockMove.setNote(note);
        stockMove.setPrintingSettings(((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(null, company));
        stockMove.setTypeSelect(typeSelect);
        stockMove.setIsWithBackorder(company.getStockConfig().getIsWithBackorder());
        if (typeSelect == 3) {
            stockMove.setIsWithReturnSurplus(company.getStockConfig().getIsWithReturnSurplus());
        }
        return stockMove;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(StockMove stockMove) throws AxelorException {
        this.plan(stockMove);
        this.realize(stockMove);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void goBackToDraft(StockMove stockMove) throws AxelorException {
        if (stockMove.getStatusSelect() != 4) {
            throw new AxelorException((Model)((Object)stockMove), 5, I18n.get((String)"Cannot go back to draft status."));
        }
        stockMove.setAvailabilityRequest(false);
        stockMove.setPickingEditDate(null);
        stockMove.setPickingIsEdited(false);
        stockMove.setStatusSelect(1);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void plan(StockMove stockMove) throws AxelorException {
        String draftSeq;
        LOG.debug("Planification du mouvement de stock : {} ", (Object)stockMove.getStockMoveSeq());
        if (stockMove.getExTaxTotal().compareTo(BigDecimal.ZERO) == 0) {
            stockMove.setExTaxTotal(this.stockMoveToolService.compute(stockMove));
        }
        StockLocation fromStockLocation = stockMove.getFromStockLocation();
        StockLocation toStockLocation = stockMove.getToStockLocation();
        if (fromStockLocation == null) {
            throw new AxelorException((Model)((Object)stockMove), 4, I18n.get((String)"There's no source stock location selected for the stock's movement %s"), new Object[]{stockMove.getName()});
        }
        if (toStockLocation == null) {
            throw new AxelorException((Model)((Object)stockMove), 4, I18n.get((String)"There's no destination stock location selected for the stock's movement %s"), new Object[]{stockMove.getName()});
        }
        if (stockMove.getTypeSelect() == null || stockMove.getTypeSelect() == 0) {
            stockMove.setTypeSelect(this.stockMoveToolService.getStockMoveType(fromStockLocation, toStockLocation));
        }
        if (((SequenceService)Beans.get(SequenceService.class)).isEmptyOrDraftSequenceNumber(stockMove.getStockMoveSeq())) {
            draftSeq = stockMove.getStockMoveSeq();
            stockMove.setStockMoveSeq(this.stockMoveToolService.getSequenceStockMove(stockMove.getTypeSelect(), stockMove.getCompany()));
        } else {
            draftSeq = null;
        }
        if (Strings.isNullOrEmpty((String)stockMove.getName()) || draftSeq != null && stockMove.getName().startsWith(draftSeq)) {
            stockMove.setName(this.stockMoveToolService.computeName(stockMove));
        }
        int initialStatus = stockMove.getStatusSelect();
        this.setPlannedStatus(stockMove);
        this.updateLocations(stockMove, fromStockLocation, toStockLocation, initialStatus);
        stockMove.setCancelReason(null);
        this.stockMoveRepo.save((Model)((Object)stockMove));
        if (stockMove.getTypeSelect() == 2 && stockMove.getPlannedStockMoveAutomaticMail() != null && stockMove.getPlannedStockMoveAutomaticMail().booleanValue()) {
            this.sendMailForStockMove(stockMove, stockMove.getPlannedStockMoveMessageTemplate());
        }
    }

    protected void setPlannedStatus(StockMove stockMove) {
        stockMove.setStatusSelect(2);
        this.stockMoveRepo.save((Model)((Object)stockMove));
    }

    protected void updateLocations(StockMove stockMove, StockLocation fromStockLocation, StockLocation toStockLocation, int initialStatus) throws AxelorException {
        this.copyPlannedStockMovLines(stockMove);
        this.stockMoveLineService.updateLocations(fromStockLocation, toStockLocation, initialStatus, 2, stockMove.getPlannedStockMoveLineList(), stockMove.getEstimatedDate(), false);
    }

    protected void copyPlannedStockMovLines(StockMove stockMove) {
        List stockMoveLineList = (List)MoreObjects.firstNonNull(stockMove.getStockMoveLineList(), Collections.emptyList());
        stockMove.clearPlannedStockMoveLineList();
        stockMoveLineList.forEach(stockMoveLine -> {
            StockMoveLine copy = (StockMoveLine)((Object)((Object)this.stockMoveLineRepo.copy((Model)((Object)stockMoveLine), false)));
            copy.setArchived(true);
            stockMove.addPlannedStockMoveLineListItem(copy);
        });
    }

    @Override
    public String realize(StockMove stockMove) throws AxelorException {
        return this.realize(stockMove, true);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String realize(StockMove stockMove, boolean checkOngoingInventoryFlag) throws AxelorException {
        Optional<StockMove> newStockMove;
        LOG.debug("R\u00e9alisation du mouvement de stock : {} ", (Object)stockMove.getStockMoveSeq());
        if (checkOngoingInventoryFlag) {
            this.checkOngoingInventory(stockMove);
        }
        int initialStatus = stockMove.getStatusSelect();
        String newStockSeq = null;
        this.stockMoveLineService.checkTrackingNumber(stockMove);
        this.stockMoveLineService.checkConformitySelection(stockMove);
        if (stockMove.getFromStockLocation().getTypeSelect() != 3) {
            stockMove.getStockMoveLineList().forEach(this.stockMoveLineService::fillRealizeWapPrice);
        }
        this.checkExpirationDates(stockMove);
        this.setRealizedStatus(stockMove);
        this.stockMoveLineService.updateLocations(stockMove.getFromStockLocation(), stockMove.getToStockLocation(), initialStatus, 4, stockMove.getPlannedStockMoveLineList(), stockMove.getEstimatedDate(), false);
        this.stockMoveLineService.updateLocations(stockMove.getFromStockLocation(), stockMove.getToStockLocation(), 1, 3, stockMove.getStockMoveLineList(), stockMove.getEstimatedDate(), true);
        stockMove.clearPlannedStockMoveLineList();
        this.stockMoveLineService.storeCustomsCodes(stockMove.getStockMoveLineList());
        stockMove.setRealDate(this.appBaseService.getTodayDate());
        this.resetMasses(stockMove);
        if (stockMove.getIsWithBackorder().booleanValue() && this.mustBeSplit(stockMove.getStockMoveLineList()) && (newStockMove = this.copyAndSplitStockMove(stockMove)).isPresent()) {
            newStockSeq = newStockMove.get().getStockMoveSeq();
        }
        if (stockMove.getIsWithReturnSurplus().booleanValue() && this.mustBeSplit(stockMove.getStockMoveLineList()) && (newStockMove = this.copyAndSplitStockMoveReverse(stockMove, true)).isPresent()) {
            newStockSeq = newStockSeq != null ? newStockSeq + " " + newStockMove.get().getStockMoveSeq() : newStockMove.get().getStockMoveSeq();
        }
        this.computeMasses(stockMove);
        this.stockMoveRepo.save((Model)((Object)stockMove));
        if (stockMove.getTypeSelect() == 3) {
            this.partnerProductQualityRatingService.calculate(stockMove);
        } else if (stockMove.getTypeSelect() == 2 && stockMove.getRealStockMoveAutomaticMail() != null && stockMove.getRealStockMoveAutomaticMail().booleanValue()) {
            this.sendMailForStockMove(stockMove, stockMove.getRealStockMoveMessageTemplate());
        }
        return newStockSeq;
    }

    protected void setRealizedStatus(StockMove stockMove) {
        stockMove.setStatusSelect(3);
        this.stockMoveRepo.save((Model)((Object)stockMove));
    }

    protected void sendMailForStockMove(StockMove stockMove, Template template) throws AxelorException {
        if (template == null) {
            throw new AxelorException(4, I18n.get((String)"The template to send message on realization is missing."), new Object[]{stockMove});
        }
        try {
            ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateAndSendMessage((Model)((Object)stockMove), template);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    private void checkOngoingInventory(StockMove stockMove) throws AxelorException {
        ArrayList<StockLocation> stockLocationList = new ArrayList<StockLocation>();
        if (stockMove.getFromStockLocation().getTypeSelect() != 3) {
            stockLocationList.add(stockMove.getFromStockLocation());
        }
        if (stockMove.getToStockLocation().getTypeSelect() != 3) {
            stockLocationList.add(stockMove.getToStockLocation());
        }
        if (stockLocationList.isEmpty()) {
            return;
        }
        List productList = stockMove.getStockMoveLineList().stream().map(StockMoveLine::getProduct).filter(Objects::nonNull).collect(Collectors.toList());
        if (productList.isEmpty()) {
            return;
        }
        InventoryLineRepository inventoryLineRepo = (InventoryLineRepository)((Object)Beans.get(InventoryLineRepository.class));
        InventoryLine inventoryLine = (InventoryLine)((Object)inventoryLineRepo.all().filter("self.inventory.statusSelect BETWEEN :startStatus AND :endStatus\nAND self.inventory.stockLocation IN (:stockLocationList)\nAND self.product IN (:productList)").bind("startStatus", (Object)3).bind("endStatus", (Object)4).bind("stockLocationList", stockLocationList).bind("productList", productList).fetchOne());
        if (inventoryLine != null) {
            throw new AxelorException((Model)((Object)inventoryLine), 5, I18n.get((String)"Can't realize this stock move because of the ongoing inventory %s."), new Object[]{inventoryLine.getInventory().getInventorySeq()});
        }
    }

    private void resetMasses(StockMove stockMove) {
        List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
        if (stockMoveLineList == null) {
            return;
        }
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            stockMoveLine.setTotalNetMass(null);
        }
    }

    private void computeMasses(StockMove stockMove) throws AxelorException {
        StockConfig stockConfig = stockMove.getCompany().getStockConfig();
        Unit endUnit = stockConfig != null ? stockConfig.getCustomsMassUnit() : null;
        boolean massesRequiredForStockMove = false;
        List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
        if (stockMoveLineList == null) {
            return;
        }
        UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            Unit startUnit;
            Product product = stockMoveLine.getProduct();
            boolean massesRequiredForStockMoveLine = this.stockMoveLineService.checkMassesRequired(stockMove, stockMoveLine);
            if (product == null || !"storable".equals(product.getProductTypeSelect())) continue;
            BigDecimal netMass = stockMoveLine.getNetMass();
            if (netMass.signum() == 0 && (startUnit = product.getMassUnit()) != null && endUnit != null) {
                netMass = unitConversionService.convert(startUnit, endUnit, product.getNetMass(), product.getNetMass().scale(), null);
                stockMoveLine.setNetMass(netMass);
            }
            if (netMass.signum() != 0) {
                BigDecimal totalNetMass = netMass.multiply(stockMoveLine.getRealQty());
                stockMoveLine.setTotalNetMass(totalNetMass);
            } else if (massesRequiredForStockMoveLine) {
                throw new AxelorException((Model)((Object)stockMove), 3, I18n.get((String)"All storable products used in DEB must have net mass and mass unit information for customs."));
            }
            if (massesRequiredForStockMove || !massesRequiredForStockMoveLine) continue;
            massesRequiredForStockMove = true;
        }
        if (massesRequiredForStockMove && endUnit == null) {
            throw new AxelorException((Model)((Object)stockMove), 3, I18n.get((String)"Must set mass unit in stock configuration for customs."));
        }
    }

    @Override
    public boolean mustBeSplit(List<StockMoveLine> stockMoveLineList) {
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            if (stockMoveLine.getRealQty().compareTo(stockMoveLine.getQty()) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<StockMove> copyAndSplitStockMove(StockMove stockMove) throws AxelorException {
        return this.copyAndSplitStockMove(stockMove, stockMove.getStockMoveLineList());
    }

    @Override
    public Optional<StockMove> copyAndSplitStockMove(StockMove stockMove, List<StockMoveLine> stockMoveLines) throws AxelorException {
        stockMoveLines = (List)MoreObjects.firstNonNull(stockMoveLines, Collections.emptyList());
        StockMove newStockMove = (StockMove)((Object)this.stockMoveRepo.copy((Model)((Object)stockMove), false));
        newStockMove.setOriginTypeSelect(stockMove.getOriginTypeSelect());
        for (StockMoveLine stockMoveLine : stockMoveLines) {
            if (stockMoveLine.getQty().compareTo(stockMoveLine.getRealQty()) <= 0) continue;
            StockMoveLine newStockMoveLine = this.copySplittedStockMoveLine(stockMoveLine);
            newStockMove.addStockMoveLineListItem(newStockMoveLine);
        }
        if (ObjectUtils.isEmpty(newStockMove.getStockMoveLineList())) {
            return Optional.empty();
        }
        newStockMove.setRealDate(null);
        newStockMove.setStockMoveSeq(this.stockMoveToolService.getSequenceStockMove(newStockMove.getTypeSelect(), newStockMove.getCompany()));
        newStockMove.setName(this.stockMoveToolService.computeName(newStockMove, newStockMove.getStockMoveSeq() + " " + I18n.get((String)"Partial stock move (From") + " " + stockMove.getStockMoveSeq() + " )"));
        newStockMove.setExTaxTotal(this.stockMoveToolService.compute(newStockMove));
        this.plan(newStockMove);
        newStockMove.setStockMoveOrigin(stockMove);
        this.stockMoveRepo.save((Model)((Object)newStockMove));
        stockMove.setBackorderId(newStockMove.getId());
        return Optional.of(newStockMove);
    }

    protected StockMoveLine copySplittedStockMoveLine(StockMoveLine stockMoveLine) throws AxelorException {
        StockMoveLine newStockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)stockMoveLine), false));
        newStockMoveLine.setQty(stockMoveLine.getQty().subtract(stockMoveLine.getRealQty()));
        newStockMoveLine.setRealQty(newStockMoveLine.getQty());
        return newStockMoveLine;
    }

    @Override
    public Optional<StockMove> copyAndSplitStockMoveReverse(StockMove stockMove, boolean split) throws AxelorException {
        return this.copyAndSplitStockMoveReverse(stockMove, stockMove.getStockMoveLineList(), split);
    }

    @Override
    public Optional<StockMove> copyAndSplitStockMoveReverse(StockMove stockMove, List<StockMoveLine> stockMoveLines, boolean split) throws AxelorException {
        stockMoveLines = (List)MoreObjects.firstNonNull(stockMoveLines, Collections.emptyList());
        StockMove newStockMove = this.createStockMove(stockMove.getToAddress(), stockMove.getFromAddress(), stockMove.getCompany(), stockMove.getPartner(), stockMove.getToStockLocation(), stockMove.getFromStockLocation(), null, stockMove.getEstimatedDate(), null, null, null, null, null, stockMove.getIncoterm(), 0);
        if (stockMove.getToAddress() != null) {
            newStockMove.setFromAddress(stockMove.getToAddress());
        }
        if (stockMove.getTypeSelect() == 3) {
            newStockMove.setTypeSelect(2);
        }
        if (stockMove.getTypeSelect() == 2) {
            newStockMove.setTypeSelect(3);
        }
        if (stockMove.getTypeSelect() == 1) {
            newStockMove.setTypeSelect(1);
        }
        newStockMove.setStockMoveSeq(this.stockMoveToolService.getSequenceStockMove(newStockMove.getTypeSelect(), newStockMove.getCompany()));
        for (StockMoveLine stockMoveLine : stockMoveLines) {
            if (split && stockMoveLine.getRealQty().compareTo(stockMoveLine.getQty()) <= 0) continue;
            StockMoveLine newStockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)stockMoveLine), false));
            if (split) {
                newStockMoveLine.setQty(stockMoveLine.getRealQty().subtract(stockMoveLine.getQty()));
                newStockMoveLine.setRealQty(newStockMoveLine.getQty());
            } else {
                newStockMoveLine.setQty(stockMoveLine.getRealQty());
                newStockMoveLine.setRealQty(stockMoveLine.getRealQty());
            }
            newStockMove.addStockMoveLineListItem(newStockMoveLine);
        }
        if (ObjectUtils.isEmpty(newStockMove.getStockMoveLineList())) {
            return Optional.empty();
        }
        newStockMove.setStockMoveSeq(this.stockMoveToolService.getSequenceStockMove(newStockMove.getTypeSelect(), newStockMove.getCompany()));
        newStockMove.setName(this.stockMoveToolService.computeName(newStockMove, newStockMove.getStockMoveSeq() + " " + I18n.get((String)"Reverse stock move (From") + " " + stockMove.getStockMoveSeq() + " )"));
        if (stockMove.getPartner() != null) {
            newStockMove.setShipmentMode(stockMove.getPartner().getShipmentMode());
            newStockMove.setFreightCarrierMode(stockMove.getPartner().getFreightCarrierMode());
            newStockMove.setCarrierPartner(stockMove.getPartner().getCarrierPartner());
        }
        newStockMove.setReversionOriginStockMove(stockMove);
        newStockMove.setFromAddressStr(stockMove.getFromAddressStr());
        newStockMove.setNote(stockMove.getNote());
        newStockMove.setNumOfPackages(stockMove.getNumOfPackages());
        newStockMove.setNumOfPalettes(stockMove.getNumOfPalettes());
        newStockMove.setGrossMass(stockMove.getGrossMass());
        newStockMove.setExTaxTotal(this.stockMoveToolService.compute(newStockMove));
        newStockMove.setIsReversion(true);
        newStockMove.setIsWithBackorder(stockMove.getIsWithBackorder());
        newStockMove.setOrigin(stockMove.getOrigin());
        newStockMove.setOriginId(stockMove.getOriginId());
        newStockMove.setOriginTypeSelect(stockMove.getOriginTypeSelect());
        return Optional.of(this.stockMoveRepo.save((Model)((Object)newStockMove)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(StockMove stockMove, CancelReason cancelReason) throws AxelorException {
        this.applyCancelReason(stockMove, cancelReason);
        this.cancel(stockMove);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(StockMove stockMove) throws AxelorException {
        LOG.debug("Annulation du mouvement de stock : {} ", (Object)stockMove.getStockMoveSeq());
        int initialStatus = stockMove.getStatusSelect();
        this.setCancelStatus(stockMove);
        if (initialStatus == 2) {
            this.stockMoveLineService.updateLocations(stockMove.getFromStockLocation(), stockMove.getToStockLocation(), initialStatus, 4, stockMove.getPlannedStockMoveLineList(), stockMove.getEstimatedDate(), false);
        } else {
            this.stockMoveLineService.updateLocations(stockMove.getFromStockLocation(), stockMove.getToStockLocation(), initialStatus, 4, stockMove.getStockMoveLineList(), stockMove.getEstimatedDate(), true);
            stockMove.setRealDate(this.appBaseService.getTodayDate());
        }
        stockMove.clearPlannedStockMoveLineList();
        if (stockMove.getTypeSelect() == 3 && initialStatus == 3) {
            this.partnerProductQualityRatingService.undoCalculation(stockMove);
        }
    }

    protected void setCancelStatus(StockMove stockMove) {
        stockMove.setStatusSelect(4);
        this.stockMoveRepo.save((Model)((Object)stockMove));
    }

    @Override
    @Transactional
    public Boolean splitStockMoveLinesUnit(List<StockMoveLine> stockMoveLines, BigDecimal splitQty) {
        Boolean selected = false;
        for (StockMoveLine moveLine : stockMoveLines) {
            StockMoveLine newLine;
            if (!moveLine.isSelected()) continue;
            selected = true;
            StockMoveLine line = (StockMoveLine)((Object)this.stockMoveLineRepo.find(moveLine.getId()));
            BigDecimal totalQty = line.getQty();
            LOG.debug("Move Line selected: {}, Qty: {}", (Object)line, (Object)totalQty);
            while (splitQty.compareTo(totalQty) < 0) {
                totalQty = totalQty.subtract(splitQty);
                newLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)line), false));
                newLine.setQty(splitQty);
                newLine.setRealQty(splitQty);
                newLine.setStockMove(line.getStockMove());
                this.stockMoveLineRepo.save((Model)((Object)newLine));
            }
            LOG.debug("Qty remains: {}", (Object)totalQty);
            if (totalQty.compareTo(BigDecimal.ZERO) > 0) {
                newLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)line), false));
                newLine.setQty(totalQty);
                newLine.setRealQty(totalQty);
                this.stockMoveLineRepo.save((Model)((Object)newLine));
                LOG.debug("New line created: {}", (Object)newLine);
            }
            this.stockMoveLineRepo.remove((Model)((Object)line));
        }
        return selected;
    }

    @Override
    @Transactional
    public void splitStockMoveLinesSpecial(StockMove stockMove, List<StockMoveLine> stockMoveLines, BigDecimal splitQty) {
        LOG.debug("SplitQty: {}", (Object)splitQty);
        for (StockMoveLine moveLine : stockMoveLines) {
            StockMoveLine newLine;
            LOG.debug("Move line: {}", (Object)moveLine);
            BigDecimal totalQty = moveLine.getQty();
            while (splitQty.compareTo(totalQty) < 0) {
                totalQty = totalQty.subtract(splitQty);
                newLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)moveLine), false));
                newLine.setQty(splitQty);
                newLine.setRealQty(splitQty);
                stockMove.addStockMoveLineListItem(newLine);
            }
            LOG.debug("Qty remains: {}", (Object)totalQty);
            if (totalQty.compareTo(BigDecimal.ZERO) > 0) {
                newLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)moveLine), false));
                newLine.setQty(totalQty);
                newLine.setRealQty(totalQty);
                stockMove.addStockMoveLineListItem(newLine);
                LOG.debug("New line created: {}", (Object)newLine);
            }
            stockMove.removeStockMoveLineListItem(moveLine);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public StockMove splitInto2(StockMove originalStockMove, List<StockMoveLine> modifiedStockMoveLines) throws AxelorException {
        StockMove newStockMove = (StockMove)((Object)this.stockMoveRepo.copy((Model)((Object)originalStockMove), false));
        newStockMove.setStockMoveLineList(new ArrayList<StockMoveLine>());
        modifiedStockMoveLines = modifiedStockMoveLines.stream().filter(stockMoveLine -> stockMoveLine.getQty().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        for (StockMoveLine moveLine : modifiedStockMoveLines) {
            StockMoveLine newStockMoveLine = (StockMoveLine)((Object)this.stockMoveLineRepo.copy((Model)((Object)moveLine), false));
            newStockMoveLine.setQty(moveLine.getQty());
            newStockMoveLine.setRealQty(moveLine.getQty());
            newStockMove.addStockMoveLineListItem(newStockMoveLine);
            Optional<StockMoveLine> correspondingMoveLine = originalStockMove.getStockMoveLineList().stream().filter(stockMoveLine -> stockMoveLine.getId().equals(moveLine.getId())).findFirst();
            if (BigDecimal.ZERO.compareTo(moveLine.getQty()) > 0 || correspondingMoveLine.isPresent() && moveLine.getQty().compareTo(correspondingMoveLine.get().getRealQty()) > 0) {
                throw new AxelorException(5, I18n.get((String)"Please enter a valid split quantity"), new Object[]{originalStockMove});
            }
            if (!correspondingMoveLine.isPresent()) continue;
            BigDecimal remainingQty = correspondingMoveLine.get().getQty().subtract(moveLine.getQty());
            if (BigDecimal.ZERO.compareTo(remainingQty) == 0) {
                originalStockMove.removeStockMoveLineListItem(correspondingMoveLine.get());
                continue;
            }
            correspondingMoveLine.get().setQty(remainingQty);
            correspondingMoveLine.get().setRealQty(remainingQty);
        }
        if (!newStockMove.getStockMoveLineList().isEmpty()) {
            newStockMove.setExTaxTotal(this.stockMoveToolService.compute(newStockMove));
            originalStockMove.setExTaxTotal(this.stockMoveToolService.compute(originalStockMove));
            return (StockMove)((Object)this.stockMoveRepo.save((Model)((Object)newStockMove)));
        }
        return null;
    }

    @Override
    @Transactional
    public void copyQtyToRealQty(StockMove stockMove) {
        for (StockMoveLine line : stockMove.getStockMoveLineList()) {
            line.setRealQty(line.getQty());
        }
        this.stockMoveRepo.save((Model)((Object)stockMove));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Optional<StockMove> generateReversion(StockMove stockMove) throws AxelorException {
        LOG.debug("Creation d'un mouvement de stock inverse pour le mouvement de stock: {} ", new Object[]{stockMove.getStockMoveSeq()});
        return this.copyAndSplitStockMoveReverse(stockMove, false);
    }

    @Override
    public List<Map<String, Object>> getStockPerDate(Long locationId, Long productId, LocalDate fromDate, LocalDate toDate) {
        ArrayList<Map<String, Object>> stock = new ArrayList<Map<String, Object>>();
        while (!fromDate.isAfter(toDate)) {
            Double qty = this.getStock(locationId, productId, fromDate);
            HashMap<String, Comparable<ChronoLocalDate>> dateStock = new HashMap<String, Comparable<ChronoLocalDate>>();
            dateStock.put("$date", fromDate);
            dateStock.put("$qty", new BigDecimal(qty));
            stock.add(dateStock);
            fromDate = fromDate.plusDays(1L);
        }
        return stock;
    }

    private Double getStock(Long locationId, Long productId, LocalDate date) {
        List inLines = this.stockMoveLineRepo.all().filter("self.product.id = ?1 AND self.stockMove.toStockLocation.id = ?2 AND self.stockMove.statusSelect != ?3 AND (self.stockMove.estimatedDate <= ?4 OR self.stockMove.realDate <= ?4)", new Object[]{productId, locationId, 4, date}).fetch();
        List outLines = this.stockMoveLineRepo.all().filter("self.product.id = ?1 AND self.stockMove.fromStockLocation.id = ?2 AND self.stockMove.statusSelect != ?3 AND (self.stockMove.estimatedDate <= ?4 OR self.stockMove.realDate <= ?4)", new Object[]{productId, locationId, 4, date}).fetch();
        Double inQty = inLines.stream().mapToDouble(inl -> Double.parseDouble(inl.getQty().toString())).sum();
        Double outQty = outLines.stream().mapToDouble(out -> Double.parseDouble(out.getQty().toString())).sum();
        Double qty = inQty - outQty;
        return qty;
    }

    @Override
    public List<StockMoveLine> changeConformityStockMove(StockMove stockMove) {
        List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
        if (stockMoveLineList != null) {
            for (StockMoveLine stockMoveLine : stockMoveLineList) {
                stockMoveLine.setConformitySelect(stockMove.getConformitySelect());
            }
        }
        return stockMoveLineList;
    }

    @Override
    public Integer changeConformityStockMoveLine(StockMove stockMove) {
        Integer stockMoveConformitySelect;
        List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
        if (stockMoveLineList != null) {
            stockMoveConformitySelect = 2;
            for (StockMoveLine stockMoveLine : stockMoveLineList) {
                Integer conformitySelect = stockMoveLine.getConformitySelect();
                if (conformitySelect.equals(2)) continue;
                stockMoveConformitySelect = conformitySelect;
                if (!conformitySelect.equals(3)) continue;
                break;
            }
        } else {
            stockMoveConformitySelect = 1;
        }
        stockMove.setConformitySelect(stockMoveConformitySelect);
        return stockMoveConformitySelect;
    }

    @Override
    public Map<String, Object> viewDirection(StockMove stockMove) throws AxelorException {
        String aString;
        String dString;
        String fromAddressStr = stockMove.getFromAddressStr();
        String toAddressStr = stockMove.getToAddressStr();
        BigDecimal dLat = BigDecimal.ZERO;
        BigDecimal dLon = BigDecimal.ZERO;
        BigDecimal aLat = BigDecimal.ZERO;
        BigDecimal aLon = BigDecimal.ZERO;
        if (Strings.isNullOrEmpty((String)fromAddressStr)) {
            Address fromAddress = stockMove.getCompany().getAddress();
            dString = fromAddress.getAddressL4() + " ," + fromAddress.getAddressL6();
            dLat = fromAddress.getLatit();
            dLon = fromAddress.getLongit();
        } else {
            dString = fromAddressStr.replace('\n', ' ');
        }
        if (toAddressStr == null) {
            Address toAddress = stockMove.getCompany().getAddress();
            aString = toAddress.getAddressL4() + " ," + toAddress.getAddressL6();
            aLat = toAddress.getLatit();
            aLon = toAddress.getLongit();
        } else {
            aString = toAddressStr.replace('\n', ' ');
        }
        if (Strings.isNullOrEmpty((String)dString) || Strings.isNullOrEmpty((String)aString)) {
            throw new AxelorException((Model)((Object)stockMove), 1, I18n.get((String)"Company address is empty."));
        }
        Map result = this.appBaseService.getAppBase().getMapApiSelect() == 2 ? ((MapService)Beans.get(MapService.class)).getDirectionMapOsm(dString, dLat, dLon, aString, aLat, aLon) : ((MapService)Beans.get(MapService.class)).getDirectionMapGoogle(dString, dLat, dLon, aString, aLat, aLon);
        if (result == null) {
            throw new AxelorException((Model)((Object)stockMove), 4, I18n.get((String)"<B>%s or %s</B> not found"), new Object[]{dString, aString});
        }
        return result;
    }

    @Override
    public String printStockMove(StockMove stockMove, List<Integer> lstSelectedMove, String reportType) throws AxelorException {
        List<Object> selectedStockMoveListId;
        if (lstSelectedMove != null && !lstSelectedMove.isEmpty()) {
            selectedStockMoveListId = lstSelectedMove.stream().map(integer -> Long.parseLong(integer.toString())).collect(Collectors.toList());
            stockMove = (StockMove)((Object)this.stockMoveRepo.find((Long)selectedStockMoveListId.get(0)));
        } else if (stockMove != null && stockMove.getId() != null) {
            selectedStockMoveListId = new ArrayList<Long>();
            selectedStockMoveListId.add(stockMove.getId());
        } else {
            throw new AxelorException(StockMove.class, 5, I18n.get((String)"Please select the StockMove(s) to print."));
        }
        List stockMoveList = this.stockMoveRepo.all().filter("self.id IN (" + selectedStockMoveListId.stream().map(Object::toString).collect(Collectors.joining(",")) + ") AND self.printingSettings IS NULL").fetch();
        if (!stockMoveList.isEmpty()) {
            String exceptionMessage = String.format(I18n.get((String)"Please fill printing settings on following stock moves: %s"), "<ul>" + stockMoveList.stream().map(StockMove::getStockMoveSeq).collect(Collectors.joining("</li><li>", "<li>", "</li>")) + "<ul>");
            throw new AxelorException(1, exceptionMessage);
        }
        String stockMoveIds = selectedStockMoveListId.stream().map(Object::toString).collect(Collectors.joining(","));
        String title = I18n.get((String)"Stock move");
        if (stockMove.getStockMoveSeq() != null) {
            title = selectedStockMoveListId.size() == 1 ? I18n.get((String)"StockMove") + " " + stockMove.getStockMoveSeq() : I18n.get((String)"StockMove(s)");
        }
        String locale = reportType.equals("PickingStockMove.rptdesign") ? ((UserService)Beans.get(UserService.class)).getLanguage() : ReportSettings.getPrintingLocale((Partner)stockMove.getPartner());
        ReportSettings reportSettings = ReportFactory.createReport((String)reportType, (String)(title + "-${date}")).addParam("StockMoveId", (Object)stockMoveIds).addParam("Locale", (Object)locale);
        if (reportType.equals("ConformityCertificate.rptdesign")) {
            reportSettings.toAttach((Model)((Object)stockMove));
        }
        return reportSettings.generate().getFileLink();
    }

    @Override
    @Transactional
    public void updateFullySpreadOverLogisticalFormsFlag(StockMove stockMove) {
        stockMove.setFullySpreadOverLogisticalFormsFlag(this.computeFullySpreadOverLogisticalFormsFlag(stockMove));
    }

    protected boolean computeFullySpreadOverLogisticalFormsFlag(StockMove stockMove) {
        return stockMove.getStockMoveLineList() != null ? stockMove.getStockMoveLineList().stream().allMatch(stockMoveLine -> this.stockMoveLineService.computeFullySpreadOverLogisticalFormLinesFlag((StockMoveLine)((Object)stockMoveLine))) : true;
    }

    @Transactional(rollbackOn={Exception.class})
    protected void applyCancelReason(StockMove stockMove, CancelReason cancelReason) throws AxelorException {
        if (cancelReason == null) {
            throw new AxelorException((Model)((Object)stockMove), 1, I18n.get((String)"A cancel reason must be selected"));
        }
        if (!StockMove.class.getCanonicalName().equals(cancelReason.getApplicationType())) {
            throw new AxelorException((Model)((Object)stockMove), 5, I18n.get((String)"The type of cancel reason doesn't match with stock move"));
        }
        stockMove.setCancelReason(cancelReason);
    }

    @Override
    public void setAvailableStatus(StockMove stockMove) {
        List<StockMoveLine> stockMoveLineList = stockMove.getStockMoveLineList();
        for (StockMoveLine stockMoveLine : stockMoveLineList) {
            this.stockMoveLineService.setAvailableStatus(stockMoveLine);
        }
    }

    @Override
    public void checkExpirationDates(StockMove stockMove) throws AxelorException {
        if (stockMove.getToStockLocation().getTypeSelect() != 3) {
            this.stockMoveLineService.checkExpirationDates(stockMove);
        }
    }

    @Override
    @Transactional
    public void setPickingStockMoveEditDate(StockMove stockMove, String userType) {
        if ((!stockMove.getPickingIsEdited().booleanValue() || stockMove.getPickingEditDate() == null) && stockMove.getStatusSelect() == 2 && "Sender".equals(userType)) {
            stockMove.setPickingEditDate(LocalDate.now());
            stockMove.setPickingIsEdited(true);
        }
    }

    @Override
    public void setPickingStockMovesEditDate(List<Long> ids, String userType) {
        if (ids != null && "Sender".equals(userType)) {
            for (Long id : ids) {
                StockMove stockMove = (StockMove)((Object)this.stockMoveRepo.find(id));
                if (stockMove == null) continue;
                this.setPickingStockMoveEditDate(stockMove, userType);
            }
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateStocks(StockMove stockMove) throws AxelorException {
        if (stockMove.getStatusSelect() != 2) {
            return;
        }
        List savedStockMoveLineList = Optional.ofNullable(stockMove.getPlannedStockMoveLineList()).orElse(new ArrayList());
        List stockMoveLineList = Optional.ofNullable(stockMove.getStockMoveLineList()).orElse(new ArrayList());
        this.stockMoveLineService.updateLocations(stockMove.getFromStockLocation(), stockMove.getToStockLocation(), 2, 4, savedStockMoveLineList, stockMove.getEstimatedDate(), false);
        this.stockMoveLineService.updateLocations(stockMove.getFromStockLocation(), stockMove.getToStockLocation(), 1, 2, stockMoveLineList, stockMove.getEstimatedDate(), true);
        stockMove.clearPlannedStockMoveLineList();
        stockMoveLineList.forEach(stockMoveLine -> stockMove.addPlannedStockMoveLineListItem((StockMoveLine)((Object)((Object)this.stockMoveLineRepo.copy((Model)((Object)stockMoveLine), false)))));
    }

    @Override
    @Transactional
    public void updateProductNetMass(StockMove stockMove) throws AxelorException {
        if (stockMove.getStockMoveLineList() != null) {
            for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                if (stockMoveLine.getProduct() == null) continue;
                Product product = (Product)((Object)this.productRepository.find(stockMoveLine.getProduct().getId()));
                stockMoveLine.setNetMass(product.getNetMass());
                this.stockMoveLineRepo.save((Model)((Object)stockMoveLine));
            }
        }
    }
}

