/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.TrackingNumberConfiguration;
import com.axelor.apps.stock.db.repo.TrackingNumberRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;

public class TrackingNumberService {
    @Inject
    private SequenceService sequenceService;
    @Inject
    private TrackingNumberRepository trackingNumberRepo;

    @Transactional(rollbackOn={Exception.class})
    public TrackingNumber getTrackingNumber(Product product, BigDecimal sizeOfLot, Company company, LocalDate date) throws AxelorException {
        TrackingNumber trackingNumber = (TrackingNumber)((Object)this.trackingNumberRepo.all().filter("self.product = ?1 AND self.counter < ?2", new Object[]{product, sizeOfLot}).fetchOne());
        if (trackingNumber == null) {
            trackingNumber = (TrackingNumber)((Object)this.trackingNumberRepo.save((Model)((Object)this.createTrackingNumber(product, company, date))));
        }
        trackingNumber.setCounter(trackingNumber.getCounter().add(sizeOfLot));
        return trackingNumber;
    }

    public String getOrderMethod(TrackingNumberConfiguration trackingNumberConfiguration) {
        int autoTrackingNbrOrderSelect = -1;
        if (trackingNumberConfiguration.getIsSaleTrackingManaged().booleanValue()) {
            autoTrackingNbrOrderSelect = trackingNumberConfiguration.getSaleAutoTrackingNbrOrderSelect();
        } else if (trackingNumberConfiguration.getIsProductionTrackingManaged().booleanValue()) {
            autoTrackingNbrOrderSelect = trackingNumberConfiguration.getProductAutoTrackingNbrOrderSelect();
        }
        switch (autoTrackingNbrOrderSelect) {
            case 1: {
                return " ORDER BY self.trackingNumber ASC";
            }
            case 2: {
                return " ORDER BY self.trackingNumber DESC";
            }
        }
        return "";
    }

    public TrackingNumber createTrackingNumber(Product product, Company company, LocalDate date) throws AxelorException {
        String seq;
        Preconditions.checkNotNull((Object)((Object)product), (Object)I18n.get((String)"Product cannot be null."));
        Preconditions.checkNotNull((Object)((Object)company), (Object)I18n.get((String)"Company cannot be null."));
        Preconditions.checkNotNull((Object)date, (Object)I18n.get((String)"Please filled estimated delivery date"));
        TrackingNumber trackingNumber = new TrackingNumber();
        if (product.getIsPerishable().booleanValue()) {
            trackingNumber.setPerishableExpirationDate(date.plusMonths(product.getPerishableNbrOfMonths().intValue()));
        }
        if (product.getHasWarranty().booleanValue()) {
            trackingNumber.setWarrantyExpirationDate(date.plusMonths(product.getWarrantyNbrOfMonths().intValue()));
        }
        trackingNumber.setProduct(product);
        trackingNumber.setCounter(BigDecimal.ZERO);
        TrackingNumberConfiguration trackingNumberConfiguration = product.getTrackingNumberConfiguration();
        if (trackingNumberConfiguration.getSequence() == null) {
            throw new AxelorException((Model)((Object)product), 4, I18n.get((String)"There's no configured sequence for tracking number for the product %s:%s"), new Object[]{company.getName(), product.getCode()});
        }
        Sequence sequence = trackingNumberConfiguration.getSequence();
        do {
            seq = this.sequenceService.getSequenceNumber(sequence);
        } while (this.trackingNumberRepo.all().filter("self.product = ?1 AND self.trackingNumberSeq = ?2", new Object[]{product, seq}).count() != 0L);
        trackingNumber.setTrackingNumberSeq(seq);
        return trackingNumber;
    }
}

