/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.service.WeightedAveragePriceService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.google.inject.servlet.RequestScoped;
import java.math.BigDecimal;
import java.util.List;

@RequestScoped
public class WeightedAveragePriceServiceImpl
implements WeightedAveragePriceService {
    protected ProductRepository productRepo;
    protected AppBaseService appBaseService;

    @Inject
    public WeightedAveragePriceServiceImpl(ProductRepository productRepo, AppBaseService appBaseService) {
        this.productRepo = productRepo;
        this.appBaseService = appBaseService;
    }

    @Override
    @Transactional
    public void computeAvgPriceForProduct(Product product) {
        BigDecimal productAvgPrice = this.computeAvgPriceForCompany(product, null);
        if (productAvgPrice.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        product.setAvgPrice(productAvgPrice);
        if (product.getCostTypeSelect() == 3) {
            product.setCostPrice(productAvgPrice);
            if (product.getAutoUpdateSalePrice().booleanValue()) {
                ((ProductService)Beans.get(ProductService.class)).updateSalePrice(product);
            }
        }
        this.productRepo.save((Model)((Object)product));
    }

    @Override
    public BigDecimal computeAvgPriceForCompany(Product product, Company company) {
        Long productId = product.getId();
        String query = "SELECT new list(self.id, self.avgPrice, self.currentQty) FROM StockLocationLine as self WHERE self.product.id = " + productId + " AND self.stockLocation.typeSelect != " + 3;
        if (company != null) {
            query = query + " AND self.stockLocation.company = " + company.getId();
        }
        int scale = this.appBaseService.getNbDecimalDigitForUnitPrice();
        BigDecimal productAvgPrice = BigDecimal.ZERO;
        BigDecimal qtyTot = BigDecimal.ZERO;
        List results = JPA.em().createQuery(query).getResultList();
        if (results.isEmpty()) {
            return BigDecimal.ZERO;
        }
        for (List result : results) {
            BigDecimal avgPrice = (BigDecimal)result.get(1);
            BigDecimal qty = (BigDecimal)result.get(2);
            productAvgPrice = productAvgPrice.add(avgPrice.multiply(qty));
            qtyTot = qtyTot.add(qty);
        }
        if (qtyTot.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        productAvgPrice = productAvgPrice.divide(qtyTot, scale, 4);
        return productAvgPrice;
    }
}

