/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service.stockmove.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.service.stockmove.print.StockMovePrintService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class StockMovePrintServiceImpl
implements StockMovePrintService {
    @Override
    public String printStockMoves(List<Long> ids) throws IOException {
        final ArrayList printedStockMoves = new ArrayList();
        ModelTool.apply(StockMove.class, ids, (ThrowConsumer)new ThrowConsumer<StockMove>(){

            public void accept(StockMove stockMove) throws Exception {
                printedStockMoves.add(StockMovePrintServiceImpl.this.print(stockMove, "pdf"));
            }
        });
        String fileName = this.getStockMoveFilesName(true, "pdf");
        return PdfTool.mergePdfToFileLink(printedStockMoves, (String)fileName);
    }

    @Override
    public ReportSettings prepareReportSettings(StockMove stockMove, String format) throws AxelorException {
        if (stockMove.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on following stock moves: %s"), stockMove.getStockMoveSeq()), new Object[]{stockMove});
        }
        String locale = ReportSettings.getPrintingLocale((Partner)stockMove.getPartner());
        String title = this.getFileName(stockMove);
        ReportSettings reportSetting = ReportFactory.createReport((String)"StockMove.rptdesign", (String)(title + " - ${date}"));
        return reportSetting.addParam("StockMoveId", (Object)stockMove.getId()).addParam("Locale", (Object)locale).addParam("HeaderHeight", (Object)stockMove.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)stockMove.getPrintingSettings().getPdfFooterHeight()).addFormat(format);
    }

    @Override
    public File print(StockMove stockMove, String format) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(stockMove, format);
        return reportSettings.generate().getFile();
    }

    @Override
    public String printStockMove(StockMove stockMove, String format) throws AxelorException, IOException {
        String fileName = this.getStockMoveFilesName(false, "pdf");
        return PdfTool.getFileLinkFromPdfFile((File)this.print(stockMove, format), (String)fileName);
    }

    public String getStockMoveFilesName(boolean plural, String format) {
        return I18n.get((String)(plural ? "Stock moves" : "Stock move")) + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate().format(DateTimeFormatter.BASIC_ISO_DATE) + "." + format;
    }

    @Override
    public String getFileName(StockMove stockMove) {
        return I18n.get((String)"Stock Move") + " " + stockMove.getStockMoveSeq();
    }
}

