/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.apps.stock.service.stockmove.print.ConformityCertificatePrintService;
import com.axelor.apps.stock.service.stockmove.print.PickingStockMovePrintService;
import com.axelor.apps.stock.service.stockmove.print.StockMovePrintService;
import com.axelor.apps.tool.StringTool;
import com.axelor.common.ObjectUtils;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StockMoveController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void plan(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        try {
            ((StockMoveService)Beans.get(StockMoveService.class)).plan((StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void manageBackorder(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        response.setView(ActionView.define((String)I18n.get((String)"Manage backorder?")).model(StockMove.class.getName()).add("form", "popup-stock-move-backorder-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").context("_showRecord", (Object)stockMove.getId()).map());
    }

    public void realize(ActionRequest request, ActionResponse response) {
        StockMove stockMoveFromRequest = (StockMove)((Object)request.getContext().asType(StockMove.class));
        try {
            StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMoveFromRequest.getId()));
            String newSeq = ((StockMoveService)Beans.get(StockMoveService.class)).realize(stockMove);
            response.setReload(true);
            if (newSeq != null) {
                if (stockMove.getTypeSelect() == 3) {
                    response.setFlash(String.format(I18n.get((String)"An incoming partial stock move has been generated (%s)"), newSeq));
                } else if (stockMove.getTypeSelect() == 2) {
                    response.setFlash(String.format(I18n.get((String)"An outgoing partial stock move has been generated (%s)"), newSeq));
                } else {
                    response.setFlash(String.format(I18n.get((String)"A partial stock move has been generated (%s)"), newSeq));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void draft(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        try {
            ((StockMoveService)Beans.get(StockMoveService.class)).goBackToDraft((StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        try {
            ((StockMoveService)Beans.get(StockMoveService.class)).cancel((StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId())), stockMove.getCancelReason());
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printStockMove(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        try {
            String title;
            String fileLink;
            StockMovePrintService stockMovePrintService = (StockMovePrintService)Beans.get(StockMovePrintService.class);
            if (!ObjectUtils.isEmpty((Object)request.getContext().get((Object)"_ids"))) {
                List<Long> ids = ((List)context.get((Object)"_ids")).stream().filter(ObjectUtils::notEmpty).map(input -> Long.parseLong(input.toString())).collect(Collectors.toList());
                fileLink = stockMovePrintService.printStockMoves(ids);
                title = I18n.get((String)"Stock Moves");
            } else if (context.get((Object)"id") != null) {
                StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
                stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
                title = stockMovePrintService.getFileName(stockMove);
                fileLink = stockMovePrintService.printStockMove(stockMove, "pdf");
                this.logger.debug("Printing " + title);
            } else {
                throw new AxelorException(1, I18n.get((String)"Please select the stock move(s) to print"));
            }
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printPickingStockMove(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        String userType = (String)context.get((Object)"_userType");
        try {
            String title;
            String fileLink;
            PickingStockMovePrintService pickingstockMovePrintService = (PickingStockMovePrintService)Beans.get(PickingStockMovePrintService.class);
            if (!ObjectUtils.isEmpty((Object)context.get((Object)"_ids"))) {
                List<Long> ids = ((List)context.get((Object)"_ids")).stream().filter(ObjectUtils::notEmpty).map(input -> Long.parseLong(input.toString())).collect(Collectors.toList());
                fileLink = pickingstockMovePrintService.printStockMoves(ids, userType);
                title = I18n.get((String)"Stock Moves");
            } else if (context.get((Object)"id") != null) {
                StockMove stockMove = (StockMove)((Object)context.asType(StockMove.class));
                stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
                title = pickingstockMovePrintService.getFileName(stockMove);
                fileLink = pickingstockMovePrintService.printStockMove(stockMove, "pdf", userType);
                this.logger.debug("Printing " + title);
            } else {
                throw new AxelorException(1, I18n.get((String)"Please select the stock move(s) to print"));
            }
            response.setReload(true);
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printConformityCertificate(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        try {
            String title;
            String fileLink;
            ConformityCertificatePrintService conformityCertificatePrintService = (ConformityCertificatePrintService)Beans.get(ConformityCertificatePrintService.class);
            if (!ObjectUtils.isEmpty((Object)context.get((Object)"_ids"))) {
                List<Long> ids = ((List)context.get((Object)"_ids")).stream().filter(ObjectUtils::notEmpty).map(input -> Long.parseLong(input.toString())).collect(Collectors.toList());
                fileLink = conformityCertificatePrintService.printConformityCertificates(ids);
                title = I18n.get((String)"Conformity Certificates");
            } else if (context.get((Object)"id") != null) {
                StockMove stockMove = (StockMove)((Object)context.asType(StockMove.class));
                title = conformityCertificatePrintService.getFileName(stockMove);
                fileLink = conformityCertificatePrintService.printConformityCertificate(stockMove, "pdf");
                this.logger.debug("Printing " + title);
            } else {
                throw new AxelorException(1, I18n.get((String)"Please select the stock move(s) to print"));
            }
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void viewDirection(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        try {
            Map<String, Object> result = ((StockMoveService)Beans.get(StockMoveService.class)).viewDirection(stockMove);
            HashMap<String, Object> mapView = new HashMap<String, Object>();
            mapView.put("title", I18n.get((String)"Map"));
            mapView.put("resource", result.get("url"));
            mapView.put("viewType", "html");
            response.setView(mapView);
        }
        catch (Exception e) {
            response.setFlash(e.getLocalizedMessage());
        }
    }

    public void splitStockMoveLinesUnit(ActionRequest request, ActionResponse response) {
        List stockMoveLines = (List)request.getContext().get((Object)"stockMoveLineList");
        if (stockMoveLines == null) {
            response.setFlash(I18n.get((String)"No move lines to split"));
            return;
        }
        Boolean selected = ((StockMoveService)Beans.get(StockMoveService.class)).splitStockMoveLinesUnit(stockMoveLines, new BigDecimal(1));
        if (!selected.booleanValue()) {
            response.setFlash(I18n.get((String)"Please select lines to split"));
        }
        response.setReload(true);
        response.setCanClose(true);
    }

    public void splitStockMoveLinesSpecial(ActionRequest request, ActionResponse response) {
        try {
            List selectedStockMoveLineMapList = (List)request.getContext().get((Object)"stockMoveLineList");
            Map stockMoveMap = (Map)request.getContext().get((Object)"stockMove");
            if (selectedStockMoveLineMapList == null) {
                response.setFlash(I18n.get((String)"No move lines to split"));
                return;
            }
            ArrayList<StockMoveLine> stockMoveLineList = new ArrayList<StockMoveLine>();
            StockMoveLineRepository stockMoveLineRepo = (StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class));
            for (HashMap map : selectedStockMoveLineMapList) {
                StockMoveLine stockMoveLine = (StockMoveLine)((Object)Mapper.toBean(StockMoveLine.class, (Map)map));
                stockMoveLineList.add((StockMoveLine)((Object)stockMoveLineRepo.find(stockMoveLine.getId())));
            }
            if (stockMoveLineList.isEmpty()) {
                response.setFlash(I18n.get((String)"Please select lines to split"));
                return;
            }
            BigDecimal splitQty = new BigDecimal(request.getContext().get((Object)"splitQty").toString());
            if (splitQty == null || splitQty.compareTo(BigDecimal.ZERO) < 1) {
                response.setFlash(I18n.get((String)"Please enter a valid split quantity"));
                return;
            }
            StockMove stockMove = (StockMove)((Object)Mapper.toBean(StockMove.class, (Map)stockMoveMap));
            stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
            ((StockMoveService)Beans.get(StockMoveService.class)).splitStockMoveLinesSpecial(stockMove, stockMoveLineList, splitQty);
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void shipReciveAllProducts(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        ((StockMoveService)Beans.get(StockMoveService.class)).copyQtyToRealQty((StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId())));
        response.setReload(true);
    }

    public void generateReversion(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        try {
            Optional<StockMove> reversion = ((StockMoveService)Beans.get(StockMoveService.class)).generateReversion((StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId())));
            if (reversion.isPresent()) {
                response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(reversion.get().getId())).map());
            } else {
                response.setFlash(I18n.get((String)"No reversion generated"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void splitInto2(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        List<StockMoveLine> modifiedStockMoveLineList = stockMove.getStockMoveLineList();
        stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
        try {
            StockMove newStockMove = ((StockMoveService)Beans.get(StockMoveService.class)).splitInto2(stockMove, modifiedStockMoveLineList);
            if (newStockMove == null) {
                response.setFlash(I18n.get((String)"No new stock move was generated"));
            } else {
                response.setCanClose(true);
                response.setView(ActionView.define((String)"Stock move").model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("forceEdit", "true").context("_showRecord", (Object)String.valueOf(newStockMove.getId())).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void changeConformityStockMove(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        response.setValue("stockMoveLineList", ((StockMoveService)Beans.get(StockMoveService.class)).changeConformityStockMove(stockMove));
    }

    public void changeConformityStockMoveLine(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        response.setValue("conformitySelect", (Object)((StockMoveService)Beans.get(StockMoveService.class)).changeConformityStockMoveLine(stockMove));
    }

    public void compute(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        response.setValue("exTaxTotal", (Object)((StockMoveToolService)Beans.get(StockMoveToolService.class)).compute(stockMove));
    }

    public void openStockPerDay(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Long locationId = Long.parseLong(((Map)context.get((Object)"stockLocation")).get("id").toString());
        LocalDate fromDate = LocalDate.parse(context.get((Object)"stockFromDate").toString());
        LocalDate toDate = LocalDate.parse(context.get((Object)"stockToDate").toString());
        Collection products = (Collection)context.get((Object)"productSet");
        String domain = null;
        List<Object> productIds = null;
        if (products != null && !products.isEmpty()) {
            productIds = Arrays.asList(products.stream().map(p -> p.get("id")).toArray());
            domain = "self.id in (:productIds)";
        }
        response.setView(ActionView.define((String)I18n.get((String)"Stocks")).model(Product.class.getName()).add("cards", "stock-product-cards").add("grid", "stock-product-grid").add("form", "stock-product-form").domain(domain).context("fromStockWizard", (Object)true).context("productIds", productIds).context("stockFromDate", (Object)fromDate).context("stockToDate", (Object)toDate).context("locationId", (Object)locationId).map());
    }

    public void fillAddressesStr(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        ((StockMoveToolService)Beans.get(StockMoveToolService.class)).computeAddressStr(stockMove);
        response.setValues((Object)stockMove);
    }

    public void filterPrintingSettings(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        List printingSettingsList = ((TradingNameService)Beans.get(TradingNameService.class)).getPrintingSettingsList(stockMove.getTradingName(), stockMove.getCompany());
        String domain = String.format("self.id IN (%s)", !printingSettingsList.isEmpty() ? StringTool.getIdListString((Collection)printingSettingsList) : "0");
        response.setAttr("printingSettings", "domain", (Object)domain);
    }

    public void fillDefaultPrintingSettings(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            response.setValue("printingSettings", (Object)((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(stockMove.getTradingName(), stockMove.getCompany()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setAvailableStatus(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        ((StockMoveService)Beans.get(StockMoveService.class)).setAvailableStatus(stockMove);
        response.setValue("stockMoveLineList", stockMove.getStockMoveLineList());
    }

    public void updateMoveLineFilterOnAvailableproduct(ActionRequest request, ActionResponse response) {
        StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
        if (stockMove.getStockMoveLineList() != null) {
            for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                stockMoveLine.setFilterOnAvailableProducts(stockMove.getFilterOnAvailableProducts());
            }
            response.setValue("stockMoveLineList", stockMove.getStockMoveLineList());
        }
    }

    public void updateStocks(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            ((StockMoveService)Beans.get(StockMoveService.class)).updateStocks((StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void refreshProductNetMass(ActionRequest request, ActionResponse response) {
        try {
            StockMove stockMove = (StockMove)((Object)request.getContext().asType(StockMove.class));
            ((StockMoveService)Beans.get(StockMoveService.class)).updateProductNetMass(stockMove);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

