/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.ResponseMessageType;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

@Singleton
public class StockMoveLineController {
    public void compute(ActionRequest request, ActionResponse response) throws AxelorException {
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        StockMove stockMove = stockMoveLine.getStockMove();
        if (stockMove == null) {
            Context parentContext = request.getContext().getParent();
            Context superParentContext = parentContext.getParent();
            if (parentContext.getContextClass().equals(StockMove.class)) {
                stockMove = (StockMove)((Object)parentContext.asType(StockMove.class));
            } else if (superParentContext.getContextClass().equals(StockMove.class)) {
                stockMove = (StockMove)((Object)superParentContext.asType(StockMove.class));
            } else {
                return;
            }
        }
        stockMoveLine = ((StockMoveLineService)Beans.get(StockMoveLineService.class)).compute(stockMoveLine, stockMove);
        response.setValue("unitPriceUntaxed", (Object)stockMoveLine.getUnitPriceUntaxed());
        response.setValue("unitPriceTaxed", (Object)stockMoveLine.getUnitPriceTaxed());
        response.setValue("companyUnitPriceUntaxed", (Object)stockMoveLine.getCompanyUnitPriceUntaxed());
    }

    public void setProductInfo(ActionRequest request, ActionResponse response) {
        try {
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
            StockMove stockMove = stockMoveLine.getStockMove();
            if (stockMove == null) {
                stockMove = (StockMove)((Object)request.getContext().getParent().asType(StockMove.class));
            }
            if (stockMoveLine.getProduct() == null) {
                stockMoveLine = new StockMoveLine();
                response.setValues((Object)Mapper.toMap((Object)((Object)stockMoveLine)));
                return;
            }
            ((StockMoveLineService)Beans.get(StockMoveLineService.class)).setProductInfo(stockMove, stockMoveLine, stockMove.getCompany());
            response.setValues((Object)stockMoveLine);
        }
        catch (Exception e) {
            StockMoveLine stockMoveLine = new StockMoveLine();
            response.setValues((Object)Mapper.toMap((Object)((Object)stockMoveLine)));
            TraceBackService.trace((ActionResponse)response, (Throwable)e, (ResponseMessageType)ResponseMessageType.INFORMATION);
        }
    }

    public void emptyLine(ActionRequest request, ActionResponse response) {
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        if (stockMoveLine.getLineTypeSelect() != 0) {
            Map newStockMoveLine = Mapper.toMap((Object)((Object)new StockMoveLine()));
            newStockMoveLine.put("qty", BigDecimal.ZERO);
            newStockMoveLine.put("id", stockMoveLine.getId());
            newStockMoveLine.put("version", stockMoveLine.getVersion());
            newStockMoveLine.put("lineTypeSelect", stockMoveLine.getLineTypeSelect());
            response.setValues((Object)newStockMoveLine);
        }
    }

    public void splitStockMoveLineByTrackingNumber(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        if (context.get((Object)"trackingNumbers") == null) {
            response.setAlert(I18n.get((String)"No Tracking Numbers Added"));
        } else {
            LinkedHashMap stockMoveLineMap = (LinkedHashMap)context.get((Object)"_stockMoveLine");
            Integer stockMoveLineId = (Integer)stockMoveLineMap.get("id");
            StockMoveLine stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(new Long(stockMoveLineId.intValue())));
            ArrayList trackingNumbers = (ArrayList)context.get((Object)"trackingNumbers");
            ((StockMoveLineService)Beans.get(StockMoveLineService.class)).splitStockMoveLineByTrackingNumber(stockMoveLine, trackingNumbers);
            response.setCanClose(true);
        }
    }

    public void openTrackNumberWizard(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)context.asType(StockMoveLine.class));
        StockMove stockMove = null;
        if (context.getParent() != null && context.getParent().get((Object)"_model").equals("com.axelor.apps.stock.db.StockMove")) {
            stockMove = (StockMove)((Object)context.getParent().asType(StockMove.class));
        } else if (stockMoveLine.getStockMove() != null && stockMoveLine.getStockMove().getId() != null) {
            stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMoveLine.getStockMove().getId()));
        }
        boolean _hasWarranty = false;
        boolean _isPerishable = false;
        if (stockMoveLine.getProduct() != null) {
            _hasWarranty = stockMoveLine.getProduct().getHasWarranty();
            _isPerishable = stockMoveLine.getProduct().getIsPerishable();
        }
        response.setView(ActionView.define((String)I18n.get((String)"Enter tracking numbers")).model(Wizard.class.getName()).add("form", "stock-move-line-track-number-wizard-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("width", "large").param("popup-save", "false").context("_stockMove", (Object)stockMove).context("_stockMoveLine", (Object)stockMoveLine).context("_hasWarranty", (Object)_hasWarranty).context("_isPerishable", (Object)_isPerishable).map());
    }

    public void computeAvailableQty(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        StockMoveLine stockMoveLineContext = (StockMoveLine)((Object)context.asType(StockMoveLine.class));
        StockMoveLine stockMoveLine = null;
        if (stockMoveLineContext.getId() != null) {
            stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(stockMoveLineContext.getId()));
            if (stockMoveLineContext.getProduct() != null && !stockMoveLineContext.getProduct().equals((Object)stockMoveLine.getProduct())) {
                stockMoveLine = stockMoveLineContext;
            }
        } else {
            stockMoveLine = stockMoveLineContext;
        }
        StockLocation stockLocation = null;
        if (context.get((Object)"_parent") != null && ((Map)context.get((Object)"_parent")).get("fromStockLocation") != null) {
            Map _parent = (Map)context.get((Object)"_parent");
            stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(Long.parseLong(((Map)_parent.get("fromStockLocation")).get("id").toString())));
        } else if (stockMoveLine.getStockMove() != null) {
            stockLocation = stockMoveLine.getStockMove().getFromStockLocation();
        }
        if (stockLocation != null) {
            ((StockMoveLineService)Beans.get(StockMoveLineService.class)).updateAvailableQty(stockMoveLine, stockLocation);
            response.setValue("$availableQty", (Object)stockMoveLine.getAvailableQty());
            response.setValue("$availableQtyForProduct", (Object)stockMoveLine.getAvailableQtyForProduct());
        }
    }

    public void setProductDomain(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)context.asType(StockMoveLine.class));
        StockMove stockMove = context.getParent() != null ? (StockMove)((Object)context.getParent().asType(StockMove.class)) : stockMoveLine.getStockMove();
        String domain = ((StockMoveLineService)Beans.get(StockMoveLineService.class)).createDomainForProduct(stockMoveLine, stockMove);
        response.setAttr("product", "domain", (Object)domain);
    }

    public void setAvailableStatus(ActionRequest request, ActionResponse response) {
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)request.getContext().asType(StockMoveLine.class));
        ((StockMoveLineService)Beans.get(StockMoveLineService.class)).setAvailableStatus(stockMoveLine);
        response.setValue("availableStatus", (Object)stockMoveLine.getAvailableStatus());
        response.setValue("availableStatusSelect", (Object)stockMoveLine.getAvailableStatusSelect());
    }

    public void displayAvailableTrackingNumber(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        LinkedHashMap stockMoveLineMap = (LinkedHashMap)context.get((Object)"_stockMoveLine");
        LinkedHashMap stockMoveMap = (LinkedHashMap)context.get((Object)"_stockMove");
        Integer stockMoveLineId = (Integer)stockMoveLineMap.get("id");
        Integer stockMoveId = (Integer)stockMoveMap.get("id");
        StockMoveLine stockMoveLine = (StockMoveLine)((Object)((StockMoveLineRepository)((Object)Beans.get(StockMoveLineRepository.class))).find(new Long(stockMoveLineId.intValue())));
        StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(new Long(stockMoveId.intValue())));
        if (stockMoveLine == null || stockMoveLine.getProduct() == null || stockMove == null || stockMove.getFromStockLocation() == null) {
            return;
        }
        List<TrackingNumber> trackingNumberList = ((StockMoveLineService)Beans.get(StockMoveLineService.class)).getAvailableTrackingNumbers(stockMoveLine, stockMove);
        if (trackingNumberList == null || trackingNumberList.isEmpty()) {
            return;
        }
        TreeSet<Map> trackingNumbers = new TreeSet<Map>(Comparator.comparing(m -> (String)m.get("trackingNumberSeq")));
        StockLocationLineService stockLocationLineService = (StockLocationLineService)Beans.get(StockLocationLineService.class);
        for (TrackingNumber trackingNumber : trackingNumberList) {
            StockLocationLine detailStockLocationLine = stockLocationLineService.getDetailLocationLine(stockMove.getFromStockLocation(), stockMoveLine.getProduct(), trackingNumber);
            BigDecimal availableQty = detailStockLocationLine != null ? detailStockLocationLine.getCurrentQty() : BigDecimal.ZERO;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("trackingNumber", (Object)trackingNumber);
            map.put("trackingNumberSeq", trackingNumber.getTrackingNumberSeq());
            map.put("counter", BigDecimal.ZERO);
            map.put("warrantyExpirationDate", trackingNumber.getWarrantyExpirationDate());
            map.put("perishableExpirationDate", trackingNumber.getPerishableExpirationDate());
            map.put("$availableQty", availableQty);
            map.put("$moveTypeSelect", stockMove.getTypeSelect());
            trackingNumbers.add(map);
        }
        response.setValue("$trackingNumbers", trackingNumbers);
    }
}

