/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.InventoryLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.TrackingNumberConfiguration;
import com.axelor.apps.stock.db.repo.InventoryLineRepository;
import com.axelor.apps.stock.service.InventoryLineService;
import com.axelor.apps.stock.service.TrackingNumberService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.Map;

public class ImportInventoryLine {
    @Inject
    private InventoryLineRepository inventoryLineRepo;
    @Inject
    private InventoryLineService inventoryLineService;
    @Inject
    private TrackingNumberService trackingNumberService;
    @Inject
    private AppBaseService appBaseService;

    @Transactional(rollbackOn={Exception.class})
    public Object importInventoryLine(Object bean, Map<String, Object> values) throws AxelorException {
        assert (bean instanceof InventoryLine);
        InventoryLine inventoryLine = (InventoryLine)((Object)bean);
        TrackingNumberConfiguration trackingNumberConfig = inventoryLine.getProduct().getTrackingNumberConfiguration();
        BigDecimal qtyByTracking = BigDecimal.ONE;
        BigDecimal realQtyRemaning = inventoryLine.getRealQty();
        this.inventoryLineService.compute(inventoryLine, inventoryLine.getInventory());
        if (trackingNumberConfig != null) {
            qtyByTracking = trackingNumberConfig.getGenerateProductionAutoTrackingNbr() != false ? trackingNumberConfig.getProductionQtyByTracking() : (trackingNumberConfig.getGeneratePurchaseAutoTrackingNbr() != false ? trackingNumberConfig.getPurchaseQtyByTracking() : trackingNumberConfig.getSaleQtyByTracking());
            for (int i = 0; i < inventoryLine.getRealQty().intValue(); i += qtyByTracking.intValue()) {
                TrackingNumber trackingNumber = this.trackingNumberService.createTrackingNumber(inventoryLine.getProduct(), inventoryLine.getInventory().getStockLocation().getCompany(), this.appBaseService.getTodayDate());
                if (realQtyRemaning.compareTo(qtyByTracking) < 0) {
                    trackingNumber.setCounter(realQtyRemaning);
                } else {
                    trackingNumber.setCounter(qtyByTracking);
                }
                InventoryLine inventoryLineNew = this.inventoryLineService.createInventoryLine(inventoryLine.getInventory(), inventoryLine.getProduct(), inventoryLine.getCurrentQty(), inventoryLine.getRack(), trackingNumber);
                inventoryLineNew.setUnit(inventoryLine.getProduct().getUnit());
                if (realQtyRemaning.compareTo(qtyByTracking) < 0) {
                    inventoryLineNew.setRealQty(realQtyRemaning);
                } else {
                    inventoryLineNew.setRealQty(qtyByTracking);
                    realQtyRemaning = realQtyRemaning.subtract(qtyByTracking);
                }
                this.inventoryLineRepo.save((Model)((Object)inventoryLineNew));
            }
            return null;
        }
        return bean;
    }
}

