/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectCollection;
import net.fortuna.ical4j.connector.ObjectStore;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.DavClient;
import net.fortuna.ical4j.connector.dav.DavClientFactory;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.connector.dav.enums.SupportedFeature;
import net.fortuna.ical4j.util.Configurator;

public abstract class AbstractDavObjectStore<C extends ObjectCollection<?>>
implements ObjectStore<C> {
    private final DavClientFactory clientFactory;
    private DavClient davClient;
    private String username;
    private String bearerAuth;
    private final URL rootUrl;
    private ArrayList<SupportedFeature> supportedFeatures;
    protected final PathResolver pathResolver;

    public AbstractDavObjectStore(URL url, PathResolver pathResolver) {
        this.rootUrl = url;
        this.pathResolver = pathResolver;
        this.clientFactory = new DavClientFactory("true".equals(Configurator.getProperty((String)"ical4j.connector.dav.preemptiveauth").orElse((Object)"false")));
    }

    public final String getPath() {
        return this.pathResolver == null ? this.rootUrl.getFile() : this.pathResolver.getUserPath(this.getUserName());
    }

    @Override
    public final boolean connect() throws ObjectStoreException {
        String principalPath = this.pathResolver.getPrincipalPath(this.getUserName());
        String userPath = this.pathResolver.getUserPath(this.getUserName());
        this.davClient = this.clientFactory.newInstance(this.rootUrl, principalPath, userPath);
        this.davClient.begin();
        return true;
    }

    public final boolean connect(String bearerAuth) throws ObjectStoreException {
        try {
            this.davClient = this.clientFactory.newInstance(this.rootUrl, this.rootUrl.getFile(), this.rootUrl.getFile());
            this.davClient.begin(bearerAuth);
            this.bearerAuth = bearerAuth;
        }
        catch (IOException ioe) {
            throw new ObjectStoreException(ioe);
        }
        catch (FailedOperationException foe) {
            throw new ObjectStoreException(foe);
        }
        return true;
    }

    @Override
    public final boolean connect(String username, char[] password) throws ObjectStoreException {
        try {
            this.username = username;
            String principalPath = this.pathResolver.getPrincipalPath(username);
            String userPath = this.pathResolver.getUserPath(username);
            this.davClient = this.clientFactory.newInstance(this.rootUrl, principalPath, userPath);
            this.supportedFeatures = this.davClient.begin(username, password);
        }
        catch (IOException ioe) {
            throw new ObjectStoreException(ioe);
        }
        catch (FailedOperationException foe) {
            throw new ObjectStoreException(foe);
        }
        return true;
    }

    @Override
    public final void disconnect() {
        this.davClient = null;
        this.username = null;
    }

    @Override
    public final boolean isConnected() {
        return this.davClient != null;
    }

    protected String getUserName() {
        return this.username;
    }

    public DavClient getClient() {
        return this.davClient;
    }

    public URL getHostURL() {
        return this.rootUrl;
    }

    public ArrayList<SupportedFeature> supportedFeatures() {
        return this.supportedFeatures;
    }

    public boolean isSupportCalendarProxy() {
        return this.supportedFeatures.contains((Object)SupportedFeature.CALENDAR_PROXY);
    }
}

