/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectCollection;
import net.fortuna.ical4j.connector.dav.CalDavCalendarStore;
import net.fortuna.ical4j.connector.dav.CalDavConstants;
import net.fortuna.ical4j.connector.dav.MkCalendar;
import net.fortuna.ical4j.connector.dav.method.GetMethod;
import net.fortuna.ical4j.connector.dav.method.MkCalendarMethod;
import net.fortuna.ical4j.connector.dav.method.PutMethod;
import net.fortuna.ical4j.connector.dav.method.ReportMethod;
import net.fortuna.ical4j.connector.dav.property.BaseDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.ICalPropertyName;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ConstraintViolationException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.util.Calendars;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.security.report.PrincipalMatchReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CalDavCalendarCollection
extends AbstractDavObjectCollection<Calendar>
implements CalendarCollection {
    CalDavCalendarCollection(CalDavCalendarStore calDavCalendarStore, String id) {
        this(calDavCalendarStore, id, null, null);
    }

    CalDavCalendarCollection(CalDavCalendarStore calDavCalendarStore, String id, String displayName, String description) {
        super(calDavCalendarStore, id);
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)displayName));
        this.properties.add((DavProperty)new DefaultDavProperty(CalDavPropertyName.CALENDAR_DESCRIPTION, (Object)description));
    }

    CalDavCalendarCollection(CalDavCalendarStore calDavCalendarStore, String id, DavPropertySet _properties) {
        this(calDavCalendarStore, id, null, null);
        this.properties = _properties;
    }

    final void create() throws IOException, ObjectStoreException {
        MkCalendarMethod mkCalendarMethod = new MkCalendarMethod(this.getPath());
        MkCalendar mkcalendar = new MkCalendar();
        mkcalendar.setProperties(this.properties);
        System.out.println("properties: " + this.properties.getContentSize());
        mkCalendarMethod.setRequestBody(mkcalendar);
        this.getStore().getClient().execute((HttpMethodBase)mkCalendarMethod);
        if (!mkCalendarMethod.succeeded()) {
            throw new ObjectStoreException(mkCalendarMethod.getStatusCode() + ": " + mkCalendarMethod.getStatusText());
        }
    }

    @Deprecated
    public Calendar[] getCalendars() {
        return this.getComponentsByType("VEVENT");
    }

    public Calendar[] getEvents() {
        return this.getComponentsByType("VEVENT");
    }

    public Calendar[] getTasks() {
        return this.getComponentsByType("VTODO");
    }

    public Calendar[] getComponentsByType(String componentType) {
        try {
            DavPropertyNameSet properties = new DavPropertyNameSet();
            properties.add(DavPropertyName.GETETAG);
            properties.add(CalDavPropertyName.CALENDAR_DATA);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element filter = DomUtil.createElement((Document)document, (String)"filter", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
            Element calFilter = DomUtil.createElement((Document)document, (String)"comp-filter", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
            calFilter.setAttribute("name", "VCALENDAR");
            Element eventFilter = DomUtil.createElement((Document)document, (String)"comp-filter", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
            eventFilter.setAttribute("name", componentType);
            calFilter.appendChild(eventFilter);
            filter.appendChild(calFilter);
            ReportInfo info = new ReportInfo(ReportMethod.CALENDAR_QUERY, 1, properties);
            info.setContentElement(filter);
            ReportMethod method = new ReportMethod(this.getPath(), info);
            this.getStore().getClient().execute((HttpMethodBase)method);
            if (method.getStatusCode() == 207) {
                return method.getCalendars();
            }
            return new Calendar[0];
        }
        catch (IOException | ParserConfigurationException | ParserException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDescription() {
        try {
            return this.getProperty(CalDavPropertyName.CALENDAR_DESCRIPTION, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getProperty(DavPropertyName.DISPLAYNAME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer getMaxAttendeesPerInstance() {
        try {
            return this.getProperty(CalDavPropertyName.MAX_ATTENDEES_PER_INSTANCE, Integer.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMaxDateTime() {
        try {
            return this.getProperty(CalDavPropertyName.MAX_DATE_TIME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer getMaxInstances() {
        try {
            return this.getProperty(CalDavPropertyName.MAX_INSTANCES, Integer.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getMaxResourceSize() {
        try {
            Long size = this.getProperty(CalDavPropertyName.MAX_RESOURCE_SIZE, Long.class);
            if (size != null) {
                return size;
            }
            return 0L;
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMinDateTime() {
        try {
            return this.getProperty(CalDavPropertyName.MIN_DATE_TIME, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] getSupportedComponentTypes() {
        ArrayList<String> supportedComponents = new ArrayList<String>();
        try {
            ArrayList supportedCalCompSetProp = this.getProperty(CalDavPropertyName.SUPPORTED_CALENDAR_COMPONENT_SET, ArrayList.class);
            if (supportedCalCompSetProp != null) {
                for (Node child : supportedCalCompSetProp) {
                    Node nameNode;
                    if (!(child instanceof Element) || (nameNode = child.getAttributes().getNamedItem("name")) == null) continue;
                    supportedComponents.add(nameNode.getTextContent());
                }
            }
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
        return supportedComponents.toArray(new String[supportedComponents.size()]);
    }

    @Override
    public Calendar getTimeZone() {
        try {
            String calTimezoneProp = this.getProperty(CalDavPropertyName.CALENDAR_TIMEZONE, String.class);
            if (calTimezoneProp != null) {
                CalendarBuilder builder = new CalendarBuilder();
                return builder.build((Reader)new StringReader(calTimezoneProp));
            }
            return new Calendar();
        }
        catch (IOException | ObjectStoreException | ParserException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public String getColor() {
        try {
            return this.getProperty(ICalPropertyName.CALENDAR_COLOR, String.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    public int getOrder() {
        try {
            return this.getProperty(ICalPropertyName.CALENDAR_ORDER, Integer.class);
        }
        catch (IOException | ObjectStoreException | DavException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        this.writeCalendarOnServer(calendar, true);
    }

    public void addCalendar(String uri, Calendar calendar) throws ObjectStoreException {
        this.writeCalendarOnServer(uri, calendar, true);
    }

    public void updateCalendar(Calendar calendar) throws ObjectStoreException, ConstraintViolationException {
        this.writeCalendarOnServer(calendar, false);
    }

    public void updateCalendar(String uri, Calendar calendar) throws ObjectStoreException {
        this.writeCalendarOnServer(uri, calendar, false);
    }

    public void writeCalendarOnServer(Calendar calendar, boolean isNew) throws ObjectStoreException, ConstraintViolationException {
        Uid uid = Calendars.getUid((Calendar)calendar);
        this.writeCalendarOnServer(this.defaultUriFromUid(uid.getValue()), calendar, isNew);
    }

    public void writeCalendarOnServer(String uri, Calendar calendar, boolean isNew) throws ObjectStoreException {
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        PutMethod putMethod = new PutMethod(path + uri);
        if (isNew) {
            putMethod.addRequestHeader("If-None-Match", "*");
        } else {
            putMethod.addRequestHeader("If-Match", "*");
        }
        try {
            putMethod.setCalendar(calendar);
        }
        catch (Exception e) {
            throw new ObjectStoreException("Invalid calendar", e);
        }
        try {
            this.getStore().getClient().execute((HttpMethodBase)putMethod);
            if (putMethod.getStatusCode() != 201 && putMethod.getStatusCode() != 204) {
                throw new ObjectStoreException("Error creating calendar on server: " + putMethod.getStatusLine());
            }
        }
        catch (IOException ioe) {
            throw new ObjectStoreException("Error creating calendar on server", ioe);
        }
    }

    @Override
    public Calendar getCalendar(String uid) {
        return this.getCalendarFromUri(this.defaultUriFromUid(uid));
    }

    public Calendar getCalendarFromUri(String uri) {
        String path = this.getPath();
        if (!path.endsWith("/")) {
            path = path.concat("/");
        }
        GetMethod method = new GetMethod(path + uri);
        try {
            this.getStore().getClient().execute((HttpMethodBase)method);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (method.getStatusCode() == 200) {
            try {
                return method.getCalendar();
            }
            catch (IOException | ParserException e) {
                throw new RuntimeException(e);
            }
        }
        if (method.getStatusCode() == 404) {
            return null;
        }
        return null;
    }

    @Override
    public Calendar removeCalendar(String uid) throws FailedOperationException, ObjectStoreException {
        return this.removeCalendarFromUri(this.defaultUriFromUid(uid));
    }

    public Calendar removeCalendarFromUri(String uri) throws FailedOperationException, ObjectStoreException {
        Calendar calendar = this.getCalendarFromUri(uri);
        DeleteMethod deleteMethod = new DeleteMethod(this.getPath() + "/" + uri);
        try {
            this.getStore().getClient().execute((HttpMethodBase)deleteMethod);
        }
        catch (IOException e) {
            throw new ObjectStoreException(e);
        }
        if (!deleteMethod.succeeded()) {
            throw new FailedOperationException(deleteMethod.getStatusLine().toString());
        }
        return calendar;
    }

    @Override
    public final void merge(Calendar calendar) throws FailedOperationException, ObjectStoreException {
        try {
            Calendar[] uidCalendars = Calendars.split((Calendar)calendar);
            for (int i = 0; i < uidCalendars.length; ++i) {
                this.addCalendar(uidCalendars[i]);
            }
        }
        catch (ConstraintViolationException cve) {
            throw new FailedOperationException("Invalid calendar format", cve);
        }
    }

    @Override
    public Calendar export() throws ObjectStoreException {
        throw new UnsupportedOperationException("not implemented");
    }

    public Calendar[] getComponents() throws ObjectStoreException {
        return this.getComponentsByType("VEVENT");
    }

    public Calendar[] getEventsForTimePeriod(DateTime startTime, DateTime endTime) throws IOException, DavException, ParserConfigurationException, ParserException {
        DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        BUILDER_FACTORY.setNamespaceAware(true);
        BUILDER_FACTORY.setIgnoringComments(true);
        BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        BUILDER_FACTORY.setCoalescing(true);
        Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
        Element calData = DomUtil.createElement((Document)document, (String)"calendar-data", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        Element calFilter = DomUtil.createElement((Document)document, (String)"comp-filter", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        calFilter.setAttribute("name", "VCALENDAR");
        Element eventFilter = DomUtil.createElement((Document)document, (String)"comp-filter", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        eventFilter.setAttribute("name", "VEVENT");
        Element timeRange = DomUtil.createElement((Document)document, (String)"time-range", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        timeRange.setAttribute("start", startTime.toString());
        timeRange.setAttribute("end", endTime.toString());
        eventFilter.appendChild(timeRange);
        calFilter.appendChild(eventFilter);
        return this.getObjectsByFilter(calFilter, calData);
    }

    public Calendar[] getObjectsByFilter(Element filter, Element calData) throws IOException, DavException, ParserConfigurationException, ParserException {
        ArrayList<Calendar> events = new ArrayList<Calendar>();
        ReportInfo rinfo = new ReportInfo(ReportType.register((String)"calendar-query", (Namespace)CalDavConstants.CALDAV_NAMESPACE, PrincipalMatchReport.class), 1);
        DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
        BUILDER_FACTORY.setNamespaceAware(true);
        BUILDER_FACTORY.setIgnoringComments(true);
        BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        BUILDER_FACTORY.setCoalescing(true);
        Document document = BUILDER_FACTORY.newDocumentBuilder().newDocument();
        Element property = DomUtil.createElement((Document)document, (String)"prop", (Namespace)CalDavConstants.NAMESPACE);
        property.appendChild(DomUtil.createElement((Document)document, (String)"getetag", (Namespace)CalDavConstants.NAMESPACE));
        Node importedCalData = document.importNode(calData, true);
        property.appendChild(importedCalData);
        document.appendChild(property);
        rinfo.setContentElement(property);
        Element parentFilter = DomUtil.createElement((Document)document, (String)"filter", (Namespace)CalDavConstants.CALDAV_NAMESPACE);
        rinfo.setContentElement(parentFilter);
        Node importedFilter = document.importNode(filter, true);
        parentFilter.appendChild(importedFilter);
        ReportMethod method = new ReportMethod(this.getPath(), rinfo);
        this.getStore().getClient().execute((HttpMethodBase)method);
        MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] responses = multiStatus.getResponses();
        for (int i = 0; i < responses.length; ++i) {
            for (int j = 0; j < responses[i].getStatus().length; ++j) {
                Status status = responses[i].getStatus()[j];
                DavPropertyIterator iNames = responses[i].getProperties(status.getStatusCode()).iterator();
                while (iNames.hasNext()) {
                    DavProperty name = iNames.nextProperty();
                    if (!(name.getValue() instanceof String) || !name.getName().getNamespace().equals((Object)CalDavConstants.CALDAV_NAMESPACE) || !name.getName().getName().equals("calendar-data")) continue;
                    StringReader sin = new StringReader((String)name.getValue());
                    CalendarBuilder builder = new CalendarBuilder();
                    Calendar calendar = builder.build((Reader)sin);
                    events.add(calendar);
                }
            }
        }
        return events.toArray(new Calendar[events.size()]);
    }

    public Calendar[] getObjectsByMultiget(ArrayList<URI> hrefs, Element calData) throws IOException, DavException, ParserConfigurationException, ParserException {
        return new Calendar[0];
    }

    public Calendar[] doFreeBusyQuery() {
        return new Calendar[0];
    }

    public static final DavPropertyNameSet propertiesForFetch() {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(BaseDavPropertyName.QUOTA_AVAILABLE_BYTES);
        principalsProps.add(BaseDavPropertyName.QUOTA_USED_BYTES);
        principalsProps.add(BaseDavPropertyName.CURRENT_USER_PRIVILEGE_SET);
        principalsProps.add(BaseDavPropertyName.PROP);
        principalsProps.add(BaseDavPropertyName.RESOURCETYPE);
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        principalsProps.add(SecurityConstants.OWNER);
        principalsProps.add(CalDavPropertyName.CALENDAR_DESCRIPTION);
        principalsProps.add(CalDavPropertyName.SUPPORTED_CALENDAR_COMPONENT_SET);
        principalsProps.add(CalDavPropertyName.FREE_BUSY_SET);
        principalsProps.add(CalDavPropertyName.SCHEDULE_CALENDAR_TRANSP);
        principalsProps.add(CalDavPropertyName.SCHEDULE_DEFAULT_CALENDAR_URL);
        principalsProps.add(CalDavPropertyName.CALENDAR_TIMEZONE);
        principalsProps.add(CalDavPropertyName.SUPPORTED_CALENDAR_DATA);
        principalsProps.add(CalDavPropertyName.MAX_ATTENDEES_PER_INSTANCE);
        principalsProps.add(CalDavPropertyName.MAX_DATE_TIME);
        principalsProps.add(CalDavPropertyName.MIN_DATE_TIME);
        principalsProps.add(CalDavPropertyName.MAX_INSTANCES);
        principalsProps.add(CalDavPropertyName.MAX_RESOURCE_SIZE);
        principalsProps.add(CSDavPropertyName.XMPP_SERVER);
        principalsProps.add(CSDavPropertyName.XMPP_URI);
        principalsProps.add(CSDavPropertyName.CTAG);
        principalsProps.add(CSDavPropertyName.SOURCE);
        principalsProps.add(CSDavPropertyName.SUBSCRIBED_STRIP_ALARMS);
        principalsProps.add(CSDavPropertyName.SUBSCRIBED_STRIP_ATTACHMENTS);
        principalsProps.add(CSDavPropertyName.SUBSCRIBED_STRIP_TODOS);
        principalsProps.add(CSDavPropertyName.REFRESHRATE);
        principalsProps.add(CSDavPropertyName.PUSH_TRANSPORTS);
        principalsProps.add(CSDavPropertyName.PUSHKEY);
        principalsProps.add(ICalPropertyName.CALENDAR_COLOR);
        principalsProps.add(ICalPropertyName.CALENDAR_ORDER);
        return principalsProps;
    }

    public String toString() {
        return "Display Name: " + this.getDisplayName() + ", id: " + this.getId();
    }

    private String defaultUriFromUid(String uid) {
        return uid + ".ics";
    }
}

