/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fortuna.ical4j.connector.CalendarCollection;
import net.fortuna.ical4j.connector.CardStore;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.dav.AbstractDavObjectStore;
import net.fortuna.ical4j.connector.dav.CalDavConstants;
import net.fortuna.ical4j.connector.dav.CardDavCollection;
import net.fortuna.ical4j.connector.dav.DavConstants;
import net.fortuna.ical4j.connector.dav.PathResolver;
import net.fortuna.ical4j.connector.dav.property.CardDavPropertyName;
import net.fortuna.ical4j.model.Calendar;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.Status;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.report.ExpandPropertyReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CardDavStore
extends AbstractDavObjectStore<CardDavCollection>
implements CardStore<CardDavCollection> {
    private final String prodId;
    private String displayName;

    public CardDavStore(String prodId, URL url) {
        this(prodId, url, null);
    }

    public CardDavStore(String prodId, URL url, PathResolver pathResolver) {
        super(url, pathResolver);
        this.prodId = prodId;
    }

    @Override
    public CardDavCollection addCollection(String id) throws ObjectStoreException {
        CardDavCollection collection = new CardDavCollection(this, id);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    public CardDavCollection addCollection(String id, DavPropertySet properties) throws ObjectStoreException {
        CardDavCollection collection = new CardDavCollection(this, id, properties);
        try {
            collection.create();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to add collection '%s'", id), e);
        }
        return collection;
    }

    @Override
    public CardDavCollection getCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        try {
            DavPropertyNameSet principalsProps = CardDavCollection.propertiesForFetch();
            PropFindMethod getMethod = new PropFindMethod(id, principalsProps, 0);
            this.getClient().execute((HttpMethodBase)getMethod);
            MultiStatus multiStatus = getMethod.getResponseBodyAsMultiStatus();
            MultiStatusResponse[] responses = multiStatus.getResponses();
            return CardDavCollection.collectionsFromResponse(this, responses).get(0);
        }
        catch (IOException | DavException e) {
            throw new ObjectStoreException(String.format("unable to get collection '%s'", id), e);
        }
    }

    public CalendarCollection merge(String id, CalendarCollection calendar) {
        throw new UnsupportedOperationException("not implemented");
    }

    protected String findAddressBookHomeSet() throws ParserConfigurationException, IOException, DavException {
        String propfindUri = this.getHostURL() + this.pathResolver.getPrincipalPath(this.getUserName());
        return this.findAddressBookHomeSet(propfindUri);
    }

    protected String findAddressBookHomeSet(String propfindUri) throws ParserConfigurationException, IOException, DavException {
        DavPropertyNameSet principalsProps = new DavPropertyNameSet();
        principalsProps.add(CardDavPropertyName.ADDRESSBOOK_HOME_SET);
        principalsProps.add(DavPropertyName.DISPLAYNAME);
        PropFindMethod method = new PropFindMethod(propfindUri, principalsProps, 0);
        this.getClient().execute((HttpMethodBase)method);
        MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] responses = multiStatus.getResponses();
        for (int i = 0; i < responses.length; ++i) {
            for (int j = 0; j < responses[i].getStatus().length; ++j) {
                Status status = responses[i].getStatus()[j];
                DavPropertyIterator iNames = responses[i].getProperties(status.getStatusCode()).iterator();
                while (iNames.hasNext()) {
                    Node child;
                    DavProperty name = iNames.nextProperty();
                    if (!name.getName().getName().equals("addressbook-home-set") || !CalDavConstants.CARDDAV_NAMESPACE.isSame(name.getName().getNamespace().getURI())) continue;
                    if (name.getValue() instanceof ArrayList) {
                        for (Object child2 : (ArrayList)name.getValue()) {
                            if (!(child2 instanceof Element)) continue;
                            String calendarHomeSetUri = ((Element)child2).getTextContent();
                            if (!calendarHomeSetUri.endsWith("/")) {
                                calendarHomeSetUri = calendarHomeSetUri + "/";
                            }
                            return calendarHomeSetUri;
                        }
                    }
                    if (!(name.getValue() instanceof Node) || !((child = (Node)name.getValue()) instanceof Element)) continue;
                    String calendarHomeSetUri = ((Element)child).getTextContent();
                    if (!calendarHomeSetUri.endsWith("/")) {
                        calendarHomeSetUri = calendarHomeSetUri + "/";
                    }
                    return calendarHomeSetUri;
                }
            }
        }
        return null;
    }

    @Override
    public List<CardDavCollection> getCollections() throws ObjectStoreException, ObjectNotFoundException {
        try {
            String calHomeSetUri = this.findAddressBookHomeSet();
            if (calHomeSetUri == null) {
                throw new ObjectNotFoundException("No addressbook-home-set attribute found for the user");
            }
            String urlForcalendarHomeSet = this.getHostURL() + calHomeSetUri;
            return this.getCollectionsForHomeSet(this, urlForcalendarHomeSet);
        }
        catch (IOException | ParserConfigurationException | DavException e) {
            throw new ObjectStoreException(e);
        }
    }

    protected List<CardDavCollection> getCollectionsForHomeSet(CardDavStore store, String urlForcalendarHomeSet) throws IOException, DavException {
        ArrayList collections = new ArrayList();
        DavPropertyNameSet principalsProps = CardDavCollection.propertiesForFetch();
        PropFindMethod method = new PropFindMethod(urlForcalendarHomeSet, principalsProps, 1);
        this.getClient().execute((HttpMethodBase)method);
        MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] responses = multiStatus.getResponses();
        return CardDavCollection.collectionsFromResponse(store, responses);
    }

    protected List<CardDavCollection> getDelegateCollections(DavProperty<?> proxyDavProperty) throws ParserConfigurationException, IOException, DavException {
        if (proxyDavProperty != null) {
            Object propertyValue = proxyDavProperty.getValue();
            if (propertyValue instanceof ArrayList) {
                ArrayList response = (ArrayList)proxyDavProperty.getValue();
                if (response != null) {
                    for (Node objectInArray : response) {
                        DefaultDavProperty newProperty;
                        if (!(objectInArray instanceof Element) || !(newProperty = DefaultDavProperty.createFromXml((Element)((Element)objectInArray))).getName().getName().equals("response") || !newProperty.getName().getNamespace().equals((Object)DavConstants.NAMESPACE)) continue;
                        ArrayList responseChilds = (ArrayList)newProperty.getValue();
                        for (Node responseChild : responseChilds) {
                            DefaultDavProperty responseChildElement;
                            if (!(responseChild instanceof Element) || !(responseChildElement = DefaultDavProperty.createFromXml((Element)((Element)responseChild))).getName().getName().equals("propstat")) continue;
                            ArrayList propStatChilds = (ArrayList)responseChildElement.getValue();
                            for (Node propStatChild : propStatChilds) {
                                DefaultDavProperty propStatChildElement;
                                if (!(propStatChild instanceof Element) || !(propStatChildElement = DefaultDavProperty.createFromXml((Element)((Element)propStatChild))).getName().getName().equals("prop")) continue;
                                ArrayList propChilds = (ArrayList)propStatChildElement.getValue();
                                for (Node propChild : propChilds) {
                                    DefaultDavProperty propChildElement;
                                    if (!(propChild instanceof Element) || !(propChildElement = DefaultDavProperty.createFromXml((Element)((Element)propChild))).getName().equals((Object)SecurityConstants.PRINCIPAL_URL)) continue;
                                    ArrayList principalUrlChilds = (ArrayList)propChildElement.getValue();
                                    for (Node principalUrlChild : principalUrlChilds) {
                                        DefaultDavProperty principalUrlElement;
                                        if (!(principalUrlChild instanceof Element) || !(principalUrlElement = DefaultDavProperty.createFromXml((Element)((Element)principalUrlChild))).getName().getName().equals("href")) continue;
                                        String principalsUri = (String)principalUrlElement.getValue();
                                        String urlForcalendarHomeSet = this.findAddressBookHomeSet(this.getHostURL() + principalsUri);
                                        return this.getCollectionsForHomeSet(this, urlForcalendarHomeSet);
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (propertyValue instanceof Element) {
                System.out.println(((Element)propertyValue).getNodeName());
                System.out.println(((Element)propertyValue).getChildNodes());
            }
        }
        return new ArrayList<CardDavCollection>();
    }

    public List<CardDavCollection> getDelegatedCollections() throws Exception {
        ArrayList<CardDavCollection> collections = new ArrayList<CardDavCollection>();
        String methodUri = this.pathResolver.getPrincipalPath(this.getUserName());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element writeDisplayNameProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        writeDisplayNameProperty.setAttribute("name", "displayname");
        Element writePrincipalUrlProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        writePrincipalUrlProperty.setAttribute("name", SecurityConstants.PRINCIPAL_URL.getName());
        Element writeUserAddressSetProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        writeUserAddressSetProperty.setAttribute("name", "calendar-user-address-set");
        writeUserAddressSetProperty.setAttribute("namespace", CalDavConstants.NAMESPACE.getURI());
        Element proxyWriteForElement = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        proxyWriteForElement.setAttribute("name", "calendar-proxy-write-for");
        proxyWriteForElement.setAttribute("namespace", CalDavConstants.CS_NAMESPACE.getURI());
        proxyWriteForElement.appendChild(writeDisplayNameProperty);
        proxyWriteForElement.appendChild(writePrincipalUrlProperty);
        proxyWriteForElement.appendChild(writeUserAddressSetProperty);
        Element readDisplayNameProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        readDisplayNameProperty.setAttribute("name", "displayname");
        Element readPrincipalUrlProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        readPrincipalUrlProperty.setAttribute("name", SecurityConstants.PRINCIPAL_URL.getName());
        Element readUserAddressSetProperty = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        readUserAddressSetProperty.setAttribute("name", "calendar-user-address-set");
        readUserAddressSetProperty.setAttribute("namespace", CalDavConstants.NAMESPACE.getURI());
        Element proxyReadForElement = DomUtil.createElement((Document)document, (String)"property", (Namespace)DavConstants.NAMESPACE);
        proxyReadForElement.setAttribute("name", "calendar-proxy-read-for");
        proxyReadForElement.setAttribute("namespace", CalDavConstants.CS_NAMESPACE.getURI());
        proxyReadForElement.appendChild(readDisplayNameProperty);
        proxyReadForElement.appendChild(readPrincipalUrlProperty);
        proxyReadForElement.appendChild(readUserAddressSetProperty);
        ReportInfo rinfo = new ReportInfo(ReportType.register((String)"expand-property", (Namespace)DeltaVConstants.NAMESPACE, ExpandPropertyReport.class), 0);
        rinfo.setContentElement(proxyWriteForElement);
        rinfo.setContentElement(proxyReadForElement);
        ReportMethod method = new ReportMethod(methodUri, rinfo);
        this.getClient().execute(this.getClient().hostConfiguration, (DavMethodBase)method);
        if (method.getStatusCode() == 207) {
            MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
            MultiStatusResponse[] responses = multiStatus.getResponses();
            for (int i = 0; i < responses.length; ++i) {
                DavPropertySet properties = responses[i].getProperties(200);
                DavProperty writeForProperty = properties.get("calendar-proxy-write-for", CalDavConstants.CS_NAMESPACE);
                collections.addAll(this.getDelegateCollections(writeForProperty));
                DavProperty readForProperty = properties.get("calendar-proxy-read-for", CalDavConstants.CS_NAMESPACE);
                collections.addAll(this.getDelegateCollections(readForProperty));
            }
        }
        return collections;
    }

    @Override
    public CardDavCollection removeCollection(String id) throws ObjectStoreException, ObjectNotFoundException {
        CardDavCollection collection = this.getCollection(id);
        try {
            collection.delete();
        }
        catch (IOException e) {
            throw new ObjectStoreException(String.format("unable to remove collection '%s'", id), e);
        }
        return collection;
    }

    final String getProdId() {
        return this.prodId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public CardDavCollection addCollection(String id, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        throw new UnsupportedOperationException("not implemented");
    }
}

