/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.dav.enums.SupportedFeature;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;

public class DavClient {
    protected HttpClient httpClient;
    private String principalPath;
    private String userPath;
    private final boolean preemptiveAuth;
    protected HostConfiguration hostConfiguration;

    public DavClient(URL url, String principalPath, String userPath) {
        this(url, principalPath, userPath, false);
    }

    public DavClient(URL url, String principalPath, String userPath, boolean preemptiveAuth) {
        this.principalPath = principalPath;
        this.userPath = userPath;
        this.preemptiveAuth = preemptiveAuth;
        Protocol protocol = Protocol.getProtocol((String)url.getProtocol());
        this.hostConfiguration = new HostConfiguration();
        this.hostConfiguration.setHost(url.getHost(), url.getPort(), protocol);
    }

    void begin() {
        this.httpClient = new HttpClient();
        this.httpClient.getParams().setAuthenticationPreemptive(this.preemptiveAuth);
    }

    ArrayList<SupportedFeature> begin(String bearerAuth) throws IOException, FailedOperationException {
        ArrayList<SupportedFeature> supportedFeatures = new ArrayList<SupportedFeature>();
        this.begin();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(DavPropertyName.RESOURCETYPE);
        props.add(CSDavPropertyName.CTAG);
        DavPropertyName owner = DavPropertyName.create((String)"owner", (Namespace)DavConstants.NAMESPACE);
        props.add(owner);
        PropFindMethod aGet = new PropFindMethod(this.principalPath, 0, props, 0);
        aGet.addRequestHeader("Authorization", "Bearer " + bearerAuth);
        aGet.setDoAuthentication(true);
        int status = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)aGet);
        if (status >= 300) {
            throw new FailedOperationException(String.format("Principals not found at [%s]", this.userPath));
        }
        Header[] davHeaders = aGet.getResponseHeaders("DAV");
        for (int headerIndex = 0; headerIndex < davHeaders.length; ++headerIndex) {
            Header header = davHeaders[headerIndex];
            HeaderElement[] elements = header.getElements();
            for (int elementIndex = 0; elementIndex < elements.length; ++elementIndex) {
                SupportedFeature supportedFeature;
                String feature = elements[elementIndex].getName();
                if (feature == null || (supportedFeature = SupportedFeature.findByDescription(feature)) == null) continue;
                supportedFeatures.add(supportedFeature);
            }
        }
        return supportedFeatures;
    }

    ArrayList<SupportedFeature> begin(String username, char[] password) throws IOException, FailedOperationException {
        ArrayList<SupportedFeature> supportedFeatures = new ArrayList<SupportedFeature>();
        this.begin();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, new String(password));
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        this.httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(DavPropertyName.RESOURCETYPE);
        props.add(CSDavPropertyName.CTAG);
        DavPropertyName owner = DavPropertyName.create((String)"owner", (Namespace)DavConstants.NAMESPACE);
        props.add(owner);
        PropFindMethod aGet = new PropFindMethod(this.principalPath, 0, props, 0);
        aGet.setDoAuthentication(true);
        int status = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)aGet);
        if (status >= 300) {
            throw new FailedOperationException(String.format("Principals not found at [%s]", this.userPath));
        }
        Header[] davHeaders = aGet.getResponseHeaders("DAV");
        for (int headerIndex = 0; headerIndex < davHeaders.length; ++headerIndex) {
            Header header = davHeaders[headerIndex];
            HeaderElement[] elements = header.getElements();
            for (int elementIndex = 0; elementIndex < elements.length; ++elementIndex) {
                SupportedFeature supportedFeature;
                String feature = elements[elementIndex].getName();
                if (feature == null || (supportedFeature = SupportedFeature.findByDescription(feature)) == null) continue;
                supportedFeatures.add(supportedFeature);
            }
        }
        return supportedFeatures;
    }

    public int execute(HttpMethodBase method) throws IOException {
        return this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)method);
    }

    public int execute(HostConfiguration _hostConfiguration, DavMethodBase method) throws IOException {
        return this.httpClient.executeMethod(_hostConfiguration, (HttpMethod)method);
    }

    protected String getUserName() {
        return ((UsernamePasswordCredentials)this.httpClient.getState().getCredentials(AuthScope.ANY)).getUserName();
    }
}

