/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.enums;

import java.util.HashSet;
import java.util.Set;

public enum MediaType {
    ICALENDAR_2_0("text/calendar", "2.0"),
    VCARD_4_0("text/vcard", "4.0");

    private String contentType;
    private String version;
    private static Set<String> index;

    private MediaType(String contentType, String version) {
        this.contentType = contentType;
        this.version = version;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getVersion() {
        return this.version;
    }

    public static MediaType findByContentTypeAndVersion(String contentType, String version) {
        for (MediaType feature : MediaType.values()) {
            if (!feature.getContentType().equals(contentType) || !feature.getVersion().equals(version)) continue;
            return feature;
        }
        return null;
    }

    static {
        index = new HashSet<String>();
        for (MediaType mediaType : MediaType.values()) {
            index.add(mediaType.getContentType());
        }
    }
}

