/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.CompanyDepartment;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.TradingNamePrintingSettings;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.crm.db.CrmConfig;
import com.axelor.apps.sale.db.SaleConfig;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_COMPANY", indexes={@Index(columnList="address"), @Index(columnList="partner"), @Index(columnList="parent"), @Index(columnList="logo"), @Index(columnList="currency"), @Index(columnList="default_bank_details"), @Index(columnList="printing_settings"), @Index(columnList="weekly_planning"), @Index(columnList="public_holiday_events_planning"), @Index(columnList="language")})
public class Company
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_COMPANY_SEQ")
    @SequenceGenerator(name="BASE_COMPANY_SEQ", sequenceName="BASE_COMPANY_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Name")
    @NotNull
    @Column(unique=true)
    private String name;
    @HashKey
    @Widget(title="Code")
    @NotNull
    @Column(unique=true)
    private String code;
    @Widget(title="Address", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address address;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Parent company", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company parent;
    @Widget(title="Company departments")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CompanyDepartment> companyDepartmentList;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String notes;
    @Widget(title="Logo")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile logo;
    @Widget(title="Currency", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Customers payment delay (Average in days)")
    private BigDecimal customerPaymentDelay = BigDecimal.ZERO;
    @Widget(title="Suppliers payment delay (Average in days)")
    private BigDecimal supplierPaymentDelay = BigDecimal.ZERO;
    @Widget(title="Default Bank Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails defaultBankDetails;
    @Widget(title="Bank accounts")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<BankDetails> bankDetailsSet;
    @Widget(title="Printing Settings", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PrintingSettings printingSettings;
    @Widget(title="Partner Type", selection="company.partner.type.select", massUpdate=true)
    private Integer defaultPartnerTypeSelect = 1;
    @Widget(title="Trading names")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TradingName> tradingNameSet;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TradingNamePrintingSettings> tradingNamePrintingSettingsList;
    @Widget(massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WeeklyPlanning weeklyPlanning;
    @Widget(title="Public Holiday Planning", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EventsPlanning publicHolidayEventsPlanning;
    @Widget(title="Language", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Language language;
    @Widget(title="Width")
    @Min(value=0L)
    private Integer width = 0;
    @Widget(title="Height", help="Maximum height should be 60 px.")
    @Min(value=0L)
    @Max(value=60L)
    private Integer height = 0;
    @Widget(title="CRM config")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CrmConfig crmConfig;
    @Widget(title="Sale config")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="company", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private SaleConfig saleConfig;
    @Widget(multiline=true, massUpdate=true)
    private String orderBloquedMessage;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Company() {
    }

    public Company(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Company getParent() {
        return this.parent;
    }

    public void setParent(Company parent) {
        this.parent = parent;
    }

    public List<CompanyDepartment> getCompanyDepartmentList() {
        return this.companyDepartmentList;
    }

    public void setCompanyDepartmentList(List<CompanyDepartment> companyDepartmentList) {
        this.companyDepartmentList = companyDepartmentList;
    }

    public void addCompanyDepartmentListItem(CompanyDepartment item) {
        if (this.getCompanyDepartmentList() == null) {
            this.setCompanyDepartmentList(new ArrayList<CompanyDepartment>());
        }
        this.getCompanyDepartmentList().add(item);
        item.setCompany(this);
    }

    public void removeCompanyDepartmentListItem(CompanyDepartment item) {
        if (this.getCompanyDepartmentList() == null) {
            return;
        }
        this.getCompanyDepartmentList().remove(item);
    }

    public void clearCompanyDepartmentList() {
        if (this.getCompanyDepartmentList() != null) {
            this.getCompanyDepartmentList().clear();
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public MetaFile getLogo() {
        return this.logo;
    }

    public void setLogo(MetaFile logo) {
        this.logo = logo;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal getCustomerPaymentDelay() {
        return this.customerPaymentDelay == null ? BigDecimal.ZERO : this.customerPaymentDelay;
    }

    public void setCustomerPaymentDelay(BigDecimal customerPaymentDelay) {
        this.customerPaymentDelay = customerPaymentDelay;
    }

    public BigDecimal getSupplierPaymentDelay() {
        return this.supplierPaymentDelay == null ? BigDecimal.ZERO : this.supplierPaymentDelay;
    }

    public void setSupplierPaymentDelay(BigDecimal supplierPaymentDelay) {
        this.supplierPaymentDelay = supplierPaymentDelay;
    }

    public BankDetails getDefaultBankDetails() {
        return this.defaultBankDetails;
    }

    public void setDefaultBankDetails(BankDetails defaultBankDetails) {
        this.defaultBankDetails = defaultBankDetails;
    }

    public Set<BankDetails> getBankDetailsSet() {
        return this.bankDetailsSet;
    }

    public void setBankDetailsSet(Set<BankDetails> bankDetailsSet) {
        this.bankDetailsSet = bankDetailsSet;
    }

    public void addBankDetailsSetItem(BankDetails item) {
        if (this.getBankDetailsSet() == null) {
            this.setBankDetailsSet(new HashSet<BankDetails>());
        }
        this.getBankDetailsSet().add(item);
    }

    public void removeBankDetailsSetItem(BankDetails item) {
        if (this.getBankDetailsSet() == null) {
            return;
        }
        this.getBankDetailsSet().remove(item);
    }

    public void clearBankDetailsSet() {
        if (this.getBankDetailsSet() != null) {
            this.getBankDetailsSet().clear();
        }
    }

    public PrintingSettings getPrintingSettings() {
        return this.printingSettings;
    }

    public void setPrintingSettings(PrintingSettings printingSettings) {
        this.printingSettings = printingSettings;
    }

    public Integer getDefaultPartnerTypeSelect() {
        return this.defaultPartnerTypeSelect == null ? 0 : this.defaultPartnerTypeSelect;
    }

    public void setDefaultPartnerTypeSelect(Integer defaultPartnerTypeSelect) {
        this.defaultPartnerTypeSelect = defaultPartnerTypeSelect;
    }

    public Set<TradingName> getTradingNameSet() {
        return this.tradingNameSet;
    }

    public void setTradingNameSet(Set<TradingName> tradingNameSet) {
        this.tradingNameSet = tradingNameSet;
    }

    public void addTradingNameSetItem(TradingName item) {
        if (this.getTradingNameSet() == null) {
            this.setTradingNameSet(new HashSet<TradingName>());
        }
        this.getTradingNameSet().add(item);
    }

    public void removeTradingNameSetItem(TradingName item) {
        if (this.getTradingNameSet() == null) {
            return;
        }
        this.getTradingNameSet().remove(item);
    }

    public void clearTradingNameSet() {
        if (this.getTradingNameSet() != null) {
            this.getTradingNameSet().clear();
        }
    }

    public List<TradingNamePrintingSettings> getTradingNamePrintingSettingsList() {
        return this.tradingNamePrintingSettingsList;
    }

    public void setTradingNamePrintingSettingsList(List<TradingNamePrintingSettings> tradingNamePrintingSettingsList) {
        this.tradingNamePrintingSettingsList = tradingNamePrintingSettingsList;
    }

    public void addTradingNamePrintingSettingsListItem(TradingNamePrintingSettings item) {
        if (this.getTradingNamePrintingSettingsList() == null) {
            this.setTradingNamePrintingSettingsList(new ArrayList<TradingNamePrintingSettings>());
        }
        this.getTradingNamePrintingSettingsList().add(item);
        item.setCompany(this);
    }

    public void removeTradingNamePrintingSettingsListItem(TradingNamePrintingSettings item) {
        if (this.getTradingNamePrintingSettingsList() == null) {
            return;
        }
        this.getTradingNamePrintingSettingsList().remove(item);
    }

    public void clearTradingNamePrintingSettingsList() {
        if (this.getTradingNamePrintingSettingsList() != null) {
            this.getTradingNamePrintingSettingsList().clear();
        }
    }

    public WeeklyPlanning getWeeklyPlanning() {
        return this.weeklyPlanning;
    }

    public void setWeeklyPlanning(WeeklyPlanning weeklyPlanning) {
        this.weeklyPlanning = weeklyPlanning;
    }

    public EventsPlanning getPublicHolidayEventsPlanning() {
        return this.publicHolidayEventsPlanning;
    }

    public void setPublicHolidayEventsPlanning(EventsPlanning publicHolidayEventsPlanning) {
        this.publicHolidayEventsPlanning = publicHolidayEventsPlanning;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Integer getWidth() {
        return this.width == null ? 0 : this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height == null ? 0 : this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public CrmConfig getCrmConfig() {
        return this.crmConfig;
    }

    public void setCrmConfig(CrmConfig crmConfig) {
        this.crmConfig = crmConfig;
    }

    public SaleConfig getSaleConfig() {
        return this.saleConfig;
    }

    public void setSaleConfig(SaleConfig saleConfig) {
        this.saleConfig = saleConfig;
    }

    public String getOrderBloquedMessage() {
        return this.orderBloquedMessage;
    }

    public void setOrderBloquedMessage(String orderBloquedMessage) {
        this.orderBloquedMessage = orderBloquedMessage;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Company)) {
            return false;
        }
        Company other = (Company)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-1679829923, this.getName(), this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).add("customerPaymentDelay", (Object)this.getCustomerPaymentDelay()).add("supplierPaymentDelay", (Object)this.getSupplierPaymentDelay()).add("defaultPartnerTypeSelect", (Object)this.getDefaultPartnerTypeSelect()).add("width", (Object)this.getWidth()).add("height", (Object)this.getHeight()).add("orderBloquedMessage", (Object)this.getOrderBloquedMessage()).omitNullValues().toString();
    }
}

