/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Duration;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="SALE_SALE_CONFIG", indexes={@Index(columnList="default_validity_duration")})
@Track(fields={@TrackField(name="company", on={TrackEvent.UPDATE}), @TrackField(name="saleOrderInAtiSelect", on={TrackEvent.UPDATE}), @TrackField(name="defaultValidityDuration", on={TrackEvent.UPDATE}), @TrackField(name="acceptedCredit", on={TrackEvent.UPDATE}), @TrackField(name="displaySalemanOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayDelCondOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayProductCodeOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayTaxDetailOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayEstimDelivDateOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayCustomerCodeOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="displayProductPictureOnPrinting", on={TrackEvent.UPDATE}), @TrackField(name="saleOrderClientBox", on={TrackEvent.UPDATE}), @TrackField(name="saleOrderLegalNote", on={TrackEvent.UPDATE}), @TrackField(name="isAnalyticDistributionRequired", on={TrackEvent.UPDATE})})
public class SaleConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SALE_SALE_CONFIG_SEQ")
    @SequenceGenerator(name="SALE_SALE_CONFIG_SEQ", sequenceName="SALE_SALE_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Company")
    @NotNull
    @JoinColumn(unique=true)
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Accepted Credit")
    private BigDecimal acceptedCredit = BigDecimal.ZERO;
    @Widget(title="Sale orders ATI/WT", selection="base.in.ati.select")
    private Integer saleOrderInAtiSelect = 1;
    @Widget(title="Client box in sale order", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String saleOrderClientBox;
    @Widget(title="Legal note on sale order", help="Short legal note to be displayed on sales order", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String saleOrderLegalNote;
    @Widget(title="Display saleman on printing")
    private Boolean displaySalemanOnPrinting = Boolean.FALSE;
    @Widget(title="Display delivery condition on printing")
    private Boolean displayDelCondOnPrinting = Boolean.FALSE;
    @Widget(title="Display product code on printing")
    private Boolean displayProductCodeOnPrinting = Boolean.FALSE;
    @Widget(title="Display tax detail on printing")
    private Boolean displayTaxDetailOnPrinting = Boolean.FALSE;
    @Widget(title="Display estimated delivery dates on printing")
    private Boolean displayEstimDelivDateOnPrinting = Boolean.FALSE;
    @Widget(title="Display customer code on printing")
    private Boolean displayCustomerCodeOnPrinting = Boolean.FALSE;
    @Widget(title="Display product picture on printing")
    private Boolean displayProductPictureOnPrinting = Boolean.FALSE;
    @Widget(title="Validity duration per default")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Duration defaultValidityDuration;
    @Widget(title="Analytic distribution required on sale order line")
    private Boolean isAnalyticDistributionRequired = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public BigDecimal getAcceptedCredit() {
        return this.acceptedCredit == null ? BigDecimal.ZERO : this.acceptedCredit;
    }

    public void setAcceptedCredit(BigDecimal acceptedCredit) {
        this.acceptedCredit = acceptedCredit;
    }

    public Integer getSaleOrderInAtiSelect() {
        return this.saleOrderInAtiSelect == null ? 0 : this.saleOrderInAtiSelect;
    }

    public void setSaleOrderInAtiSelect(Integer saleOrderInAtiSelect) {
        this.saleOrderInAtiSelect = saleOrderInAtiSelect;
    }

    public String getSaleOrderClientBox() {
        return this.saleOrderClientBox;
    }

    public void setSaleOrderClientBox(String saleOrderClientBox) {
        this.saleOrderClientBox = saleOrderClientBox;
    }

    public String getSaleOrderLegalNote() {
        return this.saleOrderLegalNote;
    }

    public void setSaleOrderLegalNote(String saleOrderLegalNote) {
        this.saleOrderLegalNote = saleOrderLegalNote;
    }

    public Boolean getDisplaySalemanOnPrinting() {
        return this.displaySalemanOnPrinting == null ? Boolean.FALSE : this.displaySalemanOnPrinting;
    }

    public void setDisplaySalemanOnPrinting(Boolean displaySalemanOnPrinting) {
        this.displaySalemanOnPrinting = displaySalemanOnPrinting;
    }

    public Boolean getDisplayDelCondOnPrinting() {
        return this.displayDelCondOnPrinting == null ? Boolean.FALSE : this.displayDelCondOnPrinting;
    }

    public void setDisplayDelCondOnPrinting(Boolean displayDelCondOnPrinting) {
        this.displayDelCondOnPrinting = displayDelCondOnPrinting;
    }

    public Boolean getDisplayProductCodeOnPrinting() {
        return this.displayProductCodeOnPrinting == null ? Boolean.FALSE : this.displayProductCodeOnPrinting;
    }

    public void setDisplayProductCodeOnPrinting(Boolean displayProductCodeOnPrinting) {
        this.displayProductCodeOnPrinting = displayProductCodeOnPrinting;
    }

    public Boolean getDisplayTaxDetailOnPrinting() {
        return this.displayTaxDetailOnPrinting == null ? Boolean.FALSE : this.displayTaxDetailOnPrinting;
    }

    public void setDisplayTaxDetailOnPrinting(Boolean displayTaxDetailOnPrinting) {
        this.displayTaxDetailOnPrinting = displayTaxDetailOnPrinting;
    }

    public Boolean getDisplayEstimDelivDateOnPrinting() {
        return this.displayEstimDelivDateOnPrinting == null ? Boolean.FALSE : this.displayEstimDelivDateOnPrinting;
    }

    public void setDisplayEstimDelivDateOnPrinting(Boolean displayEstimDelivDateOnPrinting) {
        this.displayEstimDelivDateOnPrinting = displayEstimDelivDateOnPrinting;
    }

    public Boolean getDisplayCustomerCodeOnPrinting() {
        return this.displayCustomerCodeOnPrinting == null ? Boolean.FALSE : this.displayCustomerCodeOnPrinting;
    }

    public void setDisplayCustomerCodeOnPrinting(Boolean displayCustomerCodeOnPrinting) {
        this.displayCustomerCodeOnPrinting = displayCustomerCodeOnPrinting;
    }

    public Boolean getDisplayProductPictureOnPrinting() {
        return this.displayProductPictureOnPrinting == null ? Boolean.FALSE : this.displayProductPictureOnPrinting;
    }

    public void setDisplayProductPictureOnPrinting(Boolean displayProductPictureOnPrinting) {
        this.displayProductPictureOnPrinting = displayProductPictureOnPrinting;
    }

    public Duration getDefaultValidityDuration() {
        return this.defaultValidityDuration;
    }

    public void setDefaultValidityDuration(Duration defaultValidityDuration) {
        this.defaultValidityDuration = defaultValidityDuration;
    }

    public Boolean getIsAnalyticDistributionRequired() {
        return this.isAnalyticDistributionRequired == null ? Boolean.FALSE : this.isAnalyticDistributionRequired;
    }

    public void setIsAnalyticDistributionRequired(Boolean isAnalyticDistributionRequired) {
        this.isAnalyticDistributionRequired = isAnalyticDistributionRequired;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SaleConfig)) {
            return false;
        }
        SaleConfig other = (SaleConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals((Object)this.getCompany(), (Object)other.getCompany());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{-1942586743, this.getCompany()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("acceptedCredit", (Object)this.getAcceptedCredit()).add("saleOrderInAtiSelect", (Object)this.getSaleOrderInAtiSelect()).add("displaySalemanOnPrinting", (Object)this.getDisplaySalemanOnPrinting()).add("displayDelCondOnPrinting", (Object)this.getDisplayDelCondOnPrinting()).add("displayProductCodeOnPrinting", (Object)this.getDisplayProductCodeOnPrinting()).add("displayTaxDetailOnPrinting", (Object)this.getDisplayTaxDetailOnPrinting()).add("displayEstimDelivDateOnPrinting", (Object)this.getDisplayEstimDelivDateOnPrinting()).add("displayCustomerCodeOnPrinting", (Object)this.getDisplayCustomerCodeOnPrinting()).add("displayProductPictureOnPrinting", (Object)this.getDisplayProductPictureOnPrinting()).add("isAnalyticDistributionRequired", (Object)this.getIsAnalyticDistributionRequired()).omitNullValues().toString();
    }
}

