/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.crm.db.Opportunity;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.saleorder.OpportunitySaleOrderService;
import com.axelor.apps.sale.service.saleorder.SaleOrderCreateService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;

public class OpportunitySaleOrderServiceImpl
implements OpportunitySaleOrderService {
    @Inject
    protected SaleOrderCreateService saleOrderCreateService;
    @Inject
    protected SaleOrderRepository saleOrderRepo;
    @Inject
    protected AppBaseService appBaseService;

    @Override
    @Transactional(rollbackOn={Exception.class})
    public SaleOrder createSaleOrderFromOpportunity(Opportunity opportunity) throws AxelorException {
        Currency currency = opportunity.getCurrency() != null ? opportunity.getCurrency() : (opportunity.getPartner() != null && opportunity.getPartner().getCurrency() != null ? opportunity.getPartner().getCurrency() : opportunity.getCompany().getCurrency());
        SaleOrder saleOrder = this.createSaleOrder(opportunity, currency);
        opportunity.addSaleOrderListItem(saleOrder);
        if (opportunity.getSalesStageSelect() < 3) {
            opportunity.setSalesStageSelect(3);
        }
        saleOrder.setTradingName(opportunity.getTradingName());
        this.saleOrderRepo.save((Model)((Object)saleOrder));
        return saleOrder;
    }

    protected SaleOrder createSaleOrder(Opportunity opportunity, Currency currency) throws AxelorException {
        return this.saleOrderCreateService.createSaleOrder(opportunity.getUser(), opportunity.getCompany(), null, currency, null, opportunity.getName(), null, this.appBaseService.getTodayDate(), ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(opportunity.getPartner(), 1), opportunity.getPartner(), opportunity.getTeam());
    }
}

