/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.sale.service.saleorder;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.service.PartnerPriceListService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.apps.sale.db.SaleOrder;
import com.axelor.apps.sale.db.SaleOrderLine;
import com.axelor.apps.sale.db.repo.SaleOrderRepository;
import com.axelor.apps.sale.service.app.AppSaleService;
import com.axelor.apps.sale.service.saleorder.SaleOrderComputeService;
import com.axelor.apps.sale.service.saleorder.SaleOrderCreateService;
import com.axelor.apps.sale.service.saleorder.SaleOrderLineService;
import com.axelor.apps.sale.service.saleorder.SaleOrderService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.team.db.Team;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderCreateServiceImpl
implements SaleOrderCreateService {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PartnerService partnerService;
    protected SaleOrderRepository saleOrderRepo;
    protected AppSaleService appSaleService;
    protected SaleOrderService saleOrderService;
    protected SaleOrderComputeService saleOrderComputeService;

    @Inject
    public SaleOrderCreateServiceImpl(PartnerService partnerService, SaleOrderRepository saleOrderRepo, AppSaleService appSaleService, SaleOrderService saleOrderService, SaleOrderComputeService saleOrderComputeService) {
        this.partnerService = partnerService;
        this.saleOrderRepo = saleOrderRepo;
        this.appSaleService = appSaleService;
        this.saleOrderService = saleOrderService;
        this.saleOrderComputeService = saleOrderComputeService;
    }

    @Override
    public SaleOrder createSaleOrder(Company company) throws AxelorException {
        SaleOrder saleOrder = new SaleOrder();
        saleOrder.setCreationDate(this.appSaleService.getTodayDate());
        if (company != null) {
            saleOrder.setCompany(company);
            saleOrder.setCurrency(company.getCurrency());
        }
        saleOrder.setSalemanUser(AuthUtils.getUser());
        saleOrder.setTeam(saleOrder.getSalemanUser().getActiveTeam());
        saleOrder.setStatusSelect(1);
        this.saleOrderService.computeEndOfValidityDate(saleOrder);
        return saleOrder;
    }

    @Override
    public SaleOrder createSaleOrder(User salemanUser, Company company, Partner contactPartner, Currency currency, LocalDate deliveryDate, String internalReference, String externalReference, LocalDate orderDate, PriceList priceList, Partner clientPartner, Team team) throws AxelorException {
        this.logger.debug("Cr\u00e9ation d'un devis client : Soci\u00e9t\u00e9 = {},  Reference externe = {}, Client = {}", new Object[]{company, externalReference, clientPartner.getFullName()});
        SaleOrder saleOrder = new SaleOrder();
        saleOrder.setClientPartner(clientPartner);
        saleOrder.setCreationDate(this.appSaleService.getTodayDate());
        saleOrder.setContactPartner(contactPartner);
        saleOrder.setCurrency(currency);
        saleOrder.setExternalReference(externalReference);
        saleOrder.setDeliveryDate(deliveryDate);
        saleOrder.setOrderDate(orderDate);
        saleOrder.setPrintingSettings(((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(null, company));
        if (salemanUser == null) {
            salemanUser = AuthUtils.getUser();
        }
        saleOrder.setSalemanUser(salemanUser);
        if (team == null) {
            team = salemanUser.getActiveTeam();
        }
        saleOrder.setTeam(team);
        if (company == null) {
            company = salemanUser.getActiveCompany();
        }
        saleOrder.setCompany(company);
        saleOrder.setMainInvoicingAddress(this.partnerService.getInvoicingAddress(clientPartner));
        saleOrder.setDeliveryAddress(this.partnerService.getDeliveryAddress(clientPartner));
        this.saleOrderService.computeAddressStr(saleOrder);
        if (priceList == null) {
            priceList = ((PartnerPriceListService)Beans.get(PartnerPriceListService.class)).getDefaultPriceList(clientPartner, 1);
        }
        saleOrder.setPriceList(priceList);
        saleOrder.setSaleOrderLineList(new ArrayList<SaleOrderLine>());
        saleOrder.setStatusSelect(1);
        this.saleOrderService.computeEndOfValidityDate(saleOrder);
        return saleOrder;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public SaleOrder mergeSaleOrders(List<SaleOrder> saleOrderList, Currency currency, Partner clientPartner, Company company, Partner contactPartner, PriceList priceList, Team team) throws AxelorException {
        String numSeq = "";
        String externalRef = "";
        for (SaleOrder saleOrderLocal : saleOrderList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            numSeq = numSeq + saleOrderLocal.getSaleOrderSeq();
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (saleOrderLocal.getExternalReference() == null) continue;
            externalRef = externalRef + saleOrderLocal.getExternalReference();
        }
        SaleOrder saleOrderMerged = this.createSaleOrder(AuthUtils.getUser(), company, contactPartner, currency, null, numSeq, externalRef, LocalDate.now(), priceList, clientPartner, team);
        this.attachToNewSaleOrder(saleOrderList, saleOrderMerged);
        this.saleOrderComputeService.computeSaleOrder(saleOrderMerged);
        this.saleOrderRepo.save((Model)((Object)saleOrderMerged));
        this.removeOldSaleOrders(saleOrderList);
        return saleOrderMerged;
    }

    protected void attachToNewSaleOrder(List<SaleOrder> saleOrderList, SaleOrder saleOrderMerged) {
        for (SaleOrder saleOrder : saleOrderList) {
            int countLine = 1;
            for (SaleOrderLine saleOrderLine : saleOrder.getSaleOrderLineList()) {
                saleOrderLine.setSequence(countLine * 10);
                saleOrderMerged.addSaleOrderLineListItem(saleOrderLine);
                ++countLine;
            }
        }
    }

    protected void removeOldSaleOrders(List<SaleOrder> saleOrderList) {
        for (SaleOrder saleOrder : saleOrderList) {
            this.saleOrderRepo.remove((Model)((Object)saleOrder));
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public SaleOrder createSaleOrder(SaleOrder context, Currency wizardCurrency, PriceList wizardPriceList) throws AxelorException {
        SaleOrder copy = (SaleOrder)((Object)this.saleOrderRepo.copy((Model)((Object)context), true));
        copy.setCreationDate(this.appSaleService.getTodayDate());
        copy.setCurrency(wizardCurrency);
        copy.setPriceList(wizardPriceList);
        this.saleOrderService.computeEndOfValidityDate(copy);
        this.updateSaleOrderLineList(copy);
        this.saleOrderComputeService.computeSaleOrder(copy);
        copy.setTemplate(false);
        copy.setTemplateUser(null);
        return copy;
    }

    @Override
    public void updateSaleOrderLineList(SaleOrder saleOrder) throws AxelorException {
        List<SaleOrderLine> saleOrderLineList = saleOrder.getSaleOrderLineList();
        if (saleOrderLineList != null) {
            for (SaleOrderLine saleOrderLine : saleOrderLineList) {
                ((SaleOrderLineService)Beans.get(SaleOrderLineService.class)).fillPrice(saleOrderLine, saleOrder, saleOrderLine.getPackPriceSelect());
                ((SaleOrderLineService)Beans.get(SaleOrderLineService.class)).computeValues(saleOrder, saleOrderLine);
            }
        }
    }

    @Override
    @Transactional
    public SaleOrder createTemplate(SaleOrder context) {
        SaleOrder copy = (SaleOrder)((Object)this.saleOrderRepo.copy((Model)((Object)context), true));
        copy.setTemplate(true);
        copy.setTemplateUser(AuthUtils.getUser());
        return copy;
    }
}

